/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import java.util.Arrays;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.toolbar.BackButton;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ForwardButton;

abstract class BrowserToolbarTabletBase
extends BrowserToolbar {
    protected final LinearLayout actionItemBar = (LinearLayout)this.findViewById(R.id.menu_items);
    protected final BackButton backButton = (BackButton)this.findViewById(R.id.back);
    protected final ForwardButton forwardButton;

    protected abstract void animateForwardButton(ForwardButtonAnimation var1);

    public BrowserToolbarTabletBase(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        BrowserToolbarTabletBase.setButtonEnabled(this.backButton, false);
        this.forwardButton = (ForwardButton)this.findViewById(R.id.forward);
        BrowserToolbarTabletBase.setButtonEnabled(this.forwardButton, false);
        this.initButtonListeners();
        this.focusOrder.addAll(Arrays.asList(this.tabsButton, this.backButton, this.forwardButton, this));
        this.focusOrder.addAll(this.urlDisplayLayout.getFocusOrder());
        this.focusOrder.addAll(Arrays.asList(this.actionItemBar, this.menuButton));
    }

    private void initButtonListeners() {
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doBack();
            }
        });
        this.backButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showBackHistory();
            }
        });
        this.forwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doForward();
            }
        });
        this.forwardButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showForwardHistory();
            }
        });
    }

    @Override
    protected boolean isTabsButtonOffscreen() {
        return false;
    }

    @Override
    public boolean addActionItem(View view) {
        this.actionItemBar.addView(view);
        return true;
    }

    @Override
    public void removeActionItem(View view) {
        this.actionItemBar.removeView(view);
    }

    @Override
    protected void updateNavigationButtons(Tab tab) {
        BrowserToolbarTabletBase.setButtonEnabled(this.backButton, this.canDoBack(tab));
        boolean bl = this.canDoForward(tab);
        if (this.forwardButton.isEnabled() != bl) {
            BrowserToolbarTabletBase.setButtonEnabled(this.forwardButton, bl);
            this.animateForwardButton(bl ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
        }
    }

    @Override
    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.backButton.setNextFocusDownId(n);
        this.forwardButton.setNextFocusDownId(n);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.backButton.setPrivateMode(bl);
        this.forwardButton.setPrivateMode(bl);
        for (int i = 0; i < this.actionItemBar.getChildCount(); ++i) {
            MenuItemActionBar menuItemActionBar = (MenuItemActionBar)this.actionItemBar.getChildAt(i);
            menuItemActionBar.setPrivateMode(bl);
        }
    }

    protected boolean canDoBack(Tab tab) {
        return tab.canDoBack() && !this.isEditing();
    }

    protected boolean canDoForward(Tab tab) {
        return tab.canDoForward() && !this.isEditing();
    }

    protected static void setButtonEnabled(ImageButton imageButton, boolean bl) {
        Drawable drawable2 = imageButton.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(bl ? 255 : 61);
        }
        imageButton.setEnabled(bl);
    }

    protected static enum ForwardButtonAnimation {
        SHOW,
        HIDE;

    }
}

