/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.widget.AbsoluteLayout;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mozilla.gecko.AndroidGamepadManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.CrashHandler;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoBatteryManager;
import org.mozilla.gecko.GeckoEditable;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoScreenOrientation;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GlobalHistory;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.SurfaceBits;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.mozglue.JNITarget;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.mozglue.generatorannotations.OptionalGeneratedParameter;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.prompts.PromptService;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSContainer;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ProxySelector;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoAppShell {
    private static final String LOGTAG = "GeckoAppShell";
    private static final boolean LOGGING = false;
    private static boolean restartScheduled;
    private static GeckoEditableListener editableListener;
    private static final CrashHandler CRASH_HANDLER;
    private static final Queue<GeckoEvent> PENDING_EVENTS;
    private static final Map<String, String> ALERT_COOKIES;
    private static volatile boolean locationHighAccuracyEnabled;
    static NotificationClient notificationClient;
    private static final int HIGH_MEMORY_DEVICE_THRESHOLD_MB = 768;
    private static int sDensityDpi;
    private static int sScreenDepth;
    private static final float[] DEFAULT_LAUNCHER_ICON_HSV;
    private static boolean sVibrationMaybePlaying;
    private static long sVibrationEndTime;
    private static Sensor gAccelerometerSensor;
    private static Sensor gLinearAccelerometerSensor;
    private static Sensor gGyroscopeSensor;
    private static Sensor gOrientationSensor;
    private static Sensor gProximitySensor;
    private static Sensor gLightSensor;
    private static final String GECKOREQUEST_RESPONSE_KEY = "response";
    public static final int WPL_STATE_START = 1;
    public static final int WPL_STATE_STOP = 16;
    public static final int WPL_STATE_IS_DOCUMENT = 131072;
    public static final int WPL_STATE_IS_NETWORK = 262144;
    public static final int LINK_TYPE_UNKNOWN = 0;
    public static final int LINK_TYPE_ETHERNET = 1;
    public static final int LINK_TYPE_USB = 2;
    public static final int LINK_TYPE_WIFI = 3;
    public static final int LINK_TYPE_WIMAX = 4;
    public static final int LINK_TYPE_2G = 5;
    public static final int LINK_TYPE_3G = 6;
    public static final int LINK_TYPE_4G = 7;
    private static LayerView sLayerView;
    private static final Object sEventAckLock;
    private static boolean sWaitingForEventAck;
    private static Runnable sCallbackRunnable;
    public static final String PLUGIN_ACTION = "android.webkit.PLUGIN";
    public static final String PLUGIN_PERMISSION = "android.webkit.permission.PLUGIN";
    private static final String PLUGIN_SYSTEM_LIB = "/system/lib/plugins/";
    private static final String PLUGIN_TYPE = "type";
    private static final String TYPE_NATIVE = "native";
    public static ArrayList<PackageInfo> mPackageInfoCache;
    private static ContextGetter sContextGetter;
    private static GeckoInterface sGeckoInterface;
    public static Camera sCamera;
    static int kPreferedFps;
    static byte[] sCameraBuffer;

    private GeckoAppShell() {
    }

    public static CrashHandler ensureCrashHandling() {
        return CRASH_HANDLER;
    }

    public static native void registerJavaUiThread();

    public static native void nativeInit();

    public static native void onResume();

    public static void callObserver(String string2, String string3, String string4) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createCallObserverEvent(string2, string3, string4));
    }

    public static void removeObserver(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createRemoveObserverEvent(string2));
    }

    public static native Message getNextMessageFromQueue(MessageQueue var0);

    public static native void onSurfaceTextureFrameAvailable(Object var0, int var1);

    public static native void dispatchMemoryPressure();

    private static native void reportJavaCrash(String var0);

    public static void notifyUriVisited(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createVisitedEvent(string2));
    }

    public static native void processNextNativeEvent(boolean var0);

    public static native void notifyBatteryChange(double var0, boolean var2, double var3);

    public static native void scheduleComposite();

    public static native void scheduleResumeComposition(int var0, int var1);

    public static native float computeRenderIntegrity();

    public static native SurfaceBits getSurfaceBits(Surface var0);

    public static native void onFullScreenPluginHidden(View var0);

    public static void setLayerView(LayerView layerView) {
        if (sLayerView == layerView) {
            return;
        }
        sLayerView = layerView;
        editableListener = new GeckoEditable();
    }

    @RobocopTarget
    public static LayerView getLayerView() {
        return sLayerView;
    }

    public static void runGecko(String string2, String string3, String string4, String string5) {
        MessageQueue.IdleHandler idleHandler = new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                Handler handler = ThreadUtils.sGeckoHandler;
                Message message = Message.obtain((Handler)handler);
                message.obj = handler;
                handler.sendMessageAtFrontOfQueue(message);
                return true;
            }
        };
        Looper.myQueue().addIdleHandler(idleHandler);
        GeckoAppShell.nativeInit();
        String string6 = string2 + " -greomni " + string2;
        if (string3 != null) {
            string6 = string6 + " " + string3;
        }
        if (string4 != null) {
            string6 = string6 + " -url " + string4;
        }
        if (string5 != null) {
            string6 = string6 + " " + string5;
        }
        DisplayMetrics displayMetrics = GeckoAppShell.getContext().getResources().getDisplayMetrics();
        string6 = string6 + " -width " + displayMetrics.widthPixels + " -height " + displayMetrics.heightPixels;
        GeckoLoader.nativeRun((String)string6);
        Looper.myQueue().removeIdleHandler(idleHandler);
    }

    static void sendPendingEventsToGecko() {
        try {
            while (!PENDING_EVENTS.isEmpty()) {
                GeckoEvent geckoEvent = PENDING_EVENTS.poll();
                GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @RobocopTarget
    public static void sendEventToGecko(GeckoEvent geckoEvent) {
        if (geckoEvent == null) {
            throw new IllegalArgumentException("e cannot be null.");
        }
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
            geckoEvent.recycle();
            return;
        }
        PENDING_EVENTS.add(geckoEvent);
    }

    @RobocopTarget
    public static void sendRequestToGecko(final GeckoRequest geckoRequest) {
        String string2 = "Gecko:Request" + geckoRequest.getId();
        EventDispatcher.getInstance().registerGeckoThreadListener(new NativeEventListener(){

            public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
                EventDispatcher.getInstance().unregisterGeckoThreadListener(this, string2);
                if (!nativeJSObject.has(GeckoAppShell.GECKOREQUEST_RESPONSE_KEY)) {
                    geckoRequest.onError();
                    return;
                }
                geckoRequest.onResponse(nativeJSObject.getObject(GeckoAppShell.GECKOREQUEST_RESPONSE_KEY));
            }
        }, string2);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(geckoRequest.getName(), geckoRequest.getData()));
    }

    public static native void notifyGeckoOfEvent(GeckoEvent var0);

    public static native void notifyGeckoObservers(String var0, String var1);

    @WrapElementForJNI(allowMultithread=true, noThrow=true)
    public static void handleUncaughtException(Thread thread, Throwable throwable) {
        CRASH_HANDLER.uncaughtException(thread, throwable);
    }

    @WrapElementForJNI
    public static void notifyIME(int n) {
        if (editableListener != null) {
            editableListener.notifyIME(n);
        }
    }

    @WrapElementForJNI
    public static void notifyIMEContext(int n, String string2, String string3, String string4) {
        if (editableListener != null) {
            editableListener.notifyIMEContext(n, string2, string3, string4);
        }
    }

    @WrapElementForJNI
    public static void notifyIMEChange(String string2, int n, int n2, int n3) {
        if (n3 < 0) {
            editableListener.onSelectionChange(n, n2);
        } else {
            editableListener.onTextChange(string2, n, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEventToGeckoSync(GeckoEvent geckoEvent) {
        geckoEvent.setAckNeeded(true);
        long l = SystemClock.uptimeMillis();
        boolean bl = ThreadUtils.isOnUiThread();
        Object object = sEventAckLock;
        synchronized (object) {
            if (sWaitingForEventAck) {
                Log.e((String)LOGTAG, (String)"geckoEventSync() may have been called twice concurrently!", (Throwable)new Exception());
            }
            GeckoAppShell.sendEventToGecko(geckoEvent);
            sWaitingForEventAck = true;
            while (true) {
                try {
                    sEventAckLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!sWaitingForEventAck) break;
                long l2 = SystemClock.uptimeMillis() - l;
                Log.d((String)LOGTAG, (String)("Gecko event sync taking too long: " + l2 + "ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI
    public static void acknowledgeEvent() {
        Object object = sEventAckLock;
        synchronized (object) {
            sWaitingForEventAck = false;
            sEventAckLock.notifyAll();
        }
    }

    private static native long runUiThreadCallback();

    @WrapElementForJNI(allowMultithread=true)
    private static void requestUiThreadCallback(long l) {
        ThreadUtils.getUiHandler().postDelayed(sCallbackRunnable, l);
    }

    private static float getLocationAccuracy(Location location) {
        float f = location.getAccuracy();
        return location.hasAccuracy() && f > 0.0f ? f : 1001.0f;
    }

    private static Location getLastKnownLocation(LocationManager locationManager) {
        Location location = null;
        List list = locationManager.getAllProviders();
        for (String string2 : list) {
            Location location2 = locationManager.getLastKnownLocation(string2);
            if (location2 == null) continue;
            if (location == null) {
                location = location2;
                continue;
            }
            long l = location2.getTime() - location.getTime();
            if (l <= 0L && (l != 0L || !(GeckoAppShell.getLocationAccuracy(location2) < GeckoAppShell.getLocationAccuracy(location)))) continue;
            location = location2;
        }
        return location;
    }

    @WrapElementForJNI
    public static void enableLocation(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LocationManager locationManager = GeckoAppShell.getLocationManager(GeckoAppShell.getContext());
                if (locationManager == null) {
                    return;
                }
                if (bl) {
                    Location location = GeckoAppShell.getLastKnownLocation(locationManager);
                    if (location != null) {
                        GeckoAppShell.getGeckoInterface().getLocationListener().onLocationChanged(location);
                    }
                    Criteria criteria = new Criteria();
                    criteria.setSpeedRequired(false);
                    criteria.setBearingRequired(false);
                    criteria.setAltitudeRequired(false);
                    if (locationHighAccuracyEnabled) {
                        criteria.setAccuracy(1);
                        criteria.setCostAllowed(true);
                        criteria.setPowerRequirement(3);
                    } else {
                        criteria.setAccuracy(2);
                        criteria.setCostAllowed(false);
                        criteria.setPowerRequirement(1);
                    }
                    String string2 = locationManager.getBestProvider(criteria, true);
                    if (string2 == null) {
                        return;
                    }
                    Looper looper = Looper.getMainLooper();
                    locationManager.requestLocationUpdates(string2, 100L, 0.5f, GeckoAppShell.getGeckoInterface().getLocationListener(), looper);
                } else {
                    locationManager.removeUpdates(GeckoAppShell.getGeckoInterface().getLocationListener());
                }
            }
        });
    }

    private static LocationManager getLocationManager(Context context) {
        try {
            return (LocationManager)context.getSystemService("location");
        }
        catch (NoSuchFieldError noSuchFieldError) {
            Log.e((String)LOGTAG, (String)"LOCATION_SERVICE not found?!", (Throwable)noSuchFieldError);
            return null;
        }
    }

    @WrapElementForJNI
    public static void enableLocationHighAccuracy(boolean bl) {
        locationHighAccuracyEnabled = bl;
    }

    @WrapElementForJNI
    public static void enableSensor(int n) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        SensorManager sensorManager = (SensorManager)GeckoAppShell.getContext().getSystemService("sensor");
        switch (n) {
            case 0: {
                if (gOrientationSensor == null) {
                    gOrientationSensor = sensorManager.getDefaultSensor(3);
                }
                if (gOrientationSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gOrientationSensor, 1);
                break;
            }
            case 1: {
                if (gAccelerometerSensor == null) {
                    gAccelerometerSensor = sensorManager.getDefaultSensor(1);
                }
                if (gAccelerometerSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gAccelerometerSensor, 1);
                break;
            }
            case 2: {
                if (gProximitySensor == null) {
                    gProximitySensor = sensorManager.getDefaultSensor(8);
                }
                if (gProximitySensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gProximitySensor, 3);
                break;
            }
            case 5: {
                if (gLightSensor == null) {
                    gLightSensor = sensorManager.getDefaultSensor(5);
                }
                if (gLightSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gLightSensor, 3);
                break;
            }
            case 3: {
                if (gLinearAccelerometerSensor == null) {
                    gLinearAccelerometerSensor = sensorManager.getDefaultSensor(10);
                }
                if (gLinearAccelerometerSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gLinearAccelerometerSensor, 1);
                break;
            }
            case 4: {
                if (gGyroscopeSensor == null) {
                    gGyroscopeSensor = sensorManager.getDefaultSensor(4);
                }
                if (gGyroscopeSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gGyroscopeSensor, 1);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Error! Can't enable unknown SENSOR type " + n));
            }
        }
    }

    @WrapElementForJNI
    public static void disableSensor(int n) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        SensorManager sensorManager = (SensorManager)GeckoAppShell.getContext().getSystemService("sensor");
        switch (n) {
            case 0: {
                if (gOrientationSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gOrientationSensor);
                break;
            }
            case 1: {
                if (gAccelerometerSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gAccelerometerSensor);
                break;
            }
            case 2: {
                if (gProximitySensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gProximitySensor);
                break;
            }
            case 5: {
                if (gLightSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gLightSensor);
                break;
            }
            case 3: {
                if (gLinearAccelerometerSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gLinearAccelerometerSensor);
                break;
            }
            case 4: {
                if (gGyroscopeSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gGyroscopeSensor);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Error! Can't disable unknown SENSOR type " + n));
            }
        }
    }

    @WrapElementForJNI
    public static void startMonitoringGamepad() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGamepadManager.startup();
            }
        });
    }

    @WrapElementForJNI
    public static void stopMonitoringGamepad() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGamepadManager.shutdown();
            }
        });
    }

    @WrapElementForJNI
    public static void gamepadAdded(final int n, final int n2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGamepadManager.gamepadAdded(n, n2);
            }
        });
    }

    @WrapElementForJNI
    public static void moveTaskToBack() {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().getActivity().moveTaskToBack(true);
        }
    }

    public static void returnIMEQueryResult(String string2, int n, int n2) {
    }

    @WrapElementForJNI(stubName="NotifyXreExit")
    static void onXreExit() {
        GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoExiting);
        if (GeckoAppShell.getGeckoInterface() != null) {
            if (restartScheduled) {
                GeckoAppShell.getGeckoInterface().doRestart();
            } else {
                GeckoAppShell.getGeckoInterface().getActivity().finish();
            }
        }
        GeckoAppShell.systemExit();
    }

    static void systemExit() {
        Log.d((String)LOGTAG, (String)"Killing via System.exit()");
        GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoExited);
        System.exit(0);
    }

    @WrapElementForJNI
    static void scheduleRestart() {
        restartScheduled = true;
    }

    @WrapElementForJNI
    static void createShortcut(final String string2, final String string3, final String string4) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = FaviconDecoder.getMostSuitableBitmapFromDataURI(string4, GeckoAppShell.getPreferredIconSize());
                GeckoAppShell.doCreateShortcut(string2, string3, bitmap);
            }
        });
    }

    public static void createShortcut(final String string2, final String string3, final Bitmap bitmap) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoAppShell.doCreateShortcut(string2, string3, bitmap);
            }
        });
    }

    private static void doCreateShortcut(String string2, String string3, Bitmap bitmap) {
        Intent intent = new Intent();
        intent.setAction("org.mozilla.gecko.BOOKMARK");
        intent.setData(Uri.parse((String)string3));
        intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
        Intent intent2 = new Intent();
        intent2.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
        intent2.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)GeckoAppShell.getLauncherIcon(bitmap));
        if (string2 != null) {
            intent2.putExtra("android.intent.extra.shortcut.NAME", string2);
        } else {
            intent2.putExtra("android.intent.extra.shortcut.NAME", string3);
        }
        intent2.putExtra("duplicate", false);
        intent2.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        GeckoAppShell.getContext().sendBroadcast(intent2);
    }

    @JNITarget
    public static int getPreferredIconSize() {
        if (AppConstants.Versions.feature11Plus) {
            ActivityManager activityManager = (ActivityManager)GeckoAppShell.getContext().getSystemService("activity");
            return activityManager.getLauncherLargeIconSize();
        }
        switch (GeckoAppShell.getDpi()) {
            case 160: {
                return 48;
            }
            case 320: {
                return 96;
            }
        }
        return 72;
    }

    private static Bitmap getLauncherIcon(Bitmap bitmap) {
        int n;
        int n2 = GeckoAppShell.getPreferredIconSize();
        int n3 = bitmap != null ? n2 * 2 / 3 : n2;
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        if (bitmap == null) {
            paint.setColor(Color.HSVToColor((float[])DEFAULT_LAUNCHER_ICON_HSV));
            canvas.drawRoundRect(new RectF(6.0f, 6.0f, (float)(n2 - 6), (float)(n2 - 6)), 5.0f, 5.0f, paint);
        } else {
            if (bitmap.getWidth() >= n3 || bitmap.getHeight() >= n3) {
                Rect rect = new Rect(0, 0, n2, n2);
                canvas.drawBitmap(bitmap, null, rect, null);
                return bitmap2;
            }
            int n4 = BitmapUtils.getDominantColor(bitmap);
            paint.setColor(n4);
            canvas.drawRoundRect(new RectF(6.0f, 6.0f, (float)(n2 - 6), (float)(n2 - 6)), 5.0f, 5.0f, paint);
            paint.setColor(Color.argb((int)100, (int)255, (int)255, (int)255));
            canvas.drawRoundRect(new RectF(6.0f, 6.0f, (float)(n2 - 6), (float)(n2 - 6)), 5.0f, 5.0f, paint);
        }
        Bitmap bitmap3 = BitmapUtils.decodeResource(GeckoAppShell.getContext(), R.drawable.home_bg);
        canvas.drawBitmap(bitmap3, null, new Rect(0, 0, n2, n2), null);
        if (bitmap == null) {
            bitmap = BitmapUtils.decodeResource(GeckoAppShell.getContext(), R.drawable.home_star);
        }
        int n5 = n = n3 / 2;
        int n6 = n2 / 2;
        canvas.drawBitmap(bitmap, null, new Rect(n6 - n, n6 - n5, n6 + n, n6 + n5), null);
        return bitmap2;
    }

    @WrapElementForJNI(stubName="GetHandlersForMimeTypeWrapper")
    static String[] getHandlersForMimeType(String string2, String string3) {
        Intent intent = GeckoAppShell.getIntentForActionString(string3);
        if (string2 != null && string2.length() > 0) {
            intent.setType(string2);
        }
        return GeckoAppShell.getHandlersForIntent(intent);
    }

    @WrapElementForJNI(stubName="GetHandlersForURLWrapper")
    static String[] getHandlersForURL(String string2, String string3) {
        Uri uri = string2.indexOf(58) >= 0 ? Uri.parse((String)string2) : new Uri.Builder().scheme(string2).build();
        Intent intent = GeckoAppShell.getOpenURIIntent(GeckoAppShell.getContext(), uri.toString(), "", TextUtils.isEmpty((CharSequence)string3) ? "android.intent.action.VIEW" : string3, "");
        return GeckoAppShell.getHandlersForIntent(intent);
    }

    static boolean hasHandlersForIntent(Intent intent) {
        try {
            PackageManager packageManager = GeckoAppShell.getContext().getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            return !list.isEmpty();
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Exception in GeckoAppShell.hasHandlersForIntent");
            return false;
        }
    }

    static String[] getHandlersForIntent(Intent intent) {
        try {
            PackageManager packageManager = GeckoAppShell.getContext().getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            int n = 4;
            String[] stringArray = new String[list.size() * n];
            for (int i = 0; i < list.size(); ++i) {
                ResolveInfo resolveInfo = (ResolveInfo)list.get(i);
                stringArray[i * n] = resolveInfo.loadLabel(packageManager).toString();
                stringArray[i * n + 1] = resolveInfo.isDefault ? "default" : "";
                stringArray[i * n + 2] = resolveInfo.activityInfo.applicationInfo.packageName;
                stringArray[i * n + 3] = resolveInfo.activityInfo.name;
            }
            return stringArray;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Exception in GeckoAppShell.getHandlersForIntent");
            return new String[0];
        }
    }

    static Intent getIntentForActionString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new Intent("android.intent.action.VIEW");
        }
        return new Intent(string2);
    }

    @WrapElementForJNI(stubName="GetExtensionFromMimeTypeWrapper")
    static String getExtensionFromMimeType(String string2) {
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(string2);
    }

    @WrapElementForJNI(stubName="GetMimeTypeFromExtensionsWrapper")
    static String getMimeTypeFromExtensions(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".,; ");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreElements()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            String string7 = GeckoAppShell.getMimeTypeFromExtension(string6);
            if (string7 == null) continue;
            int n = string7.indexOf(47);
            String string8 = string7.substring(0, n);
            if (!string8.equalsIgnoreCase(string3)) {
                String string9 = string3 = string3 == null ? string8 : "*";
            }
            if ((string5 = string7.substring(n + 1)).equalsIgnoreCase(string4)) continue;
            string4 = string4 == null ? string5 : "*";
        }
        if (string3 == null) {
            string3 = "*";
        }
        if (string4 == null) {
            string4 = "*";
        }
        return string3 + "/" + string4;
    }

    static void safeStreamClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static boolean isUriSafeForScheme(Uri uri) {
        String string2;
        String string3 = uri.getScheme();
        return !"tel".equals(string3) && !"sms".equals(string3) || !(string2 = uri.getSchemeSpecificPart()).contains("#") && !string2.contains("*") && uri.getFragment() == null;
    }

    @WrapElementForJNI
    public static boolean openUriExternal(String string2, String string3, @OptionalGeneratedParameter String string4, @OptionalGeneratedParameter String string5, @OptionalGeneratedParameter String string6, @OptionalGeneratedParameter String string7) {
        Context context = GeckoAppShell.getContext();
        Intent intent = GeckoAppShell.getOpenURIIntent(context, string2, string3, string6, string7);
        if (intent == null) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                intent.setClassName(string4, string5);
            } else {
                intent.setClassName(context, string5);
            }
        }
        intent.setFlags(0x4000000);
        try {
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return false;
        }
    }

    static Uri normalizeUriScheme(Uri uri) {
        String string2 = uri.getScheme();
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals(string2)) {
            return uri;
        }
        return uri.buildUpon().scheme(string3).build();
    }

    public static Intent getShareIntent(Context context, String string2, String string3, String string4) {
        Intent intent = GeckoAppShell.getIntentForActionString("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", string2);
        intent.putExtra("android.intent.extra.SUBJECT", string4);
        intent.putExtra("android.intent.extra.TITLE", string4);
        if (string3 != null && string3.length() > 0) {
            intent.setType(string3);
        }
        return intent;
    }

    static Intent getOpenURIIntent(Context context, String string2, String string3, String string4, String string5) {
        Object object;
        if (string4.equalsIgnoreCase("android.intent.action.SEND")) {
            Intent intent = GeckoAppShell.getShareIntent(context, string2, string3, string5);
            return Intent.createChooser((Intent)intent, (CharSequence)context.getResources().getString(R.string.share_title));
        }
        Uri uri = GeckoAppShell.normalizeUriScheme(string2.indexOf(58) >= 0 ? Uri.parse((String)string2) : new Uri.Builder().scheme(string2).build());
        if (string3.length() > 0) {
            Intent intent = GeckoAppShell.getIntentForActionString(string4);
            intent.setDataAndType(uri, string3);
            return intent;
        }
        if (!GeckoAppShell.isUriSafeForScheme(uri)) {
            return null;
        }
        String string6 = uri.getScheme();
        Intent intent = GeckoAppShell.getIntentForActionString(string4);
        intent.setData(uri);
        if ("vnd.youtube".equals(string6) && !GeckoAppShell.hasHandlersForIntent(intent) && !TextUtils.isEmpty((CharSequence)uri.getSchemeSpecificPart())) {
            try {
                object = Class.forName("org.mozilla.gecko.BrowserApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.wtf((String)LOGTAG, (String)"Class org.mozilla.gecko.BrowserApp not found!");
                return null;
            }
            Uri uri2 = GeckoAppShell.getYouTubeHTML5URI(uri);
            if (uri2 != null) {
                Intent intent2 = new Intent("org.mozilla.gecko.LOAD", uri2, context, (Class)object);
                return intent2;
            }
        }
        if (!"sms".equals(string6)) {
            return intent;
        }
        object = uri.getEncodedQuery();
        if (TextUtils.isEmpty((CharSequence)object)) {
            return intent;
        }
        String[] stringArray = ((String)object).split("&");
        boolean bl = false;
        String string7 = "";
        for (String string8 : stringArray) {
            if (bl || !string8.startsWith("body=")) {
                string7 = string7.concat(string7.length() > 0 ? "&" + string8 : string8);
                continue;
            }
            String string9 = Uri.decode((String)string8.substring(5));
            intent.putExtra("sms_body", string9);
            bl = true;
        }
        if (!bl) {
            return intent;
        }
        String string10 = string7.length() > 0 ? "?" + string7 : "";
        Uri uri2 = uri.buildUpon().encodedQuery(string10).build();
        intent.setData(uri2);
        return intent;
    }

    private static Uri getYouTubeHTML5URI(Uri uri) {
        if (uri == null) {
            return null;
        }
        String string2 = uri.getSchemeSpecificPart();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return Uri.parse((String)("https://www.youtube.com/embed/" + string2));
    }

    public static void setNotificationClient(NotificationClient notificationClient) {
        if (GeckoAppShell.notificationClient == null) {
            GeckoAppShell.notificationClient = notificationClient;
        } else {
            Log.d((String)LOGTAG, (String)"Notification client already set");
        }
    }

    @WrapElementForJNI(stubName="ShowAlertNotificationWrapper")
    public static void showAlertNotification(String string2, String string3, String string4, String string5, String string6) {
        String string7 = GeckoAppShell.getContext().getClass().getName();
        Intent intent = new Intent("org.mozilla.gecko.ACTION_ALERT_CALLBACK");
        intent.setClassName("org.mozilla.fennec", string7);
        intent.setFlags(0x10000000);
        int n = string6.hashCode();
        Uri.Builder builder = new Uri.Builder();
        Uri uri = builder.scheme("alert").path(Integer.toString(n)).appendQueryParameter("name", string6).appendQueryParameter("cookie", string5).build();
        intent.setData(uri);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)GeckoAppShell.getContext(), (int)0, (Intent)intent, (int)0x8000000);
        ALERT_COOKIES.put(string6, string5);
        GeckoAppShell.callObserver(string6, "alertshow", string5);
        notificationClient.add(n, string2, string3, string4, pendingIntent);
    }

    @WrapElementForJNI
    public static void alertsProgressListener_OnProgress(String string2, long l, long l2, String string3) {
        int n = string2.hashCode();
        notificationClient.update(n, l, l2, string3);
    }

    @WrapElementForJNI
    public static void closeNotification(String string2) {
        String string3 = ALERT_COOKIES.get(string2);
        if (string3 != null) {
            GeckoAppShell.callObserver(string2, "alertfinished", string3);
            ALERT_COOKIES.remove(string2);
        }
        GeckoAppShell.removeObserver(string2);
        int n = string2.hashCode();
        notificationClient.remove(n);
    }

    public static void handleNotification(String string2, String string3, String string4) {
        int n = string3.hashCode();
        if ("org.mozilla.gecko.ACTION_ALERT_CALLBACK".equals(string2)) {
            GeckoAppShell.callObserver(string3, "alertclickcallback", string4);
            if (notificationClient.isOngoing(n)) {
                return;
            }
        }
        GeckoAppShell.closeNotification(string3);
    }

    @WrapElementForJNI(stubName="GetDpiWrapper")
    public static int getDpi() {
        if (sDensityDpi == 0) {
            sDensityDpi = GeckoAppShell.getContext().getResources().getDisplayMetrics().densityDpi;
        }
        return sDensityDpi;
    }

    @WrapElementForJNI
    public static float getDensity() {
        return GeckoAppShell.getContext().getResources().getDisplayMetrics().density;
    }

    private static boolean isHighMemoryDevice() {
        return HardwareUtils.getMemSize() > 768;
    }

    @WrapElementForJNI(stubName="GetScreenDepthWrapper")
    public static synchronized int getScreenDepth() {
        if (sScreenDepth == 0) {
            sScreenDepth = 16;
            PixelFormat pixelFormat = new PixelFormat();
            PixelFormat.getPixelFormatInfo((int)GeckoAppShell.getGeckoInterface().getActivity().getWindowManager().getDefaultDisplay().getPixelFormat(), (PixelFormat)pixelFormat);
            if (pixelFormat.bitsPerPixel >= 24 && GeckoAppShell.isHighMemoryDevice()) {
                sScreenDepth = 24;
            }
        }
        return sScreenDepth;
    }

    public static synchronized void setScreenDepthOverride(int n) {
        if (sScreenDepth != 0) {
            Log.e((String)LOGTAG, (String)"Tried to override screen depth after it's already been set");
            return;
        }
        sScreenDepth = n;
    }

    @WrapElementForJNI
    public static void setFullScreen(boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().setFullScreen(bl);
        }
    }

    @WrapElementForJNI
    public static void performHapticFeedback(boolean bl) {
        if (!sVibrationMaybePlaying || System.nanoTime() >= sVibrationEndTime) {
            LayerView layerView = GeckoAppShell.getLayerView();
            layerView.performHapticFeedback(bl ? 0 : 1);
        }
    }

    private static Vibrator vibrator() {
        LayerView layerView = GeckoAppShell.getLayerView();
        return (Vibrator)layerView.getContext().getSystemService("vibrator");
    }

    @WrapElementForJNI(stubName="Vibrate1")
    public static void vibrate(long l) {
        sVibrationEndTime = System.nanoTime() + l * 1000000L;
        sVibrationMaybePlaying = true;
        GeckoAppShell.vibrator().vibrate(l);
    }

    @WrapElementForJNI(stubName="VibrateA")
    public static void vibrate(long[] lArray, int n) {
        long l = 0L;
        int n2 = lArray.length - (lArray.length % 2 == 0 ? 1 : 0);
        for (int i = 0; i < n2; ++i) {
            l += lArray[i];
        }
        sVibrationEndTime = System.nanoTime() + l * 1000000L;
        sVibrationMaybePlaying = true;
        GeckoAppShell.vibrator().vibrate(lArray, n);
    }

    @WrapElementForJNI
    public static void cancelVibrate() {
        sVibrationMaybePlaying = false;
        sVibrationEndTime = 0L;
        GeckoAppShell.vibrator().cancel();
    }

    @WrapElementForJNI
    public static void showInputMethodPicker() {
        InputMethodManager inputMethodManager = (InputMethodManager)GeckoAppShell.getContext().getSystemService("input_method");
        inputMethodManager.showInputMethodPicker();
    }

    @WrapElementForJNI
    public static void setKeepScreenOn(boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @WrapElementForJNI
    public static void notifyDefaultPrevented(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PanZoomController panZoomController;
                LayerView layerView = GeckoAppShell.getLayerView();
                PanZoomController panZoomController2 = panZoomController = layerView == null ? null : layerView.getPanZoomController();
                if (panZoomController != null) {
                    panZoomController.notifyDefaultActionPrevented(bl);
                }
            }
        });
    }

    @WrapElementForJNI
    public static boolean isNetworkLinkUp() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    @WrapElementForJNI
    public static boolean isNetworkLinkKnown() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getContext().getSystemService("connectivity");
        try {
            if (connectivityManager.getActiveNetworkInfo() == null) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    @WrapElementForJNI
    public static int networkLinkType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return 0;
        }
        switch (networkInfo.getType()) {
            case 9: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 0: {
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)"Ignoring the current network type.");
                return 0;
            }
        }
        TelephonyManager telephonyManager = (TelephonyManager)GeckoAppShell.getContext().getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return 0;
        }
        switch (telephonyManager.getNetworkType()) {
            case 1: 
            case 4: 
            case 11: {
                return 5;
            }
            case 2: 
            case 7: {
                return 5;
            }
            case 3: 
            case 5: {
                return 6;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return 6;
            }
            case 15: {
                return 6;
            }
            case 13: {
                return 7;
            }
        }
        Log.w((String)LOGTAG, (String)"Connected to an unknown mobile network!");
        return 0;
    }

    @WrapElementForJNI(stubName="GetSystemColoursWrapper")
    public static int[] getSystemColors() {
        int[] nArray = new int[]{16842904, 16842806, 16842809, 16842808, 16842810, 0x1010212, 16843283, 0x1010099, 0x1010030, 0x1010031, 0x1010060, 0x1010061};
        int[] nArray2 = new int[nArray.length];
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(GeckoAppShell.getContext(), 16973886);
        TypedArray typedArray = contextThemeWrapper.getTheme().obtainStyledAttributes(nArray);
        if (typedArray != null) {
            for (int i = 0; i < typedArray.getIndexCount(); ++i) {
                int n;
                int n2 = typedArray.getIndex(i);
                nArray2[n2] = n = typedArray.getColor(n2, 0);
            }
            typedArray.recycle();
        }
        return nArray2;
    }

    @WrapElementForJNI
    public static void killAnyZombies() {
        GeckoProcessesVisitor geckoProcessesVisitor = new GeckoProcessesVisitor(){

            @Override
            public boolean callback(int n) {
                if (n != Process.myPid()) {
                    Process.killProcess((int)n);
                }
                return true;
            }
        };
        GeckoAppShell.EnumerateGeckoProcesses(geckoProcessesVisitor);
    }

    public static boolean checkForGeckoProcs() {
        class GeckoPidCallback
        implements GeckoProcessesVisitor {
            public boolean otherPidExist;

            GeckoPidCallback() {
            }

            @Override
            public boolean callback(int n) {
                if (n != Process.myPid()) {
                    this.otherPidExist = true;
                    return false;
                }
                return true;
            }
        }
        GeckoPidCallback geckoPidCallback = new GeckoPidCallback();
        GeckoAppShell.EnumerateGeckoProcesses(geckoPidCallback);
        return geckoPidCallback.otherPidExist;
    }

    private static void EnumerateGeckoProcesses(GeckoProcessesVisitor geckoProcessesVisitor) {
        int n = -1;
        int n2 = -1;
        try {
            int n3;
            boolean bl;
            int n4;
            String[] stringArray;
            String string2;
            java.lang.Process process = Runtime.getRuntime().exec("ps");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 2048);
            String string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("PID")) {
                    n = n5;
                } else if (string2.equalsIgnoreCase("USER")) {
                    n2 = n5;
                }
                ++n5;
            }
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null && ((stringArray = string2.split("\\s+")).length <= n || stringArray.length <= n2 || (n4 = Process.getUidForName((String)stringArray[n2])) != Process.myUid() || stringArray[stringArray.length - 1].equalsIgnoreCase("ps") || (bl = geckoProcessesVisitor.callback(n3 = Integer.parseInt(stringArray[n]))))) {
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Failed to enumerate Gecko processes.", (Throwable)exception);
        }
    }

    public static void waitForAnotherGeckoProc() {
        int n = 40;
        while (!GeckoAppShell.checkForGeckoProcs() && --n > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppNameByPID(int n) {
        BufferedReader bufferedReader = null;
        String string2 = "/proc/" + n + "/cmdline";
        try {
            File file = new File(string2);
            if (!file.exists()) {
                String string3 = "";
                return string3;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = bufferedReader.readLine().trim();
            return string4;
        }
        catch (Exception exception) {
            String string5 = "";
            return string5;
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void listOfOpenFiles() {
        int n = -1;
        int n2 = -1;
        try {
            Object object;
            String string2 = GeckoProfile.get(GeckoAppShell.getContext()).getDir().toString();
            Log.d((String)LOGTAG, (String)("[OPENFILE] Filter: " + string2));
            java.lang.Process process = Runtime.getRuntime().exec("lsof");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 2048);
            String string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equalsIgnoreCase("PID")) {
                    n = n3;
                } else if (((String)object).equalsIgnoreCase("NAME")) {
                    n2 = n3;
                }
                ++n3;
            }
            object = new TreeMap();
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String[] stringArray = string4.split("\\s+");
                if (stringArray.length <= n || stringArray.length <= n2) continue;
                Integer n4 = new Integer(stringArray[n]);
                String string5 = (String)object.get(n4);
                if (string5 == null) {
                    string5 = GeckoAppShell.getAppNameByPID(n4);
                    object.put(n4, string5);
                }
                String string6 = stringArray[n2];
                if (TextUtils.isEmpty((CharSequence)string5) || TextUtils.isEmpty((CharSequence)string6) || !string6.startsWith(string2)) continue;
                Log.d((String)LOGTAG, (String)("[OPENFILE] " + string5 + "(" + stringArray[n] + ") : " + string6));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @WrapElementForJNI(stubName="GetIconForExtensionWrapper")
    public static byte[] getIconForExtension(String string2, int n) {
        try {
            Bitmap bitmap;
            PackageManager packageManager;
            Drawable drawable2;
            if (n <= 0) {
                n = 16;
            }
            if (string2 != null && string2.length() > 1 && string2.charAt(0) == '.') {
                string2 = string2.substring(1);
            }
            if ((drawable2 = GeckoAppShell.getDrawableForExtension(packageManager = GeckoAppShell.getContext().getPackageManager(), string2)) == null) {
                drawable2 = packageManager.getDefaultActivityIcon();
            }
            if ((bitmap = ((BitmapDrawable)drawable2).getBitmap()).getWidth() != n || bitmap.getHeight() != n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n, (boolean)true);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n * n * 4);
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            return byteBuffer.array();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"getIconForExtension failed.", (Throwable)exception);
            return null;
        }
    }

    public static String getMimeTypeFromExtension(String string2) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        return mimeTypeMap.getMimeTypeFromExtension(string2);
    }

    private static Drawable getDrawableForExtension(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        String string3 = GeckoAppShell.getMimeTypeFromExtension(string2);
        if (string3 == null || string3.length() <= 0) {
            return null;
        }
        intent.setType(string3);
        List list = packageManager.queryIntentActivities(intent, 0);
        if (list.size() == 0) {
            return null;
        }
        ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        return activityInfo.loadIcon(packageManager);
    }

    @WrapElementForJNI
    public static boolean getShowPasswordSetting() {
        try {
            int n = Settings.System.getInt((ContentResolver)GeckoAppShell.getContext().getContentResolver(), (String)"show_password", (int)1);
            return n > 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @WrapElementForJNI(stubName="AddPluginViewWrapper")
    public static void addPluginView(View view, float f, float f2, float f3, float f4, boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().addPluginView(view, new RectF(f, f2, f + f3, f2 + f4), bl);
        }
    }

    @WrapElementForJNI
    public static void removePluginView(View view, boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().removePluginView(view, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPluginDirectories() {
        Object object;
        Object object2;
        Serializable serializable;
        boolean bl;
        boolean bl2 = bl = new File("/system/lib/hw/gralloc.tegra.so").exists() || new File("/system/lib/hw/gralloc.tegra3.so").exists();
        if (bl) {
            serializable = new File("/proc/version");
            object2 = null;
            try {
                if (((File)serializable).canRead() && (((String)(object = new BufferedReader((Reader)(object2 = new FileReader((File)serializable))).readLine())).indexOf("CM9") != -1 || ((String)object).indexOf("cyanogen") != -1 || ((String)object).indexOf("Nova") != -1)) {
                    Log.w((String)LOGTAG, (String)"Blocking plugins because of Tegra 2 + unofficial ICS bug (bug 736421)");
                    String[] stringArray = null;
                    return stringArray;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (object2 != null) {
                        ((InputStreamReader)object2).close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (AppConstants.Versions.feature19Plus) {
                Log.w((String)LOGTAG, (String)"Blocking plugins because of Tegra (bug 957694)");
                return null;
            }
        }
        serializable = new ArrayList();
        object2 = GeckoAppShell.getContext().getPackageManager();
        object = object2.queryIntentServices(new Intent(PLUGIN_ACTION), 132);
        ArrayList<PackageInfo> arrayList = mPackageInfoCache;
        synchronized (arrayList) {
            mPackageInfoCache.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2;
                PackageInfo packageInfo;
                block38: {
                    String[] stringArray;
                    ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                    ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                    if (serviceInfo == null) {
                        Log.w((String)LOGTAG, (String)"Ignoring bad plugin.");
                        continue;
                    }
                    if (serviceInfo.packageName.equals("com.htc.flashliteplugin")) {
                        Log.w((String)LOGTAG, (String)"Skipping HTC's flash lite plugin");
                        continue;
                    }
                    try {
                        packageInfo = object2.getPackageInfo(serviceInfo.packageName, 4160);
                    }
                    catch (Exception exception) {
                        Log.w((String)LOGTAG, (String)("Can't find plugin: " + serviceInfo.packageName));
                        continue;
                    }
                    if (packageInfo == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Could not load package information."));
                        continue;
                    }
                    string2 = packageInfo.applicationInfo.dataDir + "/lib";
                    int n = packageInfo.applicationInfo.flags;
                    if ((n & 0x81) == 1) {
                        string2 = PLUGIN_SYSTEM_LIB + packageInfo.packageName;
                    }
                    if ((stringArray = packageInfo.requestedPermissions) == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Does not have required permission."));
                        continue;
                    }
                    boolean bl3 = false;
                    for (String string3 : stringArray) {
                        if (!PLUGIN_PERMISSION.equals(string3)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Does not have required permission (2)."));
                        continue;
                    }
                    String[] stringArray2 = packageInfo.signatures;
                    if (stringArray2 == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Not signed."));
                        continue;
                    }
                    if (serviceInfo.metaData == null) {
                        Log.e((String)LOGTAG, (String)("The plugin '" + serviceInfo.name + "' has no defined type."));
                        continue;
                    }
                    String string4 = serviceInfo.metaData.getString(PLUGIN_TYPE);
                    if (!TYPE_NATIVE.equals(string4)) {
                        Log.e((String)LOGTAG, (String)("Unrecognized plugin type: " + string4));
                        continue;
                    }
                    try {
                        Class<?> clazz = GeckoAppShell.getPluginClass(serviceInfo.packageName, serviceInfo.name);
                        boolean bl4 = true;
                        if (!bl4) {
                            Log.e((String)LOGTAG, (String)("The plugin's class' " + serviceInfo.name + "' does not extend the appropriate class."));
                        }
                        break block38;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)LOGTAG, (String)("Can't find plugin: " + serviceInfo.packageName));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Log.e((String)LOGTAG, (String)("Can't find plugin's class: " + serviceInfo.name));
                    }
                    continue;
                }
                mPackageInfoCache.add(packageInfo);
                ((ArrayList)serializable).add(string2);
            }
        }
        return ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPluginPackage(String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        ArrayList<PackageInfo> arrayList = mPackageInfoCache;
        synchronized (arrayList) {
            for (PackageInfo packageInfo : mPackageInfoCache) {
                if (!string2.contains(packageInfo.packageName)) continue;
                return packageInfo.packageName;
            }
        }
        return null;
    }

    static Class<?> getPluginClass(String string2, String string3) throws PackageManager.NameNotFoundException, ClassNotFoundException {
        Context context = GeckoAppShell.getContext().createPackageContext(string2, 3);
        ClassLoader classLoader = context.getClassLoader();
        return classLoader.loadClass(string3);
    }

    @WrapElementForJNI(allowMultithread=true)
    public static Class<?> loadPluginClass(String string2, String string3) {
        if (GeckoAppShell.getGeckoInterface() == null) {
            return null;
        }
        try {
            String string4 = GeckoAppShell.getPluginPackage(string3);
            Context context = GeckoAppShell.getContext().createPackageContext(string4, 3);
            return context.getClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)LOGTAG, (String)("Couldn't find plugin class " + string2), (Throwable)classNotFoundException);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)LOGTAG, (String)"Couldn't find package.", (Throwable)nameNotFoundException);
            return null;
        }
    }

    @WrapElementForJNI(allowMultithread=true)
    public static Context getContext() {
        return sContextGetter.getContext();
    }

    public static void setContextGetter(ContextGetter contextGetter) {
        sContextGetter = contextGetter;
    }

    public static SharedPreferences getSharedPreferences() {
        if (sContextGetter == null) {
            throw new IllegalStateException("No ContextGetter; cannot fetch prefs.");
        }
        return sContextGetter.getSharedPreferences();
    }

    public static GeckoInterface getGeckoInterface() {
        return sGeckoInterface;
    }

    public static void setGeckoInterface(GeckoInterface geckoInterface) {
        sGeckoInterface = geckoInterface;
    }

    static native void cameraCallbackBridge(byte[] var0);

    @WrapElementForJNI(stubName="InitCameraWrapper")
    static int[] initCamera(String string2, int n, int n2, int n3) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (GeckoAppShell.getGeckoInterface() != null) {
                        GeckoAppShell.getGeckoInterface().enableCameraView();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        int[] nArray = new int[4];
        nArray[0] = 0;
        if (Camera.getNumberOfCameras() == 0) {
            return nArray;
        }
        try {
            Camera.Size size;
            int n4;
            Iterator iterator;
            sCamera = Camera.open((int)n);
            Camera.Parameters parameters = sCamera.getParameters();
            parameters.setPreviewFormat(17);
            int n5 = 1000;
            try {
                iterator = parameters.getSupportedPreviewFrameRates().iterator();
                while (iterator.hasNext()) {
                    n4 = (Integer)iterator.next();
                    if (Math.abs(n4 - kPreferedFps) >= n5) continue;
                    n5 = Math.abs(n4 - kPreferedFps);
                    parameters.setPreviewFrameRate(n4);
                }
            }
            catch (Exception exception) {
                parameters.setPreviewFrameRate(kPreferedFps);
            }
            iterator = parameters.getSupportedPreviewSizes().iterator();
            n4 = 10000000;
            int n6 = 0;
            while (iterator.hasNext()) {
                size = (Camera.Size)iterator.next();
                if (Math.abs(size.width * size.height - n2 * n3) >= n4) continue;
                n4 = Math.abs(size.width * size.height - n2 * n3);
                parameters.setPreviewSize(size.width, size.height);
                n6 = size.width * size.height;
            }
            try {
                if (GeckoAppShell.getGeckoInterface() != null) {
                    size = GeckoAppShell.getGeckoInterface().getCameraView();
                    if (size instanceof SurfaceView) {
                        sCamera.setPreviewDisplay(((SurfaceView)size).getHolder());
                    } else if (size instanceof TextureView) {
                        sCamera.setPreviewTexture(((TextureView)size).getSurfaceTexture());
                    }
                }
            }
            catch (IOException iOException) {
                Log.w((String)LOGTAG, (String)"Error setPreviewXXX:", (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)LOGTAG, (String)"Error setPreviewXXX:", (Throwable)runtimeException);
            }
            sCamera.setParameters(parameters);
            sCameraBuffer = new byte[n6 * 12 / 8];
            sCamera.addCallbackBuffer(sCameraBuffer);
            sCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                public void onPreviewFrame(byte[] byArray, Camera camera) {
                    GeckoAppShell.cameraCallbackBridge(byArray);
                    if (sCamera != null) {
                        sCamera.addCallbackBuffer(sCameraBuffer);
                    }
                }
            });
            sCamera.startPreview();
            parameters = sCamera.getParameters();
            nArray[0] = 1;
            nArray[1] = parameters.getPreviewSize().width;
            nArray[2] = parameters.getPreviewSize().height;
            nArray[3] = parameters.getPreviewFrameRate();
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOGTAG, (String)"initCamera RuntimeException.", (Throwable)runtimeException);
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
        }
        return nArray;
    }

    @WrapElementForJNI
    static synchronized void closeCamera() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (GeckoAppShell.getGeckoInterface() != null) {
                        GeckoAppShell.getGeckoInterface().disableCameraView();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (sCamera != null) {
            sCamera.stopPreview();
            sCamera.release();
            sCamera = null;
            sCameraBuffer = null;
        }
    }

    @WrapElementForJNI
    public static void enableBatteryNotifications() {
        GeckoBatteryManager.enableNotifications();
    }

    @WrapElementForJNI(stubName="HandleGeckoMessageWrapper")
    public static void handleGeckoMessage(NativeJSContainer nativeJSContainer) {
        EventDispatcher.getInstance().dispatchEvent(nativeJSContainer);
        nativeJSContainer.dispose();
    }

    @WrapElementForJNI
    public static void disableBatteryNotifications() {
        GeckoBatteryManager.disableNotifications();
    }

    @WrapElementForJNI(stubName="GetCurrentBatteryInformationWrapper")
    public static double[] getCurrentBatteryInformation() {
        return GeckoBatteryManager.getCurrentInformation();
    }

    @WrapElementForJNI(stubName="CheckURIVisited")
    static void checkUriVisited(String string2) {
        GlobalHistory.getInstance().checkUriVisited(string2);
    }

    @WrapElementForJNI(stubName="MarkURIVisited")
    static void markUriVisited(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GlobalHistory.getInstance().add(string2);
            }
        });
    }

    @WrapElementForJNI(stubName="SetURITitle")
    static void setUriTitle(final String string2, final String string3) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GlobalHistory.getInstance().update(string2, string3);
            }
        });
    }

    @WrapElementForJNI
    static void hideProgressDialog() {
    }

    @WrapElementForJNI(stubName="SendMessageWrapper")
    public static void sendMessage(String string2, String string3, int n) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().send(string2, string3, n);
    }

    @WrapElementForJNI(stubName="GetMessageWrapper")
    public static void getMessage(int n, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().getMessage(n, n2);
    }

    @WrapElementForJNI(stubName="DeleteMessageWrapper")
    public static void deleteMessage(int n, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().deleteMessage(n, n2);
    }

    @WrapElementForJNI(stubName="CreateMessageListWrapper")
    public static void createMessageList(long l, long l2, String[] stringArray, int n, String string2, boolean bl, boolean bl2, long l3, boolean bl3, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().createMessageList(l, l2, stringArray, n, string2, bl, bl2, l3, bl3, n2);
    }

    @WrapElementForJNI(stubName="GetNextMessageInListWrapper")
    public static void getNextMessageInList(int n, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().getNextMessageInList(n, n2);
    }

    @WrapElementForJNI
    public static void clearMessageList(int n) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().clearMessageList(n);
    }

    @WrapElementForJNI
    @RobocopTarget
    public static boolean isTablet() {
        return HardwareUtils.isTablet();
    }

    public static void viewSizeChanged() {
        LayerView layerView = GeckoAppShell.getLayerView();
        if (layerView != null && layerView.isIMEEnabled()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("ScrollTo:FocusedInput", ""));
        }
    }

    @WrapElementForJNI(stubName="GetCurrentNetworkInformationWrapper")
    public static double[] getCurrentNetworkInformation() {
        return GeckoNetworkManager.getInstance().getCurrentInformation();
    }

    @WrapElementForJNI
    public static void enableNetworkNotifications() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoNetworkManager.getInstance().enableNotifications();
            }
        });
    }

    @WrapElementForJNI
    public static void disableNetworkNotifications() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoNetworkManager.getInstance().disableNotifications();
            }
        });
    }

    public static byte[] decodeBase64(String string2, int n) {
        return Base64.decode((byte[])string2.getBytes(), (int)n);
    }

    @WrapElementForJNI(stubName="GetScreenOrientationWrapper")
    public static short getScreenOrientation() {
        return GeckoScreenOrientation.getInstance().getScreenOrientation().value;
    }

    @WrapElementForJNI
    public static void enableScreenOrientationNotifications() {
        GeckoScreenOrientation.getInstance().enableNotifications();
    }

    @WrapElementForJNI
    public static void disableScreenOrientationNotifications() {
        GeckoScreenOrientation.getInstance().disableNotifications();
    }

    @WrapElementForJNI
    public static void lockScreenOrientation(int n) {
        GeckoScreenOrientation.getInstance().lock(n);
    }

    @WrapElementForJNI
    public static void unlockScreenOrientation() {
        GeckoScreenOrientation.getInstance().unlock();
    }

    @WrapElementForJNI
    public static boolean pumpMessageLoop() {
        Handler handler = ThreadUtils.sGeckoHandler;
        Message message = GeckoAppShell.getNextMessageFromQueue(ThreadUtils.sGeckoQueue);
        if (message == null) {
            return false;
        }
        if (message.obj == handler && message.getTarget() == handler) {
            message.recycle();
            return false;
        }
        if (message.getTarget() == null) {
            Looper.myLooper().quit();
        } else {
            message.getTarget().dispatchMessage(message);
        }
        try {
            message.recycle();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return true;
    }

    @WrapElementForJNI
    public static void notifyWakeLockChanged(String string2, String string3) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().notifyWakeLockChanged(string2, string3);
        }
    }

    @WrapElementForJNI(allowMultithread=true)
    public static void registerSurfaceTextureFrameListener(Object object, final int n) {
        ((SurfaceTexture)object).setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                GeckoAppShell.onSurfaceTextureFrameAvailable(surfaceTexture, n);
            }
        });
    }

    @WrapElementForJNI(allowMultithread=true)
    public static void unregisterSurfaceTextureFrameListener(Object object) {
        ((SurfaceTexture)object).setOnFrameAvailableListener(null);
    }

    @WrapElementForJNI
    public static boolean unlockProfile() {
        GeckoAppShell.killAnyZombies();
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoProfile geckoProfile = GeckoAppShell.getGeckoInterface().getProfile();
            File file = geckoProfile.getFile(".parentlock");
            return file.exists() && file.delete();
        }
        return false;
    }

    @WrapElementForJNI(stubName="GetProxyForURIWrapper")
    public static String getProxyForURI(String string2, String string3, String string4, int n) {
        ProxySelector proxySelector = new ProxySelector();
        Proxy proxy = proxySelector.select(string3, string4);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return "DIRECT";
        }
        switch (proxy.type()) {
            case HTTP: {
                return "PROXY " + proxy.address().toString();
            }
            case SOCKS: {
                return "SOCKS " + proxy.address().toString();
            }
        }
        return "DIRECT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void downloadImageForIntent(Intent intent) {
        FileOutputStream fileOutputStream;
        block12: {
            String string2 = ContextUtils.getStringExtra((Intent)intent, (String)"android.intent.extra.TEXT");
            if (string2 == null) {
                GeckoAppShell.showImageShareFailureToast();
                return;
            }
            File file = GeckoApp.getTempDirectory();
            if (file == null) {
                GeckoAppShell.showImageShareFailureToast();
                return;
            }
            GeckoApp.deleteTempFiles();
            String string3 = intent.getType();
            fileOutputStream = null;
            try {
                InputStream inputStream;
                if (string2.startsWith("data:")) {
                    int n = string2.indexOf(",");
                    String string4 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string3);
                    if (TextUtils.isEmpty((CharSequence)string4) && n > 5) {
                        string3 = string2.substring(5, n).replace(";base64", "");
                        string4 = MimeTypeMap.getSingleton().getExtensionFromMimeType(string3);
                    }
                    File file2 = File.createTempFile("image", "." + string4, file);
                    fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = Base64.decode((String)string2.substring(n + 1), (int)0);
                    ((OutputStream)fileOutputStream).write(byArray);
                    intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)file2));
                } else {
                    int n;
                    inputStream = null;
                    byte[] byArray = new byte[2048];
                    URL uRL = new URL(string2);
                    String string5 = URLUtil.guessFileName((String)string2, null, (String)string3);
                    inputStream = uRL.openStream();
                    File file3 = new File(file, string5);
                    fileOutputStream = new FileOutputStream(file3);
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)file3));
                    GeckoAppShell.safeStreamClose(inputStream);
                }
                break block12;
                catch (Throwable throwable) {
                    GeckoAppShell.safeStreamClose(inputStream);
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                GeckoAppShell.safeStreamClose(fileOutputStream);
                catch (Throwable throwable) {
                    GeckoAppShell.safeStreamClose(fileOutputStream);
                    throw throwable;
                }
            }
        }
        GeckoAppShell.safeStreamClose(fileOutputStream);
    }

    private static final void showImageShareFailureToast() {
        Toast toast = Toast.makeText((Context)GeckoAppShell.getContext(), (CharSequence)GeckoAppShell.getContext().getResources().getString(R.string.share_image_failed), (int)0);
        toast.show();
    }

    @WrapElementForJNI(allowMultithread=true)
    static InputStream createInputStream(URLConnection uRLConnection) throws IOException {
        return uRLConnection.getInputStream();
    }

    @WrapElementForJNI(allowMultithread=true, narrowChars=true)
    static URLConnection getConnection(String string2) {
        try {
            String string3 = string2.startsWith("android://") ? string2.substring(10) : string2.substring(8);
            int n = string3.indexOf(58);
            if (n == -1 || n > string3.indexOf(47)) {
                string3 = string3.replaceFirst("/", ":/");
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    @WrapElementForJNI(allowMultithread=true, narrowChars=true)
    static String connectionGetMimeType(URLConnection uRLConnection) {
        return uRLConnection.getContentType();
    }

    @WrapElementForJNI
    static String getExternalPublicDirectory(String string2) {
        String string3;
        String string4 = Environment.getExternalStorageState();
        if (!"mounted".equals(string4) && !"mounted_ro".equals(string4)) {
            return null;
        }
        if ("sdcard".equals(string2)) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        if ("downloads".equals(string2)) {
            string3 = Environment.DIRECTORY_DOWNLOADS;
        } else if ("pictures".equals(string2)) {
            string3 = Environment.DIRECTORY_PICTURES;
        } else if ("videos".equals(string2)) {
            string3 = Environment.DIRECTORY_MOVIES;
        } else if ("music".equals(string2)) {
            string3 = Environment.DIRECTORY_MUSIC;
        } else {
            return null;
        }
        return Environment.getExternalStoragePublicDirectory((String)string3).getAbsolutePath();
    }

    static {
        CRASH_HANDLER = new CrashHandler(){

            @Override
            protected String getAppPackageName() {
                return "org.mozilla.fennec";
            }

            @Override
            protected Context getAppContext() {
                return sContextGetter != null ? GeckoAppShell.getContext() : null;
            }

            @Override
            protected Bundle getCrashExtras(Thread thread, Throwable throwable) {
                Bundle bundle = super.getCrashExtras(thread, throwable);
                bundle.putString("ProductName", "Fennec");
                bundle.putString("ProductID", "{aa3c5121-dab2-40e2-81ca-7ea25febc110}");
                bundle.putString("Version", "36.0a1");
                bundle.putString("BuildID", "20141102040206");
                bundle.putString("Vendor", "Mozilla");
                bundle.putString("ReleaseChannel", "default");
                return bundle;
            }

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoExited)) {
                    return;
                }
                super.uncaughtException(thread, throwable);
            }

            @Override
            public boolean reportException(Thread thread, Throwable throwable) {
                try {
                    if (throwable instanceof OutOfMemoryError) {
                        SharedPreferences sharedPreferences = GeckoAppShell.getSharedPreferences();
                        SharedPreferences.Editor editor = sharedPreferences.edit();
                        editor.putBoolean("OOMException", true);
                        editor.commit();
                    }
                    GeckoAppShell.reportJavaCrash(1.getExceptionStackTrace(throwable));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return super.reportException(thread, throwable);
            }
        };
        PENDING_EVENTS = new ConcurrentLinkedQueue<GeckoEvent>();
        ALERT_COOKIES = new ConcurrentHashMap<String, String>();
        DEFAULT_LAUNCHER_ICON_HSV = new float[]{32.0f, 1.0f, 1.0f};
        sEventAckLock = new Object();
        sCallbackRunnable = new Runnable(){

            @Override
            public void run() {
                ThreadUtils.assertOnUiThread();
                long l = GeckoAppShell.runUiThreadCallback();
                if (l >= 0L) {
                    ThreadUtils.getUiHandler().postDelayed((Runnable)this, l);
                }
            }
        };
        mPackageInfoCache = new ArrayList();
        kPreferedFps = 25;
    }

    public static interface GeckoInterface {
        public GeckoProfile getProfile();

        public PromptService getPromptService();

        public Activity getActivity();

        public String getDefaultUAString();

        public LocationListener getLocationListener();

        public SensorEventListener getSensorEventListener();

        public void doRestart();

        public void setFullScreen(boolean var1);

        public void addPluginView(View var1, RectF var2, boolean var3);

        public void removePluginView(View var1, boolean var2);

        public void enableCameraView();

        public void disableCameraView();

        public void addAppStateListener(AppStateListener var1);

        public void removeAppStateListener(AppStateListener var1);

        public View getCameraView();

        public void notifyWakeLockChanged(String var1, String var2);

        public FormAssistPopup getFormAssistPopup();

        public boolean areTabsShown();

        public AbsoluteLayout getPluginContainer();

        public void notifyCheckUpdateResult(String var1);

        public boolean hasTabsSideBar();

        public void invalidateOptionsMenu();
    }

    public static interface AppStateListener {
        public void onPause();

        public void onResume();

        public void onOrientationChanged();
    }

    static interface GeckoProcessesVisitor {
        public boolean callback(int var1);
    }

    public static class CreateShortcutFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final String title;
        private final String url;

        public CreateShortcutFaviconLoadedListener(String string2, String string3) {
            this.url = string2;
            this.title = string3;
        }

        @Override
        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            GeckoAppShell.createShortcut(this.title, this.url, bitmap);
        }
    }
}

