/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrivateTab;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.ThumbnailHelper;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.mozglue.JNITarget;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class Tabs
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoTabs";
    private final CopyOnWriteArrayList<Tab> mOrder = new CopyOnWriteArrayList();
    private volatile Tab mSelectedTab;
    private final HashMap<Integer, Tab> mTabs = new HashMap();
    private AccountManager mAccountManager;
    private OnAccountsUpdateListener mAccountListener;
    public static final int LOADURL_NONE = 0;
    public static final int LOADURL_NEW_TAB = 1;
    public static final int LOADURL_USER_ENTERED = 2;
    public static final int LOADURL_PRIVATE = 4;
    public static final int LOADURL_PINNED = 8;
    public static final int LOADURL_DELAY_LOAD = 16;
    public static final int LOADURL_DESKTOP = 32;
    public static final int LOADURL_BACKGROUND = 64;
    public static final int LOADURL_EXTERNAL = 128;
    private static final long PERSIST_TABS_AFTER_MILLISECONDS = 5000L;
    public static final int INVALID_TAB_ID = -1;
    private static final AtomicInteger sTabId = new AtomicInteger(0);
    private volatile boolean mInitialTabsAdded;
    private Context mAppContext;
    private ContentObserver mContentObserver;
    private final Runnable mPersistTabsRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                boolean bl;
                Context context = Tabs.this.getAppContext();
                boolean bl2 = bl = SyncAccounts.syncAccountsExist(context) || FirefoxAccounts.firefoxAccountsExist(context);
                if (bl) {
                    TabsAccessor.persistLocalTabs(Tabs.this.getContentResolver(), Tabs.this.getTabsInOrder());
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    };
    private static final List<OnTabsChangedListener> TABS_CHANGED_LISTENERS = new CopyOnWriteArrayList<OnTabsChangedListener>();

    private Tabs() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Session:RestoreEnd", "SessionHistory:New", "SessionHistory:Back", "SessionHistory:Forward", "SessionHistory:Goto", "SessionHistory:Purge", "Tab:Added", "Tab:Close", "Tab:Select", "Content:LocationChange", "Content:SecurityChange", "Content:ReaderEnabled", "Content:StateChange", "Content:LoadError", "Content:PageShow", "DOMContentLoaded", "DOMTitleChanged", "Link:Favicon", "Link:Feed", "Link:OpenSearch", "DesktopMode:Changed", "Tab:ViewportMetadata", "Tab:StreamStart", "Tab:StreamStop", "Reader:Toggle");
    }

    public synchronized void attachToContext(Context context) {
        Context context2 = context.getApplicationContext();
        if (this.mAppContext == context2) {
            return;
        }
        if (this.mAppContext != null) {
            Log.w((String)LOGTAG, (String)"The application context has changed!");
        }
        this.mAppContext = context2;
        this.mAccountManager = AccountManager.get((Context)context2);
        this.mAccountListener = new OnAccountsUpdateListener(){

            public void onAccountsUpdated(Account[] accountArray) {
                Tabs.this.persistAllTabs();
            }
        };
        this.mAccountManager.addOnAccountsUpdatedListener(this.mAccountListener, ThreadUtils.getBackgroundHandler(), false);
        if (this.mContentObserver != null) {
            BrowserDB.registerBookmarkObserver(this.getContentResolver(), this.mContentObserver);
        }
    }

    public synchronized int getDisplayCount() {
        boolean bl = this.mSelectedTab != null && this.mSelectedTab.isPrivate();
        int n = 0;
        for (Tab tab : this.mOrder) {
            if (tab.isPrivate() != bl) continue;
            ++n;
        }
        return n;
    }

    public int isOpen(String string2) {
        for (Tab tab : this.mOrder) {
            if (!tab.getURL().equals(string2)) continue;
            return tab.getId();
        }
        return -1;
    }

    private void lazyRegisterBookmarkObserver() {
        if (this.mContentObserver == null) {
            this.mContentObserver = new ContentObserver(null){

                public void onChange(boolean bl) {
                    for (Tab tab : Tabs.this.mOrder) {
                        tab.updateBookmark();
                    }
                }
            };
            BrowserDB.registerBookmarkObserver(this.getContentResolver(), this.mContentObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tab addTab(int n, String string2, boolean bl, int n2, String string3, boolean bl2, int n3) {
        Tab tab = bl2 ? new PrivateTab(this.mAppContext, n, string2, bl, n2, string3) : new Tab(this.mAppContext, n, string2, bl, n2, string3);
        Tabs tabs = this;
        synchronized (tabs) {
            this.lazyRegisterBookmarkObserver();
            this.mTabs.put(n, tab);
            if (n3 > -1) {
                this.mOrder.add(n3, tab);
            } else {
                this.mOrder.add(tab);
            }
        }
        if (this.mInitialTabsAdded) {
            this.notifyListeners(tab, TabEvents.ADDED);
        }
        return tab;
    }

    public synchronized void removeTab(int n) {
        if (this.mTabs.containsKey(n)) {
            Tab tab = this.getTab(n);
            this.mOrder.remove(tab);
            this.mTabs.remove(n);
        }
    }

    public synchronized Tab selectTab(int n) {
        if (!this.mTabs.containsKey(n)) {
            return null;
        }
        Tab tab = this.getSelectedTab();
        Tab tab2 = this.mTabs.get(n);
        if (tab2 == null || tab == tab2) {
            return null;
        }
        this.mSelectedTab = tab2;
        this.notifyListeners(tab2, TabEvents.SELECTED);
        if (tab != null) {
            this.notifyListeners(tab, TabEvents.UNSELECTED);
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Selected", String.valueOf(tab2.getId())));
        return tab2;
    }

    private int getIndexOf(Tab tab) {
        return this.mOrder.lastIndexOf(tab);
    }

    private Tab getNextTabFrom(Tab tab, boolean bl) {
        int n = this.mOrder.size();
        int n2 = this.getIndexOf(tab);
        for (int i = n2 + 1; i < n; ++i) {
            Tab tab2 = this.mOrder.get(i);
            if (tab2.isPrivate() != bl) continue;
            return tab2;
        }
        return null;
    }

    private Tab getPreviousTabFrom(Tab tab, boolean bl) {
        int n = this.getIndexOf(tab);
        for (int i = n - 1; i >= 0; --i) {
            Tab tab2 = this.mOrder.get(i);
            if (tab2.isPrivate() != bl) continue;
            return tab2;
        }
        return null;
    }

    public Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    public boolean isSelectedTab(Tab tab) {
        return tab != null && tab == this.mSelectedTab;
    }

    public boolean isSelectedTabId(int n) {
        Tab tab = this.mSelectedTab;
        return tab != null && tab.getId() == n;
    }

    @RobocopTarget
    public synchronized Tab getTab(int n) {
        if (n == -1) {
            return null;
        }
        if (this.mTabs.size() == 0) {
            return null;
        }
        if (!this.mTabs.containsKey(n)) {
            return null;
        }
        return this.mTabs.get(n);
    }

    @RobocopTarget
    public synchronized void closeTab(Tab tab) {
        this.closeTab(tab, this.getNextTab(tab));
    }

    public synchronized void closeTab(Tab tab, Tab tab2) {
        this.closeTab(tab, tab2, false);
    }

    public synchronized void closeTab(Tab tab, boolean bl) {
        this.closeTab(tab, this.getNextTab(tab), bl);
    }

    public synchronized void closeTab(Tab tab, Tab tab2, boolean bl) {
        if (tab == null) {
            return;
        }
        int n = tab.getId();
        this.removeTab(n);
        if (tab2 == null) {
            tab2 = this.loadUrl("about:home", 1);
        }
        this.selectTab(tab2.getId());
        tab.onDestroy();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("tabId", (Object)String.valueOf(n));
            jSONObject.put("showUndoToast", bl);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Error building Tab:Closed arguments: " + (Object)((Object)jSONException)));
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Closed", jSONObject.toString()));
    }

    public Tab getNextTab(Tab tab) {
        Tab tab2;
        Tab tab3 = this.getSelectedTab();
        if (tab3 != tab) {
            return tab3;
        }
        boolean bl = tab.isPrivate();
        Tab tab4 = this.getNextTabFrom(tab, bl);
        if (tab4 == null) {
            tab4 = this.getPreviousTabFrom(tab, bl);
        }
        if (tab4 == null && bl) {
            tab2 = this.mOrder.get(this.mOrder.size() - 1);
            tab4 = !tab2.isPrivate() ? tab2 : this.getPreviousTabFrom(tab2, false);
        }
        if ((tab2 = this.getTab(tab.getParentId())) != null) {
            if (tab4 != null && tab4.getParentId() == tab.getParentId()) {
                return tab4;
            }
            return tab2;
        }
        return tab4;
    }

    public Iterable<Tab> getTabsInOrder() {
        return this.mOrder;
    }

    private synchronized Context getAppContext() {
        if (this.mAppContext == null) {
            throw new IllegalStateException("Tabs not initialized with a GeckoApp instance.");
        }
        return this.mAppContext;
    }

    public ContentResolver getContentResolver() {
        return this.getAppContext().getContentResolver();
    }

    @RobocopTarget
    public static Tabs getInstance() {
        return TabsInstanceHolder.INSTANCE;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Log.d((String)LOGTAG, (String)("handleMessage: " + string2));
        try {
            if (string2.equals("Session:RestoreEnd")) {
                this.notifyListeners(null, TabEvents.RESTORED);
                return;
            }
            int n = jSONObject.getInt("tabID");
            Tab tab = this.getTab(n);
            if (string2.equals("Tab:Added")) {
                String string3;
                String string4 = string3 = jSONObject.isNull("uri") ? null : jSONObject.getString("uri");
                if (jSONObject.getBoolean("stub")) {
                    if (tab == null) {
                        return;
                    }
                } else {
                    tab = this.addTab(n, string3, jSONObject.getBoolean("external"), jSONObject.getInt("parentId"), jSONObject.getString("title"), jSONObject.getBoolean("isPrivate"), jSONObject.getInt("tabIndex"));
                    if (jSONObject.getBoolean("selected")) {
                        this.selectTab(n);
                    }
                }
                if (jSONObject.getBoolean("delayLoad")) {
                    tab.setState(0);
                }
                if (jSONObject.getBoolean("desktopMode")) {
                    tab.setDesktopMode(true);
                }
                return;
            }
            if (tab == null) {
                return;
            }
            if (string2.startsWith("SessionHistory:")) {
                string2 = string2.substring("SessionHistory:".length());
                tab.handleSessionHistoryMessage(string2, jSONObject);
            } else if (string2.equals("Tab:Close")) {
                this.closeTab(tab);
            } else if (string2.equals("Tab:Select")) {
                this.selectTab(tab.getId());
            } else if (string2.equals("Content:LocationChange")) {
                tab.handleLocationChange(jSONObject);
            } else if (string2.equals("Content:SecurityChange")) {
                tab.updateIdentityData(jSONObject.getJSONObject("identity"));
                this.notifyListeners(tab, TabEvents.SECURITY_CHANGE);
            } else if (string2.equals("Content:ReaderEnabled")) {
                tab.setReaderEnabled(true);
                this.notifyListeners(tab, TabEvents.READER_ENABLED);
            } else if (string2.equals("Content:StateChange")) {
                int n2 = jSONObject.getInt("state");
                if ((n2 & 0x40000) != 0) {
                    if ((n2 & 1) != 0) {
                        boolean bl = jSONObject.getBoolean("restoring");
                        tab.handleDocumentStart(bl, jSONObject.getString("uri"));
                        this.notifyListeners(tab, TabEvents.START);
                    } else if ((n2 & 0x10) != 0) {
                        tab.handleDocumentStop(jSONObject.getBoolean("success"));
                        this.notifyListeners(tab, TabEvents.STOP);
                    }
                }
            } else if (string2.equals("Content:LoadError")) {
                tab.handleContentLoaded();
                this.notifyListeners(tab, TabEvents.LOAD_ERROR);
            } else if (string2.equals("Content:PageShow")) {
                this.notifyListeners(tab, TabEvents.PAGE_SHOW);
                tab.updateUserRequested(jSONObject.getString("userRequested"));
            } else if (string2.equals("DOMContentLoaded")) {
                tab.handleContentLoaded();
                String string5 = jSONObject.getString("bgColor");
                if (string5 != null) {
                    tab.setBackgroundColor(string5);
                } else {
                    tab.setBackgroundColor(-1);
                }
                tab.setErrorType(jSONObject.optString("errorType"));
                tab.setMetadata(jSONObject.optJSONObject("metadata"));
                this.notifyListeners(tab, TabEvents.LOADED);
            } else if (string2.equals("DOMTitleChanged")) {
                tab.updateTitle(jSONObject.getString("title"));
            } else if (string2.equals("Link:Favicon")) {
                tab.updateFaviconURL(jSONObject.getString("href"), jSONObject.getInt("size"));
                this.notifyListeners(tab, TabEvents.LINK_FAVICON);
            } else if (string2.equals("Link:Feed")) {
                tab.setHasFeeds(true);
                this.notifyListeners(tab, TabEvents.LINK_FEED);
            } else if (string2.equals("Link:OpenSearch")) {
                boolean bl = jSONObject.getBoolean("visible");
                tab.setHasOpenSearch(bl);
            } else if (string2.equals("DesktopMode:Changed")) {
                tab.setDesktopMode(jSONObject.getBoolean("desktopMode"));
                this.notifyListeners(tab, TabEvents.DESKTOP_MODE_CHANGE);
            } else if (string2.equals("Tab:ViewportMetadata")) {
                tab.setZoomConstraints(new ZoomConstraints(jSONObject));
                tab.setIsRTL(jSONObject.getBoolean("isRTL"));
                this.notifyListeners(tab, TabEvents.VIEWPORT_CHANGE);
            } else if (string2.equals("Tab:StreamStart")) {
                tab.setRecording(true);
                this.notifyListeners(tab, TabEvents.RECORDING_CHANGE);
            } else if (string2.equals("Tab:StreamStop")) {
                tab.setRecording(false);
                this.notifyListeners(tab, TabEvents.RECORDING_CHANGE);
            } else if (string2.equals("Reader:Toggle")) {
                tab.toggleReaderMode();
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)("handleMessage threw for " + string2), (Throwable)exception);
        }
    }

    public void updateFaviconForURL(String string2, Bitmap bitmap) {
        for (Tab tab : this.mOrder) {
            String string3 = tab.getURL();
            if (!string2.equals(string3)) continue;
            tab.setFaviconLoadId(0);
            if (!tab.updateFavicon(bitmap)) continue;
            this.notifyListeners(tab, TabEvents.FAVICON);
        }
    }

    public void refreshThumbnails() {
        final ThumbnailHelper thumbnailHelper = ThumbnailHelper.getInstance();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Tab tab : Tabs.this.mOrder) {
                    thumbnailHelper.getAndProcessThumbnailFor(tab);
                }
            }
        });
    }

    public static void registerOnTabsChangedListener(OnTabsChangedListener onTabsChangedListener) {
        TABS_CHANGED_LISTENERS.add(onTabsChangedListener);
    }

    public static void unregisterOnTabsChangedListener(OnTabsChangedListener onTabsChangedListener) {
        TABS_CHANGED_LISTENERS.remove(onTabsChangedListener);
    }

    public void notifyListeners(Tab tab, TabEvents tabEvents) {
        this.notifyListeners(tab, tabEvents, "");
    }

    public void notifyListeners(final Tab tab, final TabEvents tabEvents, final Object object) {
        if (tab == null && tabEvents != TabEvents.RESTORED) {
            throw new IllegalArgumentException("onTabChanged:" + (Object)((Object)tabEvents) + " must specify a tab.");
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs.this.onTabChanged(tab, tabEvents, object);
                if (TABS_CHANGED_LISTENERS.isEmpty()) {
                    return;
                }
                Iterator iterator = TABS_CHANGED_LISTENERS.iterator();
                while (iterator.hasNext()) {
                    ((OnTabsChangedListener)iterator.next()).onTabChanged(tab, tabEvents, object);
                }
            }
        });
    }

    private void onTabChanged(Tab tab, TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case LOCATION_CHANGE: {
                this.queuePersistAllTabs();
                break;
            }
            case RESTORED: {
                this.mInitialTabsAdded = true;
                break;
            }
            case SELECTED: {
                this.queuePersistAllTabs();
            }
            case UNSELECTED: {
                tab.onChange();
                break;
            }
        }
    }

    public void persistAllTabs() {
        ThreadUtils.postToBackgroundThread((Runnable)this.mPersistTabsRunnable);
    }

    private void queuePersistAllTabs() {
        Handler handler = ThreadUtils.getBackgroundHandler();
        handler.removeCallbacks(this.mPersistTabsRunnable);
        handler.postDelayed(this.mPersistTabsRunnable, 5000L);
    }

    public Tab getFirstTabForUrl(String string2) {
        return this.getFirstTabForUrlHelper(string2, null);
    }

    public Tab getFirstTabForUrl(String string2, boolean bl) {
        return this.getFirstTabForUrlHelper(string2, bl);
    }

    private Tab getFirstTabForUrlHelper(String string2, Boolean bl) {
        if (string2 == null) {
            return null;
        }
        for (Tab tab : this.mOrder) {
            if (bl != null && bl.booleanValue() != tab.isPrivate() || !string2.equals(tab.getURL())) continue;
            return tab;
        }
        return null;
    }

    public Tab getFirstReaderTabForUrl(String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        if (AboutPages.isAboutReader(string2)) {
            string2 = ReaderModeUtils.getUrlFromAboutReader(string2);
        }
        for (Tab tab : this.mOrder) {
            String string3;
            if (bl != tab.isPrivate() || !AboutPages.isAboutReader(string3 = tab.getURL()) || !string2.equals(string3 = ReaderModeUtils.getUrlFromAboutReader(string3))) continue;
            return tab;
        }
        return null;
    }

    @RobocopTarget
    public Tab loadUrl(String string2) {
        return this.loadUrl(string2, 0);
    }

    public Tab loadUrl(String string2, int n) {
        return this.loadUrl(string2, null, -1, n);
    }

    public Tab loadUrl(String string2, String string3, int n, int n2) {
        JSONObject jSONObject = new JSONObject();
        Tab tab = null;
        boolean bl = (n2 & 0x10) != 0;
        boolean bl2 = bl || (n2 & 0x40) != 0;
        try {
            boolean bl3 = (n2 & 4) != 0;
            boolean bl4 = (n2 & 2) != 0;
            boolean bl5 = (n2 & 0x20) != 0;
            boolean bl6 = (n2 & 0x80) != 0;
            jSONObject.put("url", (Object)string2);
            jSONObject.put("engine", (Object)string3);
            jSONObject.put("parentId", n);
            jSONObject.put("userEntered", bl4);
            jSONObject.put("newTab", (n2 & 1) != 0);
            jSONObject.put("isPrivate", bl3);
            jSONObject.put("pinned", (n2 & 8) != 0);
            jSONObject.put("delayLoad", bl);
            jSONObject.put("desktopMode", bl5);
            jSONObject.put("selected", !bl2);
            if ((n2 & 1) != 0) {
                int n3 = Tabs.getNextTabId();
                jSONObject.put("tabID", n3);
                String string4 = string2 != null && Uri.parse((String)string2).getScheme() != null ? string2 : null;
                tab = this.addTab(n3, string4, bl6, n, string2, bl3, -1);
                tab.setDesktopMode(bl5);
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Error building JSON arguments for loadUrl.", (Throwable)exception);
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Load", jSONObject.toString()));
        if (tab == null) {
            return null;
        }
        if (!bl && !bl2) {
            this.selectTab(tab.getId());
        }
        if (AboutPages.isBuiltinIconPage(string2)) {
            Log.d((String)LOGTAG, (String)"Setting about: tab favicon inline.");
            tab.updateFavicon(this.getAboutPageFavicon(string2));
        }
        return tab;
    }

    public Tab addTab() {
        return this.loadUrl("about:home", 1);
    }

    public Tab addPrivateTab() {
        return this.loadUrl("about:privatebrowsing", 5);
    }

    private Bitmap getAboutPageFavicon(String string2) {
        int n = Math.round(this.mAppContext.getResources().getDimension(R.dimen.browser_toolbar_favicon_size));
        return Favicons.getSizedFaviconForPageFromCache(string2, n);
    }

    public void loadUrlInTab(String string2) {
        Tab tab2;
        Iterable<Tab> iterable = this.getTabsInOrder();
        for (Tab tab2 : iterable) {
            if (!string2.equals(tab2.getURL())) continue;
            this.selectTab(tab2.getId());
            return;
        }
        int n = -1;
        tab2 = this.getSelectedTab();
        if (tab2 != null) {
            n = tab2.getId();
        }
        this.loadUrl(string2, null, n, 1);
    }

    @JNITarget
    public static int getNextTabId() {
        return sTabId.getAndIncrement();
    }

    public static enum TabEvents {
        CLOSED,
        START,
        LOADED,
        LOAD_ERROR,
        STOP,
        FAVICON,
        THUMBNAIL,
        TITLE,
        SELECTED,
        UNSELECTED,
        ADDED,
        RESTORED,
        LOCATION_CHANGE,
        MENU_UPDATED,
        PAGE_SHOW,
        LINK_FAVICON,
        LINK_FEED,
        SECURITY_CHANGE,
        READER_ENABLED,
        DESKTOP_MODE_CHANGE,
        VIEWPORT_CHANGE,
        RECORDING_CHANGE,
        BOOKMARK_ADDED,
        BOOKMARK_REMOVED;

    }

    public static interface OnTabsChangedListener {
        public void onTabChanged(Tab var1, TabEvents var2, Object var3);
    }

    private static class TabsInstanceHolder {
        private static final Tabs INSTANCE = new Tabs();

        private TabsInstanceHolder() {
        }
    }
}

