/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.content.ContentUris;
import android.net.Uri;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.apache.commons.codec.digest.DigestUtils;

public class HealthReportUtils {
    public static final String LOG_TAG = HealthReportUtils.class.getSimpleName();

    public static String getEnvironmentHash(String string2) {
        return DigestUtils.shaHex((String)string2);
    }

    public static Uri getEventURI(Uri uri) {
        return uri.buildUpon().path("/events/" + ContentUris.parseId((Uri)uri) + "/").build();
    }

    private static <T extends Set<String>> T intoKeySet(T t, JSONObject jSONObject) {
        if (jSONObject == null || jSONObject == JSONObject.NULL) {
            return t;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            t.add(iterator.next());
        }
        return t;
    }

    public static SortedSet<String> sortedKeySet(JSONObject jSONObject) {
        return HealthReportUtils.intoKeySet(new TreeSet(), jSONObject);
    }

    public static Set<String> keySet(JSONObject jSONObject) {
        return HealthReportUtils.intoKeySet(new HashSet(), jSONObject);
    }

    public static void append(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (!jSONObject.has(string2)) {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put(object);
            jSONObject.put(string2, (Object)jSONArray);
            return;
        }
        Object object2 = jSONObject.get(string2);
        if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(object2);
        jSONArray.put(object);
        jSONObject.put(string2, (Object)jSONArray);
    }

    public static void count(JSONObject jSONObject, String string2, String string3) throws JSONException {
        if (!jSONObject.has(string2)) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(string3, 1);
            jSONObject.put(string2, (Object)jSONObject2);
            return;
        }
        JSONObject jSONObject3 = jSONObject.getJSONObject(string2);
        jSONObject3.put(string3, jSONObject3.optInt(string3, 0) + 1);
    }

    public static String generateDocumentId() {
        return UUID.randomUUID().toString();
    }
}

