/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.tabs.TabsLayoutAdapter;
import org.mozilla.gecko.tabs.TabsLayoutItemView;
import org.mozilla.gecko.tabs.TabsPanel;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.TwoWayView;

class TabsListLayout
extends TwoWayView
implements TabsPanel.TabsLayout,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "Gecko" + TabsListLayout.class.getSimpleName();
    private final Context mContext;
    private TabsPanel mTabsPanel;
    private final boolean mIsPrivate;
    private final TabsLayoutAdapter mTabsAdapter;
    private final List<View> mPendingClosedTabs;
    private int mCloseAnimationCount;
    private int mCloseAllAnimationCount;
    private final TabSwipeGestureListener mSwipeListener;
    private static final int ANIMATION_DURATION = 250;
    private static final int ANIMATION_CASCADE_DELAY = 75;
    private int mOriginalSize;

    public TabsListLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mPendingClosedTabs = new ArrayList<View>();
        this.setItemsCanFocus(true);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabsLayout);
        this.mIsPrivate = typedArray.getInt(0, 0) == 1;
        typedArray.recycle();
        this.mTabsAdapter = new TabsListLayoutAdapter(this.mContext);
        this.setAdapter((ListAdapter)this.mTabsAdapter);
        this.mSwipeListener = new TabSwipeGestureListener();
        this.setOnTouchListener(this.mSwipeListener);
        this.setOnScrollListener(this.mSwipeListener.makeScrollListener());
        this.setRecyclerListener(new TwoWayView.RecyclerListener(){

            @Override
            public void onMovedToScrapHeap(View view) {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setThumbnail(null);
                tabsLayoutItemView.setCloseVisible(true);
            }
        });
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.mTabsPanel = tabsPanel;
    }

    @Override
    public void show() {
        this.setVisibility(0);
        Tabs.getInstance().refreshThumbnails();
        Tabs.registerOnTabsChangedListener(this);
        this.refreshTabsData();
    }

    @Override
    public void hide() {
        this.setVisibility(8);
        Tabs.unregisterOnTabsChangedListener(this);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Screenshot:Cancel", ""));
        this.mTabsAdapter.clear();
    }

    @Override
    public boolean shouldExpand() {
        return this.isVertical();
    }

    private void autoHidePanel() {
        this.mTabsPanel.autoHidePanel();
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: {
                this.refreshTabsData();
                break;
            }
            case CLOSED: {
                if (tab.isPrivate() != this.mIsPrivate || this.mTabsAdapter.getCount() <= 0 || !this.mTabsAdapter.removeTab(tab)) break;
                int n = this.mTabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
                this.updateSelectedStyle(n);
                break;
            }
            case SELECTED: {
                this.updateSelectedPosition();
            }
            case UNSELECTED: 
            case THUMBNAIL: 
            case TITLE: 
            case RECORDING_CHANGE: {
                View view = this.getChildAt(this.mTabsAdapter.getPositionForTab(tab) - this.getFirstVisiblePosition());
                if (view == null) {
                    return;
                }
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.assignValues(tab);
            }
        }
    }

    private void updateSelectedPosition() {
        int n = this.mTabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
        this.updateSelectedStyle(n);
        if (n != -1) {
            this.setSelection(n);
        }
    }

    private void updateSelectedStyle(int n) {
        for (int i = 0; i < this.mTabsAdapter.getCount(); ++i) {
            this.setItemChecked(i, i == n);
        }
    }

    private void refreshTabsData() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            if (tab.isPrivate() != this.mIsPrivate) continue;
            arrayList.add(tab);
        }
        this.mTabsAdapter.setTabs(arrayList);
        this.updateSelectedPosition();
    }

    public void resetTransforms(View view) {
        ViewHelper.setAlpha(view, 1.0f);
        if (this.isVertical()) {
            ViewHelper.setTranslationX(view, 0.0f);
        } else {
            ViewHelper.setTranslationY(view, 0.0f);
        }
        if (this.mOriginalSize != 0) {
            if (this.isVertical()) {
                ViewHelper.setHeight(view, this.mOriginalSize);
            } else {
                ViewHelper.setWidth(view, this.mOriginalSize);
            }
        }
    }

    private boolean isVertical() {
        return this.getOrientation().compareTo(TwoWayView.Orientation.VERTICAL) == 0;
    }

    @Override
    public void closeAll() {
        int n = this.getChildCount();
        if (n == 0) {
            this.autoHidePanel();
            return;
        }
        this.setEnabled(false);
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            final PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
            propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 0.0f);
            if (this.isVertical()) {
                propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, view.getWidth());
            } else {
                propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, view.getHeight());
            }
            ++this.mCloseAllAnimationCount;
            propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

                @Override
                public void onPropertyAnimationStart() {
                }

                @Override
                public void onPropertyAnimationEnd() {
                    TabsListLayout.this.mCloseAllAnimationCount--;
                    if (TabsListLayout.this.mCloseAllAnimationCount > 0) {
                        return;
                    }
                    TabsListLayout.this.autoHidePanel();
                    TabsListLayout.this.setEnabled(true);
                    Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
                    for (Tab tab : iterable) {
                        if (TabsListLayout.this.mIsPrivate && !tab.isPrivate()) continue;
                        Tabs.getInstance().closeTab(tab, false);
                    }
                }
            });
            ThreadUtils.getUiHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    propertyAnimator.start();
                }
            }, (long)n2);
            n2 += 75;
        }
    }

    private void animateClose(View view, int n) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 0.0f);
        if (this.isVertical()) {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, n);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, n);
        }
        ++this.mCloseAnimationCount;
        this.mPendingClosedTabs.add(view);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                TabsListLayout.this.mCloseAnimationCount--;
                if (TabsListLayout.this.mCloseAnimationCount > 0) {
                    return;
                }
                for (View view : TabsListLayout.this.mPendingClosedTabs) {
                    TabsListLayout.this.animateFinishClose(view);
                }
                TabsListLayout.this.mPendingClosedTabs.clear();
            }
        });
        if (this.mTabsAdapter.getCount() == 1) {
            this.autoHidePanel();
        }
        propertyAnimator.start();
    }

    private void animateFinishClose(View view) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        boolean bl = this.isVertical();
        if (bl) {
            propertyAnimator.attach(view, PropertyAnimator.Property.HEIGHT, 1.0f);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.WIDTH, 1.0f);
        }
        final int n = ((TabsLayoutItemView)view).getTabId();
        if (this.mOriginalSize == 0) {
            this.mOriginalSize = bl ? view.getHeight() : view.getWidth();
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getTab(n);
                tabs.closeTab(tab, true);
            }
        });
        propertyAnimator.start();
    }

    private void animateCancel(final View view) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.isVertical()) {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, 0.0f);
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setCloseVisible(true);
            }
        });
        propertyAnimator.start();
    }

    private class TabSwipeGestureListener
    implements View.OnTouchListener {
        private static final float MIN_VELOCITY = 750.0f;
        private final int mSwipeThreshold;
        private final int mMinFlingVelocity;
        private final int mMaxFlingVelocity;
        private VelocityTracker mVelocityTracker;
        private int mListWidth = 1;
        private int mListHeight = 1;
        private View mSwipeView;
        private Runnable mPendingCheckForTap;
        private float mSwipeStartX;
        private float mSwipeStartY;
        private boolean mSwiping;
        private boolean mEnabled = true;

        public TabSwipeGestureListener() {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)TabsListLayout.this.getContext());
            this.mSwipeThreshold = viewConfiguration.getScaledTouchSlop();
            this.mMinFlingVelocity = (int)(TabsListLayout.this.getContext().getResources().getDisplayMetrics().density * 750.0f);
            this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        }

        public void setEnabled(boolean bl) {
            this.mEnabled = bl;
        }

        public TwoWayView.OnScrollListener makeScrollListener() {
            return new TwoWayView.OnScrollListener(){

                @Override
                public void onScrollStateChanged(TwoWayView twoWayView, int n) {
                    TabSwipeGestureListener.this.setEnabled(n != 1);
                }

                @Override
                public void onScroll(TwoWayView twoWayView, int n, int n2, int n3) {
                }
            };
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (!this.mEnabled) {
                return false;
            }
            if (this.mListWidth < 2 || this.mListHeight < 2) {
                this.mListWidth = TabsListLayout.this.getWidth();
                this.mListHeight = TabsListLayout.this.getHeight();
            }
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    this.triggerCheckForTap();
                    float f = motionEvent.getRawX();
                    float f2 = motionEvent.getRawY();
                    this.mSwipeView = this.findViewAt(f, f2);
                    if (this.mSwipeView != null) {
                        this.mSwipeStartX = motionEvent.getRawX();
                        this.mSwipeStartY = motionEvent.getRawY();
                        this.mVelocityTracker = VelocityTracker.obtain();
                        this.mVelocityTracker.addMovement(motionEvent);
                    }
                    view.onTouchEvent(motionEvent);
                    return true;
                }
                case 1: {
                    if (this.mSwipeView == null) break;
                    this.cancelCheckForTap();
                    this.mSwipeView.setPressed(false);
                    if (!this.mSwiping) {
                        TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)this.mSwipeView;
                        Tabs.getInstance().selectTab(tabsLayoutItemView.getTabId());
                        TabsListLayout.this.autoHidePanel();
                        this.mVelocityTracker.recycle();
                        this.mVelocityTracker = null;
                        break;
                    }
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                    float f = Math.abs(this.mVelocityTracker.getXVelocity());
                    float f3 = Math.abs(this.mVelocityTracker.getYVelocity());
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = 0;
                    if (TabsListLayout.this.isVertical()) {
                        float f4 = ViewHelper.getTranslationX(this.mSwipeView);
                        if (Math.abs(f4) > (float)(this.mListWidth / 2)) {
                            bl = true;
                            bl2 = f4 > 0.0f;
                        } else if ((float)this.mMinFlingVelocity <= f && f <= (float)this.mMaxFlingVelocity && f3 < f) {
                            bl = this.mSwiping && f4 * this.mVelocityTracker.getXVelocity() > 0.0f;
                            bl2 = this.mVelocityTracker.getXVelocity() > 0.0f;
                        }
                        n = bl2 ? this.mListWidth : -this.mListWidth;
                    } else {
                        float f5 = ViewHelper.getTranslationY(this.mSwipeView);
                        if (Math.abs(f5) > (float)(this.mListHeight / 2)) {
                            bl = true;
                            bl2 = f5 > 0.0f;
                        } else if ((float)this.mMinFlingVelocity <= f3 && f3 <= (float)this.mMaxFlingVelocity && f < f3) {
                            bl = this.mSwiping && f5 * this.mVelocityTracker.getYVelocity() > 0.0f;
                            bl2 = this.mVelocityTracker.getYVelocity() > 0.0f;
                        }
                        int n2 = n = bl2 ? this.mListHeight : -this.mListHeight;
                    }
                    if (bl) {
                        TabsListLayout.this.animateClose(this.mSwipeView, n);
                    } else {
                        TabsListLayout.this.animateCancel(this.mSwipeView);
                    }
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                    this.mSwipeView = null;
                    this.mSwipeStartX = 0.0f;
                    this.mSwipeStartY = 0.0f;
                    this.mSwiping = false;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (this.mSwipeView == null || this.mVelocityTracker == null) break;
                    this.mVelocityTracker.addMovement(motionEvent);
                    boolean bl3 = TabsListLayout.this.isVertical();
                    float f = motionEvent.getRawX() - this.mSwipeStartX;
                    float f6 = motionEvent.getRawY() - this.mSwipeStartY;
                    float f7 = bl3 ? f : f6;
                    boolean bl4 = Math.abs(f) > (float)this.mSwipeThreshold;
                    boolean bl5 = Math.abs(f6) > (float)this.mSwipeThreshold;
                    boolean bl6 = bl = bl3 ? bl4 : bl5;
                    if (bl4 || bl5) {
                        this.cancelCheckForTap();
                    }
                    if (bl) {
                        this.mSwiping = true;
                        TabsListLayout.this.requestDisallowInterceptTouchEvent(true);
                        ((TabsLayoutItemView)this.mSwipeView).setCloseVisible(false);
                        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                        motionEvent2.setAction(3 | motionEvent.getActionIndex() << 8);
                        TabsListLayout.this.onTouchEvent(motionEvent2);
                        motionEvent2.recycle();
                    }
                    if (!this.mSwiping) break;
                    if (bl3) {
                        ViewHelper.setTranslationX(this.mSwipeView, f7);
                    } else {
                        ViewHelper.setTranslationY(this.mSwipeView, f7);
                    }
                    ViewHelper.setAlpha(this.mSwipeView, Math.max(0.1f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(f7) / (float)(bl3 ? this.mListWidth : this.mListHeight))));
                    return true;
                }
            }
            return false;
        }

        private View findViewAt(float f, float f2) {
            Rect rect = new Rect();
            int[] nArray = new int[2];
            TabsListLayout.this.getLocationOnScreen(nArray);
            int n = (int)f - nArray[0];
            int n2 = (int)f2 - nArray[1];
            for (int i = 0; i < TabsListLayout.this.getChildCount(); ++i) {
                View view = TabsListLayout.this.getChildAt(i);
                view.getHitRect(rect);
                if (!rect.contains(n, n2)) continue;
                return view;
            }
            return null;
        }

        private void triggerCheckForTap() {
            if (this.mPendingCheckForTap == null) {
                this.mPendingCheckForTap = new CheckForTap();
            }
            TabsListLayout.this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
        }

        private void cancelCheckForTap() {
            if (this.mPendingCheckForTap == null) {
                return;
            }
            TabsListLayout.this.removeCallbacks(this.mPendingCheckForTap);
        }

        private class CheckForTap
        implements Runnable {
            private CheckForTap() {
            }

            @Override
            public void run() {
                if (!TabSwipeGestureListener.this.mSwiping && TabSwipeGestureListener.this.mSwipeView != null && TabSwipeGestureListener.this.mEnabled) {
                    TabSwipeGestureListener.this.mSwipeView.setPressed(true);
                }
            }
        }
    }

    private class TabsListLayoutAdapter
    extends TabsLayoutAdapter {
        private final View.OnClickListener mCloseOnClickListener;

        public TabsListLayoutAdapter(Context context) {
            super(context, R.layout.tabs_layout_item_view);
            this.mCloseOnClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)((Object)view.getTag());
                    int n = TabsListLayout.this.isVertical() ? tabsLayoutItemView.getWidth() : 0 - tabsLayoutItemView.getHeight();
                    TabsListLayout.this.animateClose((View)tabsLayoutItemView, n);
                }
            };
        }

        @Override
        public TabsLayoutItemView newView(int n, ViewGroup viewGroup) {
            TabsLayoutItemView tabsLayoutItemView = super.newView(n, viewGroup);
            tabsLayoutItemView.setCloseOnClickListener(this.mCloseOnClickListener);
            return tabsLayoutItemView;
        }

        @Override
        public void bindView(TabsLayoutItemView tabsLayoutItemView, Tab tab) {
            super.bindView(tabsLayoutItemView, tab);
            TabsListLayout.this.resetTransforms((View)tabsLayoutItemView);
        }
    }
}

