/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;
import org.webrtc.videoengine.ViERenderer;

public class VideoCaptureAndroid
implements Camera.PreviewCallback,
SurfaceHolder.Callback,
GeckoAppShell.AppStateListener {
    private static final String TAG = "WEBRTC-JC";
    Camera camera;
    private Camera.CameraInfo info;
    private final int id;
    private final long native_capturer;
    private SurfaceHolder localPreview;
    private SurfaceTexture dummySurfaceTexture;
    private final int numCaptureBuffers = 3;
    volatile int mCaptureRotation;
    int mCaptureWidth;
    int mCaptureHeight;
    int mCaptureMinFPS;
    int mCaptureMaxFPS;
    boolean mResumeCapture;

    @WebRTCJNITarget
    public VideoCaptureAndroid(int n, long l) {
        this.id = n;
        this.native_capturer = l;
        if (Build.VERSION.SDK_INT > 8) {
            this.info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)this.info);
        }
        this.mCaptureRotation = this.GetRotateAmount();
    }

    public synchronized void onPause() {
        if (this.camera != null) {
            this.mResumeCapture = true;
            this.stopCapture();
        }
    }

    public synchronized void onResume() {
        if (this.mResumeCapture) {
            this.startCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureMinFPS, this.mCaptureMaxFPS);
            this.mResumeCapture = false;
        }
    }

    public void onOrientationChanged() {
        this.mCaptureRotation = this.GetRotateAmount();
    }

    public int GetRotateAmount() {
        int n = GeckoAppShell.getGeckoInterface().getActivity().getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
            }
        }
        if (Build.VERSION.SDK_INT > 8) {
            int n3 = this.info.facing == 1 ? (this.info.orientation + n2) % 360 : (this.info.orientation - n2 + 360) % 360;
            return n3;
        }
        int n4 = 90;
        int n5 = (n4 - n2 + 360) % 360;
        return n5;
    }

    @WebRTCJNITarget
    private synchronized boolean startCapture(int n, int n2, int n3, int n4) {
        Log.d((String)TAG, (String)("startCapture: " + n + "x" + n2 + "@" + n3 + ":" + n4));
        if (!this.mResumeCapture) {
            ViERenderer.CreateLocalRenderer();
        }
        Exception exception = null;
        try {
            List list;
            this.camera = Build.VERSION.SDK_INT > 8 ? Camera.open((int)this.id) : Camera.open();
            this.localPreview = ViERenderer.GetLocalRenderer();
            if (this.localPreview != null) {
                this.localPreview.addCallback((SurfaceHolder.Callback)this);
                if (this.localPreview.getSurface() != null && this.localPreview.getSurface().isValid()) {
                    this.camera.setPreviewDisplay(this.localPreview);
                }
            } else if (Build.VERSION.SDK_INT > 10) {
                try {
                    this.dummySurfaceTexture = new SurfaceTexture(42);
                    this.camera.setPreviewTexture(this.dummySurfaceTexture);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                throw new RuntimeException("No preview surface for Camera.");
            }
            Camera.Parameters parameters = this.camera.getParameters();
            if (Build.VERSION.SDK_INT > 14) {
                Log.d((String)TAG, (String)("isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported()));
                if (parameters.isVideoStabilizationSupported()) {
                    parameters.setVideoStabilization(true);
                }
            }
            if ((list = parameters.getSupportedFocusModes()) != null && list.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            }
            parameters.setPreviewSize(n, n2);
            if (Build.VERSION.SDK_INT > 8) {
                parameters.setPreviewFpsRange(n3, n4);
            } else {
                parameters.setPreviewFrameRate(n4 / 1000);
            }
            int n5 = 17;
            parameters.setPreviewFormat(n5);
            this.camera.setParameters(parameters);
            int n6 = n * n2 * ImageFormat.getBitsPerPixel((int)n5) / 8;
            for (int i = 0; i < 3; ++i) {
                this.camera.addCallbackBuffer(new byte[n6]);
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            this.camera.startPreview();
            this.mCaptureWidth = n;
            this.mCaptureHeight = n2;
            this.mCaptureMinFPS = n3;
            this.mCaptureMaxFPS = n4;
            if (!this.mResumeCapture) {
                GeckoAppShell.getGeckoInterface().addAppStateListener((GeckoAppShell.AppStateListener)this);
            }
            return true;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        Log.e((String)TAG, (String)"startCapture failed", (Throwable)exception);
        if (this.camera != null) {
            this.stopCapture();
        }
        return false;
    }

    @WebRTCJNITarget
    private synchronized boolean stopCapture() {
        Log.d((String)TAG, (String)"stopCapture");
        if (this.camera == null) {
            if (this.mResumeCapture) {
                this.mResumeCapture = false;
                return true;
            }
            throw new RuntimeException("Camera is already stopped!");
        }
        Exception exception = null;
        try {
            this.camera.setPreviewCallbackWithBuffer(null);
            this.camera.stopPreview();
            if (this.localPreview != null) {
                this.localPreview.removeCallback((SurfaceHolder.Callback)this);
                this.camera.setPreviewDisplay(null);
            } else if (Build.VERSION.SDK_INT > 10) {
                this.camera.setPreviewTexture(null);
            }
            this.camera.release();
            this.camera = null;
            if (!this.mResumeCapture) {
                GeckoAppShell.getGeckoInterface().removeAppStateListener((GeckoAppShell.AppStateListener)this);
                ViERenderer.DestroyLocalRenderer();
            }
            return true;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        Log.e((String)TAG, (String)"Failed to stop camera", (Throwable)exception);
        return false;
    }

    @WebRTCJNITarget
    private native void ProvideCameraFrame(byte[] var1, int var2, long var3, int var5);

    @WebRTCJNITarget
    public synchronized void onPreviewFrame(byte[] byArray, Camera camera) {
        if (byArray != null) {
            this.ProvideCameraFrame(byArray, byArray.length, this.native_capturer, this.mCaptureRotation);
            camera.addCallbackBuffer(byArray);
        }
    }

    @WebRTCJNITarget
    public synchronized void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.d((String)TAG, (String)("VideoCaptureAndroid::surfaceChanged ignored: " + n + ": " + n2 + "x" + n3));
    }

    @WebRTCJNITarget
    public synchronized void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceCreated");
        try {
            if (this.camera != null) {
                this.camera.setPreviewDisplay(surfaceHolder);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @WebRTCJNITarget
    public synchronized void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.d((String)TAG, (String)"VideoCaptureAndroid::surfaceDestroyed");
        try {
            if (this.camera != null) {
                this.camera.setPreviewDisplay(null);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

