/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.support.v4.app.NotificationCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.preferences.GeckoPreferences;

public class DataReportingNotification {
    private static final String LOGTAG = "DataReportNotification";
    public static final String ALERT_NAME_DATAREPORTING_NOTIFICATION = "datareporting-notification";
    private static final String PREFS_POLICY_NOTIFIED_TIME = "datareporting.policy.dataSubmissionPolicyNotifiedTime";
    private static final String PREFS_POLICY_VERSION = "datareporting.policy.dataSubmissionPolicyVersion";
    private static final int DATA_REPORTING_VERSION = 2;

    public static void checkAndNotifyPolicy(Context context) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        int n = sharedPreferences.getInt(PREFS_POLICY_VERSION, -1);
        if (n < 1) {
            DataReportingNotification.notifyDataPolicy(context, sharedPreferences);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean(GeckoPreferences.PREFS_HEALTHREPORT_UPLOAD_ENABLED, true);
            editor.apply();
            return;
        }
        if (n == 1) {
            if (TextUtils.equals((CharSequence)"beta", (CharSequence)"nightly-maple")) {
                DataReportingNotification.notifyDataPolicy(context, sharedPreferences);
            } else {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putInt(PREFS_POLICY_VERSION, 2);
                editor.apply();
            }
            return;
        }
        if (n >= 2) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyDataPolicy(Context context, SharedPreferences sharedPreferences) {
        boolean bl = false;
        try {
            Intent intent = new Intent("org.mozilla.gecko.SETTINGS");
            intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
            GeckoPreferences.setResourceToOpen(intent, "preferences_vendor");
            intent.putExtra(ALERT_NAME_DATAREPORTING_NOTIFICATION, true);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
            Resources resources = context.getResources();
            String string2 = resources.getString(R.string.datareporting_notification_title);
            String string3 = AppConstants.Versions.preJB ? resources.getString(R.string.datareporting_notification_action) : resources.getString(R.string.datareporting_notification_summary);
            String string4 = resources.getString(R.string.datareporting_notification_action);
            String string5 = resources.getString(R.string.datareporting_notification_summary);
            String string6 = resources.getString(R.string.datareporting_notification_ticker_text);
            SpannableString spannableString = new SpannableString((CharSequence)string6);
            spannableString.setSpan((Object)new StyleSpan(1), 0, string2.length(), 17);
            Notification notification = new NotificationCompat.Builder(context).setContentTitle((CharSequence)string2).setContentText((CharSequence)string3).setSmallIcon(R.drawable.ic_status_logo).setAutoCancel(true).setContentIntent(pendingIntent).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string5)).addAction(R.drawable.firefox_settings_alert, (CharSequence)string4, pendingIntent).setTicker((CharSequence)spannableString).build();
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            int n = ALERT_NAME_DATAREPORTING_NOTIFICATION.hashCode();
            notificationManager.notify(n, notification);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            long l = System.currentTimeMillis();
            editor.putLong(PREFS_POLICY_NOTIFIED_TIME, l);
            editor.putInt(PREFS_POLICY_VERSION, 2);
            editor.apply();
            bl = true;
        }
        finally {
            Telemetry.sendUIEvent(TelemetryContract.Event.POLICY_NOTIFICATION_SUCCESS, bl);
        }
    }
}

