/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import org.mozilla.gecko.R;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;

public class SharedPreferencesClientsDataDelegate
implements ClientsDataDelegate {
    protected final SharedPreferences sharedPreferences;
    protected final Context context;

    public SharedPreferencesClientsDataDelegate(SharedPreferences sharedPreferences, Context context) {
        this.sharedPreferences = sharedPreferences;
        this.context = context;
    }

    @Override
    public synchronized String getAccountGUID() {
        String string2 = this.sharedPreferences.getString("account.guid", null);
        if (string2 == null) {
            string2 = Utils.generateGuid();
            this.sharedPreferences.edit().putString("account.guid", string2).commit();
        }
        return string2;
    }

    @Override
    public synchronized void setClientName(String string2, long l) {
        this.sharedPreferences.edit().putString("account.clientName", string2).putLong("account.clientDataTimestamp", l).commit();
    }

    @Override
    public String getDefaultClientName() {
        String string2 = "Nightly";
        if (string2.contains("Aurora")) {
            string2 = "Aurora";
        } else if (string2.contains("Beta")) {
            string2 = "Beta";
        } else if (string2.contains("Nightly")) {
            string2 = "Nightly";
        }
        return this.context.getResources().getString(R.string.sync_default_client_name, new Object[]{string2, Build.MODEL});
    }

    @Override
    public synchronized String getClientName() {
        String string2 = this.sharedPreferences.getString("account.clientName", null);
        if (string2 == null) {
            string2 = this.getDefaultClientName();
            long l = System.currentTimeMillis();
            this.setClientName(string2, l);
        }
        return string2;
    }

    @Override
    public synchronized void setClientsCount(int n) {
        this.sharedPreferences.edit().putLong("account.numClients", (long)n).commit();
    }

    @Override
    public boolean isLocalGUID(String string2) {
        return this.getAccountGUID().equals(string2);
    }

    @Override
    public synchronized int getClientsCount() {
        return (int)this.sharedPreferences.getLong("account.numClients", 0L);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.sharedPreferences.getLong("account.clientDataTimestamp", 0L);
    }
}

