/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.widget.ArrowPopup;
import org.mozilla.gecko.widget.DoorHanger;

public class SiteIdentityPopup
extends ArrowPopup {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private static final String TRACKING_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private SiteIdentity mSiteIdentity;
    private LinearLayout mIdentity;
    private TextView mHost;
    private TextView mOwner;
    private TextView mVerifier;
    private DoorHanger mMixedContentNotification;
    private DoorHanger mTrackingContentNotification;
    private final DoorHanger.OnButtonClickListener mButtonClickListener = new PopupButtonListener();

    public SiteIdentityPopup(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mHost = (TextView)this.mIdentity.findViewById(R.id.host);
        this.mOwner = (TextView)this.mIdentity.findViewById(R.id.owner);
        this.mVerifier = (TextView)this.mIdentity.findViewById(R.id.verifier);
    }

    private void updateIdentity() {
        if (!this.mInflated) {
            this.init();
        }
        SiteIdentity.MixedMode mixedMode = this.mSiteIdentity.getMixedMode();
        SiteIdentity.TrackingMode trackingMode = this.mSiteIdentity.getTrackingMode();
        if (mixedMode != SiteIdentity.MixedMode.UNKNOWN || trackingMode != SiteIdentity.TrackingMode.UNKNOWN) {
            this.mContent.setPadding(0, (int)this.mContext.getResources().getDimension(R.dimen.identity_padding_top), 0, 0);
            this.mIdentity.setVisibility(8);
        } else {
            this.mHost.setText((CharSequence)this.mSiteIdentity.getHost());
            String string2 = this.mSiteIdentity.getOwner();
            String string3 = this.mSiteIdentity.getSupplemental();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                string2 = string2 + "\n" + string3;
            }
            this.mOwner.setText((CharSequence)string2);
            String string4 = this.mSiteIdentity.getVerifier();
            String string5 = this.mSiteIdentity.getEncrypted();
            this.mVerifier.setText((CharSequence)(string4 + "\n" + string5));
            this.mContent.setPadding(0, 0, 0, 0);
            this.mIdentity.setVisibility(0);
        }
    }

    private void addMixedContentNotification(boolean bl) {
        String string2;
        int n;
        this.removeMixedContentNotification();
        this.mMixedContentNotification = new DoorHanger(this.mContext, DoorHanger.Theme.DARK);
        if (bl) {
            n = R.drawable.shield_doorhanger;
            string2 = this.mContext.getString(R.string.blocked_mixed_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_mixed_content_message_bottom);
        } else {
            n = R.drawable.warning_doorhanger;
            string2 = this.mContext.getString(R.string.loaded_mixed_content_message);
        }
        this.mMixedContentNotification.setIcon(n);
        this.mMixedContentNotification.setMessage(string2);
        this.mMixedContentNotification.addLink(this.mContext.getString(R.string.learn_more), "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android", "\n\n");
        this.addNotificationButtons(this.mMixedContentNotification, bl);
        this.mContent.addView((View)this.mMixedContentNotification);
    }

    private void removeMixedContentNotification() {
        if (this.mMixedContentNotification != null) {
            this.mContent.removeView((View)this.mMixedContentNotification);
            this.mMixedContentNotification = null;
        }
    }

    private void addTrackingContentNotification(boolean bl) {
        String string2;
        int n;
        this.removeTrackingContentNotification();
        this.mTrackingContentNotification = new DoorHanger(this.mContext, DoorHanger.Theme.DARK);
        if (bl) {
            n = R.drawable.shield_doorhanger;
            string2 = this.mContext.getString(R.string.blocked_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_tracking_content_message_bottom);
        } else {
            n = R.drawable.warning_doorhanger;
            string2 = this.mContext.getString(R.string.loaded_tracking_content_message);
        }
        this.mTrackingContentNotification.setIcon(n);
        this.mTrackingContentNotification.setMessage(string2);
        this.mTrackingContentNotification.addLink(this.mContext.getString(R.string.learn_more), "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android", "\n\n");
        this.addNotificationButtons(this.mTrackingContentNotification, bl);
        this.mContent.addView((View)this.mTrackingContentNotification);
    }

    private void removeTrackingContentNotification() {
        if (this.mTrackingContentNotification != null) {
            this.mContent.removeView((View)this.mTrackingContentNotification);
            this.mTrackingContentNotification = null;
        }
    }

    private void addNotificationButtons(DoorHanger doorHanger, boolean bl) {
        if (bl) {
            doorHanger.addButton(this.mContext.getString(R.string.disable_protection), "disable", this.mButtonClickListener);
            doorHanger.addButton(this.mContext.getString(R.string.keep_blocking), "keepBlocking", this.mButtonClickListener);
        } else {
            doorHanger.addButton(this.mContext.getString(R.string.enable_protection), "enable", this.mButtonClickListener);
        }
    }

    void setSiteIdentity(SiteIdentity siteIdentity) {
        this.mSiteIdentity = siteIdentity;
    }

    @Override
    public void show() {
        if (this.mSiteIdentity == null) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup for undefined state");
            return;
        }
        SiteIdentity.SecurityMode securityMode = this.mSiteIdentity.getSecurityMode();
        SiteIdentity.MixedMode mixedMode = this.mSiteIdentity.getMixedMode();
        SiteIdentity.TrackingMode trackingMode = this.mSiteIdentity.getTrackingMode();
        if (securityMode == SiteIdentity.SecurityMode.UNKNOWN && mixedMode == SiteIdentity.MixedMode.UNKNOWN && trackingMode == SiteIdentity.TrackingMode.UNKNOWN) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup in a completely unknown state");
            return;
        }
        this.updateIdentity();
        if (mixedMode != SiteIdentity.MixedMode.UNKNOWN) {
            this.addMixedContentNotification(mixedMode == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED);
        }
        if (trackingMode != SiteIdentity.TrackingMode.UNKNOWN) {
            this.addTrackingContentNotification(trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED);
        }
        this.showDividers();
        super.show();
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            View view = this.mContent.getChildAt(i);
            if (!(view instanceof DoorHanger)) continue;
            DoorHanger doorHanger2 = (DoorHanger)view;
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    public void dismiss() {
        super.dismiss();
        this.removeMixedContentNotification();
        this.removeTrackingContentNotification();
    }

    private class PopupButtonListener
    implements DoorHanger.OnButtonClickListener {
        private PopupButtonListener() {
        }

        @Override
        public void onButtonClick(DoorHanger doorHanger, String string2) {
            try {
                JSONObject jSONObject = new JSONObject();
                String string3 = doorHanger == SiteIdentityPopup.this.mMixedContentNotification ? "allowMixedContent" : "allowTrackingContent";
                jSONObject.put(string3, string2.equals("disable"));
                GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", jSONObject.toString());
                GeckoAppShell.sendEventToGecko(geckoEvent);
            }
            catch (JSONException jSONException) {
                Log.e((String)SiteIdentityPopup.LOGTAG, (String)"Exception creating message to enable/disable content blocking", (Throwable)jSONException);
            }
            SiteIdentityPopup.this.dismiss();
        }
    }
}

