/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class StatsSnapshot {
    private static final String TAG = "Picasso";
    public final int maxSize;
    public final int size;
    public final long cacheHits;
    public final long cacheMisses;
    public final long totalOriginalBitmapSize;
    public final long totalTransformedBitmapSize;
    public final long averageOriginalBitmapSize;
    public final long averageTransformedBitmapSize;
    public final int originalBitmapCount;
    public final int transformedBitmapCount;
    public final long timeStamp;

    public StatsSnapshot(int n, int n2, long l, long l2, long l3, long l4, long l5, long l6, int n3, int n4, long l7) {
        this.maxSize = n;
        this.size = n2;
        this.cacheHits = l;
        this.cacheMisses = l2;
        this.totalOriginalBitmapSize = l3;
        this.totalTransformedBitmapSize = l4;
        this.averageOriginalBitmapSize = l5;
        this.averageTransformedBitmapSize = l6;
        this.originalBitmapCount = n3;
        this.transformedBitmapCount = n4;
        this.timeStamp = l7;
    }

    public void dump() {
        StringWriter stringWriter = new StringWriter();
        this.dump(new PrintWriter(stringWriter));
        Log.i((String)TAG, (String)stringWriter.toString());
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("===============BEGIN PICASSO STATS ===============");
        printWriter.println("Memory Cache Stats");
        printWriter.print("  Max Cache Size: ");
        printWriter.println(this.maxSize);
        printWriter.print("  Cache Size: ");
        printWriter.println(this.size);
        printWriter.print("  Cache % Full: ");
        printWriter.println((int)Math.ceil((float)this.size / (float)this.maxSize * 100.0f));
        printWriter.print("  Cache Hits: ");
        printWriter.println(this.cacheHits);
        printWriter.print("  Cache Misses: ");
        printWriter.println(this.cacheMisses);
        printWriter.println("Bitmap Stats");
        printWriter.print("  Total Bitmaps Decoded: ");
        printWriter.println(this.originalBitmapCount);
        printWriter.print("  Total Bitmap Size: ");
        printWriter.println(this.totalOriginalBitmapSize);
        printWriter.print("  Total Transformed Bitmaps: ");
        printWriter.println(this.transformedBitmapCount);
        printWriter.print("  Total Transformed Bitmap Size: ");
        printWriter.println(this.totalTransformedBitmapSize);
        printWriter.print("  Average Bitmap Size: ");
        printWriter.println(this.averageOriginalBitmapSize);
        printWriter.print("  Average Transformed Bitmap Size: ");
        printWriter.println(this.averageTransformedBitmapSize);
        printWriter.println("===============END PICASSO STATS ===============");
        printWriter.flush();
    }

    public String toString() {
        return "StatsSnapshot{maxSize=" + this.maxSize + ", size=" + this.size + ", cacheHits=" + this.cacheHits + ", cacheMisses=" + this.cacheMisses + ", totalOriginalBitmapSize=" + this.totalOriginalBitmapSize + ", totalTransformedBitmapSize=" + this.totalTransformedBitmapSize + ", averageOriginalBitmapSize=" + this.averageOriginalBitmapSize + ", averageTransformedBitmapSize=" + this.averageTransformedBitmapSize + ", originalBitmapCount=" + this.originalBitmapCount + ", transformedBitmapCount=" + this.transformedBitmapCount + ", timeStamp=" + this.timeStamp + '}';
    }
}

