/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import org.mozilla.gecko.db.BaseTable;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.Table;

public class URLMetadataTable
extends BaseTable {
    private static final String LOGTAG = "GeckoURLMetadataTable";
    private static final String TABLE = "metadata";
    private static final int TABLE_ID_NUMBER = 1200;
    public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)BrowserContract.AUTHORITY_URI, (String)"metadata");
    public static final String ID_COLUMN = "id";
    public static final String URL_COLUMN = "url";
    public static final String TILE_IMAGE_URL_COLUMN = "tileImage";
    public static final String TILE_COLOR_COLUMN = "tileColor";

    URLMetadataTable() {
    }

    @Override
    protected String getTable() {
        return TABLE;
    }

    @Override
    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        String string2 = "CREATE TABLE metadata (id INTEGER PRIMARY KEY, url TEXT NON NULL UNIQUE, tileImage STRING, tileColor STRING);";
        sQLiteDatabase.execSQL(string2);
        sQLiteDatabase.execSQL("CREATE INDEX metadata_url_idx ON metadata (url)");
    }

    @Override
    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        if (n2 >= 21 && n < 21) {
            this.onCreate(sQLiteDatabase);
        }
    }

    @Override
    public Table.ContentProviderInfo[] getContentProviderInfo() {
        return new Table.ContentProviderInfo[]{new Table.ContentProviderInfo(1200, TABLE)};
    }
}

