/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountAgeLockoutHelper;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountNotAllowedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSignInActivity;
import org.mozilla.gecko.fxa.tasks.FxAccountCreateAccountTask;

public class FxAccountCreateAccountActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountCreateAccountActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 2;
    protected String[] yearItems;
    protected EditText yearEdit;
    protected CheckBox chooseCheckBox;
    protected Map<String, Boolean> selectedEngines;

    @Override
    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_create_account);
        this.emailEdit = (AutoCompleteTextView)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.yearEdit = (EditText)this.ensureFindViewById(null, R.id.year_edit, "year edit");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "create account button");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.chooseCheckBox = (CheckBox)this.ensureFindViewById(null, R.id.choose_what_to_sync_checkbox, "choose what to sync check box");
        this.selectedEngines = new HashMap<String, Boolean>();
        this.createCreateAccountButton();
        this.createYearEdit();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.linkifyPolicy();
        this.createChooseCheckBox();
        View view = this.ensureFindViewById(null, R.id.sign_in_instead_link, "sign in instead link");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Bundle bundle = FxAccountCreateAccountActivity.this.makeExtrasBundle(null, null);
                FxAccountCreateAccountActivity.this.startActivityInstead(FxAccountSignInActivity.class, 2, bundle);
            }
        });
        this.updateFromIntentExtras();
    }

    @Override
    protected Bundle makeExtrasBundle(String string2, String string3) {
        Bundle bundle = super.makeExtrasBundle(string2, string3);
        String string4 = this.yearEdit.getText().toString();
        bundle.putString("year", string4);
        return bundle;
    }

    @Override
    protected void updateFromIntentExtras() {
        super.updateFromIntentExtras();
        if (this.getIntent() != null) {
            this.yearEdit.setText((CharSequence)this.getIntent().getStringExtra("year"));
        }
    }

    @Override
    protected void showClientRemoteException(final FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
        if (!fxAccountClientRemoteException.isAccountAlreadyExists()) {
            super.showClientRemoteException(fxAccountClientRemoteException);
            return;
        }
        String string2 = this.getString(R.string.fxaccount_sign_in_button_label);
        String string3 = this.getString(fxAccountClientRemoteException.getErrorMessageStringResource(), new Object[]{string2});
        int n = string3.lastIndexOf(string2);
        int n2 = n + string2.length();
        Spannable spannable = Spannable.Factory.getInstance().newSpannable((CharSequence)string3);
        spannable.setSpan((Object)new ClickableSpan(){

            public void onClick(View view) {
                String string2 = fxAccountClientRemoteException.body.getString("email");
                if (string2 == null) {
                    string2 = FxAccountCreateAccountActivity.this.emailEdit.getText().toString();
                }
                String string3 = FxAccountCreateAccountActivity.this.passwordEdit.getText().toString();
                Bundle bundle = FxAccountCreateAccountActivity.this.makeExtrasBundle(string2, string3);
                FxAccountCreateAccountActivity.this.startActivityInstead(FxAccountSignInActivity.class, 2, bundle);
            }
        }, n, n2, 33);
        this.remoteErrorTextView.setMovementMethod(LinkMovementMethod.getInstance());
        this.remoteErrorTextView.setText((CharSequence)spannable);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n);
        if (n != 2 || n2 != -1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        this.setResult(n2, intent);
        this.finish();
    }

    protected String[] getYearItems() {
        int n = Calendar.getInstance().get(1);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.getResources().getString(R.string.fxaccount_create_account_1990_or_earlier));
        for (int i = 1991; i <= n - 5; ++i) {
            linkedList.add(Integer.toString(i));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    protected void createYearEdit() {
        this.yearItems = this.getYearItems();
        this.yearEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        FxAccountCreateAccountActivity.this.yearEdit.setText((CharSequence)FxAccountCreateAccountActivity.this.yearItems[n]);
                        FxAccountCreateAccountActivity.this.updateButtonState();
                    }
                };
                AlertDialog alertDialog = new AlertDialog.Builder((Context)FxAccountCreateAccountActivity.this).setTitle(R.string.fxaccount_create_account_year_of_birth).setItems((CharSequence[])FxAccountCreateAccountActivity.this.yearItems, onClickListener).setIcon(R.drawable.icon).create();
                alertDialog.show();
            }
        });
    }

    public void createAccount(String string2, String string3, Map<String, Boolean> map) {
        String string4 = this.getAuthServerEndpoint();
        PasswordStretcher passwordStretcher = this.makePasswordStretcher(string3);
        FxAccountAbstractSetupActivity.AddAccountDelegate addAccountDelegate = new FxAccountAbstractSetupActivity.AddAccountDelegate(string2, passwordStretcher, string4, map){

            @Override
            public void handleError(Exception exception) {
                FxAccountCreateAccountActivity.this.showRemoteError(exception, R.string.fxaccount_create_account_unknown_error);
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                FxAccountCreateAccountActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_create_account_unknown_error);
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            this.hideRemoteError();
            new FxAccountCreateAccountTask((Context)this, this, string2, passwordStretcher, fxAccountClient20, addAccountDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception, R.string.fxaccount_create_account_unknown_error);
        }
    }

    @Override
    protected boolean shouldButtonBeEnabled() {
        return super.shouldButtonBeEnabled() && this.yearEdit.length() > 0;
    }

    protected void createCreateAccountButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Map<String, Boolean> map;
                if (!FxAccountCreateAccountActivity.this.updateButtonState()) {
                    return;
                }
                String string2 = FxAccountCreateAccountActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountCreateAccountActivity.this.passwordEdit.getText().toString();
                Map<String, Boolean> map2 = map = FxAccountCreateAccountActivity.this.chooseCheckBox.isChecked() ? FxAccountCreateAccountActivity.this.selectedEngines : null;
                if (FxAccountAgeLockoutHelper.passesAgeCheck(FxAccountCreateAccountActivity.this.yearEdit.getText().toString(), FxAccountCreateAccountActivity.this.yearItems)) {
                    FxAccountUtils.pii(LOG_TAG, "Passed age check.");
                    FxAccountCreateAccountActivity.this.createAccount(string2, string3, map);
                } else {
                    FxAccountUtils.pii(LOG_TAG, "Failed age check!");
                    FxAccountAgeLockoutHelper.lockOut(SystemClock.elapsedRealtime());
                    FxAccountCreateAccountActivity.this.setResult(0);
                    FxAccountCreateAccountActivity.this.redirectToActivity(FxAccountCreateAccountNotAllowedActivity.class);
                }
            }
        });
    }

    protected void createChooseCheckBox() {
        CharSequence[] charSequenceArray = new String[4];
        final boolean[] blArray = new boolean[4];
        charSequenceArray[0] = this.getResources().getString(R.string.fxaccount_status_bookmarks);
        charSequenceArray[1] = this.getResources().getString(R.string.fxaccount_status_history);
        charSequenceArray[2] = this.getResources().getString(R.string.fxaccount_status_tabs);
        charSequenceArray[3] = this.getResources().getString(R.string.fxaccount_status_passwords);
        for (int i = 0; i < 4; ++i) {
            blArray[i] = true;
        }
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                if (n != -1) {
                    Logger.debug(LOG_TAG, "onClick: not button positive, unchecking.");
                    FxAccountCreateAccountActivity.this.chooseCheckBox.setChecked(false);
                    return;
                }
                Logger.debug(LOG_TAG, "onClick: button positive, checking.");
                FxAccountCreateAccountActivity.this.chooseCheckBox.setChecked(true);
                ListView listView = ((AlertDialog)dialogInterface).getListView();
                for (int i = 0; i < 4; ++i) {
                    blArray[i] = listView.isItemChecked(i);
                }
                FxAccountCreateAccountActivity.this.selectedEngines.put("bookmarks", blArray[0]);
                FxAccountCreateAccountActivity.this.selectedEngines.put("history", blArray[1]);
                FxAccountCreateAccountActivity.this.selectedEngines.put("tabs", blArray[2]);
                FxAccountCreateAccountActivity.this.selectedEngines.put("passwords", blArray[3]);
                FxAccountUtils.pii(LOG_TAG, "Updating selectedEngines: " + FxAccountCreateAccountActivity.this.selectedEngines.toString());
            }
        };
        DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener = new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
                ListView listView = ((AlertDialog)dialogInterface).getListView();
                listView.setItemChecked(n, bl);
            }
        };
        final AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.fxaccount_create_account_choose_what_to_sync).setIcon(R.drawable.icon).setMultiChoiceItems(charSequenceArray, blArray, onMultiChoiceClickListener).setPositiveButton(17039370, onClickListener).setNegativeButton(0x1040000, onClickListener).create();
        alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                Logger.debug(LOG_TAG, "onCancel: unchecking.");
                FxAccountCreateAccountActivity.this.chooseCheckBox.setChecked(false);
            }
        });
        this.chooseCheckBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!FxAccountCreateAccountActivity.this.chooseCheckBox.isChecked()) {
                    Logger.debug(LOG_TAG, "onClick: was checked, not showing dialog.");
                    return;
                }
                Logger.debug(LOG_TAG, "onClick: was unchecked, showing dialog.");
                alertDialog.show();
            }
        });
    }
}

