/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceCategory;
import android.preference.PreferenceScreen;
import android.text.TextUtils;
import android.text.format.DateUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.preferences.PreferenceFragment;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountConfirmAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountUpdateCredentialsActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.FxAccountSyncStatusHelper;
import org.mozilla.gecko.fxa.tasks.FxAccountCodeResender;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.util.HardwareUtils;

public class FxAccountStatusFragment
extends PreferenceFragment
implements Preference.OnPreferenceClickListener,
Preference.OnPreferenceChangeListener {
    private static final String LOG_TAG = FxAccountStatusFragment.class.getSimpleName();
    private static final long DELAY_IN_MILLISECONDS_BEFORE_REQUESTING_SYNC = 5000L;
    private static boolean ALWAYS_SHOW_AUTH_SERVER = false;
    private static boolean ALWAYS_SHOW_SYNC_SERVER = false;
    protected PreferenceCategory accountCategory;
    protected Preference emailPreference;
    protected Preference authServerPreference;
    protected Preference needsPasswordPreference;
    protected Preference needsUpgradePreference;
    protected Preference needsVerificationPreference;
    protected Preference needsMasterSyncAutomaticallyEnabledPreference;
    protected Preference needsAccountEnabledPreference;
    protected PreferenceCategory syncCategory;
    protected CheckBoxPreference bookmarksPreference;
    protected CheckBoxPreference historyPreference;
    protected CheckBoxPreference tabsPreference;
    protected CheckBoxPreference passwordsPreference;
    protected EditTextPreference deviceNamePreference;
    protected Preference syncServerPreference;
    protected Preference morePreference;
    protected Preference syncNowPreference;
    protected volatile AndroidFxAccount fxAccount;
    protected volatile SharedPreferencesClientsDataDelegate clientsDataDelegate;
    protected Handler handler;
    protected Runnable requestSyncRunnable;
    protected final InnerSyncStatusDelegate syncStatusDelegate = new InnerSyncStatusDelegate();

    protected Preference ensureFindPreference(String string2) {
        Preference preference = this.findPreference(string2);
        if (preference == null) {
            throw new IllegalStateException("Could not find preference with key: " + string2);
        }
        return preference;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        HardwareUtils.init((Context)this.getActivity());
        this.addPreferences();
    }

    protected void addPreferences() {
        this.addPreferencesFromResource(R.xml.fxaccount_status_prefscreen);
        this.accountCategory = (PreferenceCategory)this.ensureFindPreference("signed_in_as_category");
        this.emailPreference = this.ensureFindPreference("email");
        this.authServerPreference = this.ensureFindPreference("auth_server");
        this.needsPasswordPreference = this.ensureFindPreference("needs_credentials");
        this.needsUpgradePreference = this.ensureFindPreference("needs_upgrade");
        this.needsVerificationPreference = this.ensureFindPreference("needs_verification");
        this.needsMasterSyncAutomaticallyEnabledPreference = this.ensureFindPreference("needs_master_sync_automatically_enabled");
        this.needsAccountEnabledPreference = this.ensureFindPreference("needs_account_enabled");
        this.syncCategory = (PreferenceCategory)this.ensureFindPreference("sync_category");
        this.bookmarksPreference = (CheckBoxPreference)this.ensureFindPreference("bookmarks");
        this.historyPreference = (CheckBoxPreference)this.ensureFindPreference("history");
        this.tabsPreference = (CheckBoxPreference)this.ensureFindPreference("tabs");
        this.passwordsPreference = (CheckBoxPreference)this.ensureFindPreference("passwords");
        if (!FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            this.removeDebugButtons();
        } else {
            this.connectDebugButtons();
            ALWAYS_SHOW_AUTH_SERVER = true;
            ALWAYS_SHOW_SYNC_SERVER = true;
        }
        this.needsPasswordPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.needsVerificationPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.needsAccountEnabledPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.bookmarksPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.historyPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.tabsPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.passwordsPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.deviceNamePreference = (EditTextPreference)this.ensureFindPreference("device_name");
        this.deviceNamePreference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        this.syncServerPreference = this.ensureFindPreference("sync_server");
        this.morePreference = this.ensureFindPreference("more");
        this.morePreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.syncNowPreference = this.ensureFindPreference("sync_now");
        this.syncNowPreference.setEnabled(true);
        this.syncNowPreference.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        if (HardwareUtils.hasMenuButton()) {
            this.syncCategory.removePreference(this.morePreference);
        }
    }

    public void onResume() {
        super.onResume();
    }

    public boolean onPreferenceClick(Preference preference) {
        if (preference == this.needsPasswordPreference) {
            Intent intent = new Intent((Context)this.getActivity(), FxAccountUpdateCredentialsActivity.class);
            Bundle bundle = this.getExtrasForAccount();
            if (bundle != null) {
                intent.putExtras(bundle);
            }
            intent.setFlags(65536);
            this.startActivity(intent);
            return true;
        }
        if (preference == this.needsVerificationPreference) {
            FxAccountCodeResender.resendCode(this.getActivity().getApplicationContext(), this.fxAccount);
            Intent intent = new Intent((Context)this.getActivity(), FxAccountConfirmAccountActivity.class);
            intent.setFlags(65536);
            this.startActivity(intent);
            return true;
        }
        if (preference == this.needsAccountEnabledPreference) {
            this.fxAccount.enableSyncing();
            this.refresh();
            return true;
        }
        if (preference == this.bookmarksPreference || preference == this.historyPreference || preference == this.passwordsPreference || preference == this.tabsPreference) {
            this.saveEngineSelections();
            return true;
        }
        if (preference == this.morePreference) {
            this.getActivity().openOptionsMenu();
            return true;
        }
        if (preference == this.syncNowPreference) {
            if (this.fxAccount != null) {
                FirefoxAccounts.requestSync(this.fxAccount.getAndroidAccount(), FirefoxAccounts.FORCE, null, null);
            }
            return true;
        }
        return false;
    }

    protected Bundle getExtrasForAccount() {
        Bundle bundle = new Bundle();
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("auth", this.fxAccount.getAccountServerURI());
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        extendedJSONObject2.put("sync", this.fxAccount.getTokenServerURI());
        extendedJSONObject.put("services", extendedJSONObject2);
        bundle.putString("extras", extendedJSONObject.toJSONString());
        return bundle;
    }

    protected void setCheckboxesEnabled(boolean bl) {
        this.bookmarksPreference.setEnabled(bl);
        this.historyPreference.setEnabled(bl);
        this.tabsPreference.setEnabled(bl);
        this.passwordsPreference.setEnabled(bl);
        this.deviceNamePreference.setEnabled(bl);
        this.syncNowPreference.setEnabled(bl);
    }

    protected void showOnlyOneErrorPreference(Preference preference) {
        Preference[] preferenceArray;
        for (Preference preference2 : preferenceArray = new Preference[]{this.needsPasswordPreference, this.needsUpgradePreference, this.needsVerificationPreference, this.needsMasterSyncAutomaticallyEnabledPreference, this.needsAccountEnabledPreference}) {
            boolean bl;
            boolean bl2 = null != this.findPreference(preference2.getKey());
            boolean bl3 = bl = preference2 == preference;
            if (bl2 == bl) continue;
            if (bl) {
                this.syncCategory.addPreference(preference2);
                continue;
            }
            this.syncCategory.removePreference(preference2);
        }
    }

    protected void showNeedsPassword() {
        this.syncCategory.setTitle(R.string.fxaccount_status_sync);
        this.showOnlyOneErrorPreference(this.needsPasswordPreference);
        this.setCheckboxesEnabled(false);
    }

    protected void showNeedsUpgrade() {
        this.syncCategory.setTitle(R.string.fxaccount_status_sync);
        this.showOnlyOneErrorPreference(this.needsUpgradePreference);
        this.setCheckboxesEnabled(false);
    }

    protected void showNeedsVerification() {
        this.syncCategory.setTitle(R.string.fxaccount_status_sync);
        this.showOnlyOneErrorPreference(this.needsVerificationPreference);
        this.setCheckboxesEnabled(false);
    }

    protected void showNeedsMasterSyncAutomaticallyEnabled() {
        this.syncCategory.setTitle(R.string.fxaccount_status_sync);
        this.showOnlyOneErrorPreference(this.needsMasterSyncAutomaticallyEnabledPreference);
        this.setCheckboxesEnabled(false);
    }

    protected void showNeedsAccountEnabled() {
        this.syncCategory.setTitle(R.string.fxaccount_status_sync);
        this.showOnlyOneErrorPreference(this.needsAccountEnabledPreference);
        this.setCheckboxesEnabled(false);
    }

    protected void showConnected() {
        this.syncCategory.setTitle(R.string.fxaccount_status_sync_enabled);
        this.showOnlyOneErrorPreference(null);
        this.setCheckboxesEnabled(true);
    }

    public void refresh(AndroidFxAccount androidFxAccount) {
        if (androidFxAccount == null) {
            throw new IllegalArgumentException("fxAccount must not be null");
        }
        this.fxAccount = androidFxAccount;
        try {
            this.clientsDataDelegate = new SharedPreferencesClientsDataDelegate(androidFxAccount.getSyncPrefs(), this.getActivity().getApplicationContext());
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got exception fetching Sync prefs associated to Firefox Account; aborting.", exception);
            throw new IllegalStateException(exception);
        }
        this.handler = new Handler();
        this.requestSyncRunnable = new RequestSyncRunnable();
        FxAccountSyncStatusHelper.getInstance().startObserving(this.syncStatusDelegate);
        this.refresh();
    }

    public void onPause() {
        super.onPause();
        FxAccountSyncStatusHelper.getInstance().stopObserving(this.syncStatusDelegate);
    }

    protected void hardRefresh() {
        PreferenceScreen preferenceScreen = (PreferenceScreen)this.ensureFindPreference("status_screen");
        preferenceScreen.removeAll();
        this.addPreferences();
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (this.fxAccount == null) {
            throw new IllegalArgumentException("fxAccount must not be null");
        }
        this.emailPreference.setTitle((CharSequence)this.fxAccount.getEmail());
        this.updateAuthServerPreference();
        this.updateSyncServerPreference();
        try {
            boolean bl = this.fxAccount.isSyncing();
            if (!bl) {
                this.showNeedsAccountEnabled();
                return;
            }
            State state = this.fxAccount.getState();
            switch (state.getNeededAction()) {
                case NeedsUpgrade: {
                    this.showNeedsUpgrade();
                    break;
                }
                case NeedsPassword: {
                    this.showNeedsPassword();
                    break;
                }
                case NeedsVerification: {
                    this.showNeedsVerification();
                    break;
                }
                default: {
                    this.showConnected();
                }
            }
            boolean bl2 = ContentResolver.getMasterSyncAutomatically();
            if (!bl2) {
                this.showNeedsMasterSyncAutomaticallyEnabled();
                return;
            }
        }
        finally {
            this.updateSelectedEngines();
        }
        String string2 = this.clientsDataDelegate.getClientName();
        this.deviceNamePreference.setSummary((CharSequence)string2);
        this.deviceNamePreference.setText(string2);
        this.updateSyncNowPreference();
    }

    private String getLastSyncedString(long l) {
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString((long)l);
        return this.getActivity().getResources().getString(R.string.fxaccount_status_last_synced, new Object[]{charSequence});
    }

    protected void updateSyncNowPreference() {
        boolean bl = this.fxAccount.isCurrentlySyncing();
        this.syncNowPreference.setEnabled(!bl);
        if (bl) {
            this.syncNowPreference.setTitle(R.string.fxaccount_status_syncing);
        } else {
            this.syncNowPreference.setTitle(R.string.fxaccount_status_sync_now);
        }
        String string2 = this.getLastSyncedString(this.fxAccount.getLastSyncedTimestamp());
        this.syncNowPreference.setSummary((CharSequence)string2);
    }

    protected void updateAuthServerPreference() {
        boolean bl;
        String string2 = this.fxAccount.getAccountServerURI();
        boolean bl2 = ALWAYS_SHOW_AUTH_SERVER || !"https://api.accounts.firefox.com/v1".equals(string2);
        boolean bl3 = bl = null != this.findPreference(this.authServerPreference.getKey());
        if (bl != bl2) {
            if (bl2) {
                this.accountCategory.addPreference(this.authServerPreference);
            } else {
                this.accountCategory.removePreference(this.authServerPreference);
            }
        }
        this.authServerPreference.setSummary((CharSequence)string2);
    }

    protected void updateSyncServerPreference() {
        boolean bl;
        String string2 = this.fxAccount.getTokenServerURI();
        boolean bl2 = ALWAYS_SHOW_SYNC_SERVER || !"https://token.services.mozilla.com/1.0/sync/1.5".equals(string2);
        boolean bl3 = bl = null != this.findPreference(this.syncServerPreference.getKey());
        if (bl != bl2) {
            if (bl2) {
                this.syncCategory.addPreference(this.syncServerPreference);
            } else {
                this.syncCategory.removePreference(this.syncServerPreference);
            }
        }
        this.syncServerPreference.setSummary((CharSequence)string2);
    }

    protected void updateSelectedEngines() {
        try {
            SharedPreferences sharedPreferences = this.fxAccount.getSyncPrefs();
            Map<String, Boolean> map = SyncConfiguration.getUserSelectedEngines(sharedPreferences);
            if (map != null) {
                this.bookmarksPreference.setChecked(map.containsKey("bookmarks") && map.get("bookmarks") != false);
                this.historyPreference.setChecked(map.containsKey("history") && map.get("history") != false);
                this.passwordsPreference.setChecked(map.containsKey("passwords") && map.get("passwords") != false);
                this.tabsPreference.setChecked(map.containsKey("tabs") && map.get("tabs") != false);
                return;
            }
            Set<String> set = SyncConfiguration.getEnabledEngineNames(sharedPreferences);
            if (set != null) {
                this.bookmarksPreference.setChecked(set.contains("bookmarks"));
                this.historyPreference.setChecked(set.contains("history"));
                this.passwordsPreference.setChecked(set.contains("passwords"));
                this.tabsPreference.setChecked(set.contains("tabs"));
                return;
            }
            this.bookmarksPreference.setChecked(true);
            this.historyPreference.setChecked(true);
            this.passwordsPreference.setChecked(true);
            this.tabsPreference.setChecked(true);
            this.setCheckboxesEnabled(false);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception getting engines to select; ignoring.", exception);
            return;
        }
    }

    protected void saveEngineSelections() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("bookmarks", this.bookmarksPreference.isChecked());
        hashMap.put("history", this.historyPreference.isChecked());
        hashMap.put("passwords", this.passwordsPreference.isChecked());
        hashMap.put("tabs", this.tabsPreference.isChecked());
        new Thread(new PersistEngineSelectionsRunnable(hashMap)).start();
    }

    protected void requestDelayedSync() {
        Logger.info(LOG_TAG, "Posting a delayed request for a sync sometime soon.");
        this.handler.removeCallbacks(this.requestSyncRunnable);
        this.handler.postDelayed(this.requestSyncRunnable, 5000L);
    }

    protected void removeDebugButtons() {
        PreferenceScreen preferenceScreen = (PreferenceScreen)this.ensureFindPreference("status_screen");
        PreferenceCategory preferenceCategory = (PreferenceCategory)this.ensureFindPreference("debug_category");
        preferenceScreen.removePreference((Preference)preferenceCategory);
    }

    protected void connectDebugButtons() {
        String[] stringArray;
        DebugPreferenceClickListener debugPreferenceClickListener = new DebugPreferenceClickListener();
        Preference preference = this.ensureFindPreference("debug_category");
        preference.setTitle((CharSequence)preference.getKey());
        for (String string2 : stringArray = new String[]{"debug_refresh", "debug_dump", "debug_force_sync", "debug_forget_certificate", "debug_require_password", "debug_require_upgrade"}) {
            Preference preference2 = this.ensureFindPreference(string2);
            preference2.setTitle((CharSequence)string2);
            preference2.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)debugPreferenceClickListener);
        }
    }

    public boolean onPreferenceChange(Preference preference, Object object) {
        if (preference == this.deviceNamePreference) {
            String string2 = (String)object;
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = this.clientsDataDelegate.getDefaultClientName();
            }
            long l = System.currentTimeMillis();
            this.clientsDataDelegate.setClientName(string2, l);
            this.requestDelayedSync();
            this.hardRefresh();
            return true;
        }
        return true;
    }

    protected class DebugPreferenceClickListener
    implements Preference.OnPreferenceClickListener {
        protected DebugPreferenceClickListener() {
        }

        public boolean onPreferenceClick(Preference preference) {
            String string2 = preference.getKey();
            if ("debug_refresh".equals(string2)) {
                Logger.info(LOG_TAG, "Refreshing.");
                FxAccountStatusFragment.this.refresh();
            } else if ("debug_dump".equals(string2)) {
                FxAccountStatusFragment.this.fxAccount.dump();
            } else if ("debug_force_sync".equals(string2)) {
                Logger.info(LOG_TAG, "Force syncing.");
                FxAccountStatusFragment.this.fxAccount.requestSync(FirefoxAccounts.FORCE);
            } else if ("debug_forget_certificate".equals(string2)) {
                State state = FxAccountStatusFragment.this.fxAccount.getState();
                try {
                    Married married = (Married)state;
                    Logger.info(LOG_TAG, "Moving to Cohabiting state: Forgetting certificate.");
                    FxAccountStatusFragment.this.fxAccount.setState(married.makeCohabitingState());
                    FxAccountStatusFragment.this.refresh();
                }
                catch (ClassCastException classCastException) {
                    Logger.info(LOG_TAG, "Not in Married state; can't forget certificate.");
                }
            } else if ("debug_require_password".equals(string2)) {
                Logger.info(LOG_TAG, "Moving to Separated state: Forgetting password.");
                State state = FxAccountStatusFragment.this.fxAccount.getState();
                FxAccountStatusFragment.this.fxAccount.setState(state.makeSeparatedState());
                FxAccountStatusFragment.this.refresh();
            } else if ("debug_require_upgrade".equals(string2)) {
                Logger.info(LOG_TAG, "Moving to Doghouse state: Requiring upgrade.");
                State state = FxAccountStatusFragment.this.fxAccount.getState();
                FxAccountStatusFragment.this.fxAccount.setState(state.makeDoghouseState());
                FxAccountStatusFragment.this.refresh();
            } else {
                return false;
            }
            return true;
        }
    }

    protected class RequestSyncRunnable
    implements Runnable {
        protected RequestSyncRunnable() {
        }

        @Override
        public void run() {
            AndroidFxAccount androidFxAccount = FxAccountStatusFragment.this.fxAccount;
            if (androidFxAccount == null) {
                return;
            }
            Logger.info(LOG_TAG, "Requesting a sync sometime soon.");
            androidFxAccount.requestSync();
        }
    }

    protected class PersistEngineSelectionsRunnable
    implements Runnable {
        private final Map<String, Boolean> engineSelections;

        protected PersistEngineSelectionsRunnable(Map<String, Boolean> map) {
            this.engineSelections = map;
        }

        @Override
        public void run() {
            try {
                AndroidFxAccount androidFxAccount = FxAccountStatusFragment.this.fxAccount;
                if (androidFxAccount == null) {
                    return;
                }
                Logger.info(LOG_TAG, "Persisting engine selections: " + this.engineSelections.toString());
                SyncConfiguration.storeSelectedEnginesToPrefs(androidFxAccount.getSyncPrefs(), this.engineSelections);
                FxAccountStatusFragment.this.requestDelayedSync();
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Got exception persisting selected engines; ignoring.", exception);
                return;
            }
        }
    }

    protected class InnerSyncStatusDelegate
    implements FirefoxAccounts.SyncStatusListener {
        protected final Runnable refreshRunnable = new Runnable(){

            @Override
            public void run() {
                FxAccountStatusFragment.this.refresh();
            }
        };

        protected InnerSyncStatusDelegate() {
        }

        @Override
        public Context getContext() {
            return FxAccountStatusFragment.this.getActivity();
        }

        @Override
        public Account getAccount() {
            return FxAccountStatusFragment.this.fxAccount.getAndroidAccount();
        }

        @Override
        public void onSyncStarted() {
            if (FxAccountStatusFragment.this.fxAccount == null) {
                return;
            }
            Logger.info(LOG_TAG, "Got sync started message; refreshing.");
            FxAccountStatusFragment.this.getActivity().runOnUiThread(this.refreshRunnable);
        }

        @Override
        public void onSyncFinished() {
            if (FxAccountStatusFragment.this.fxAccount == null) {
                return;
            }
            Logger.info(LOG_TAG, "Got sync finished message; refreshing.");
            FxAccountStatusFragment.this.getActivity().runOnUiThread(this.refreshRunnable);
        }
    }
}

