/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.widget.ArrowPopup;
import org.mozilla.gecko.widget.DoorHanger;

public class SiteIdentityPopup
extends ArrowPopup {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private static final String TRACKING_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private SiteIdentity mSiteIdentity;
    private LinearLayout mIdentity;
    private LinearLayout mIdentityKnownContainer;
    private LinearLayout mIdentityUnknownContainer;
    private TextView mHost;
    private TextView mOwnerLabel;
    private TextView mOwner;
    private TextView mVerifier;
    private DoorHanger mMixedContentNotification;
    private DoorHanger mTrackingContentNotification;
    private final DoorHanger.OnButtonClickListener mButtonClickListener = new PopupButtonListener();

    public SiteIdentityPopup(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mIdentityKnownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_known_container);
        this.mIdentityUnknownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_unknown_container);
        this.mHost = (TextView)this.mIdentityKnownContainer.findViewById(R.id.host);
        this.mOwnerLabel = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner_label);
        this.mOwner = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner);
        this.mVerifier = (TextView)this.mIdentityKnownContainer.findViewById(R.id.verifier);
    }

    private void updateIdentity(SiteIdentity siteIdentity) {
        if (!this.mInflated) {
            this.init();
        }
        boolean bl = siteIdentity.getSecurityMode() != SiteIdentity.SecurityMode.UNKNOWN;
        this.toggleIdentityKnownContainerVisibility(bl);
        if (bl) {
            this.updateIdentityInformation(siteIdentity);
        }
    }

    private void toggleIdentityKnownContainerVisibility(boolean bl) {
        if (bl) {
            this.mIdentityKnownContainer.setVisibility(0);
            this.mIdentityUnknownContainer.setVisibility(8);
        } else {
            this.mIdentityKnownContainer.setVisibility(8);
            this.mIdentityUnknownContainer.setVisibility(0);
        }
    }

    private void updateIdentityInformation(SiteIdentity siteIdentity) {
        String string2;
        this.mHost.setText((CharSequence)siteIdentity.getHost());
        String string3 = siteIdentity.getOwner();
        if (string3 == null) {
            this.mOwnerLabel.setVisibility(8);
            this.mOwner.setVisibility(8);
        } else {
            this.mOwnerLabel.setVisibility(0);
            this.mOwner.setVisibility(0);
            string2 = siteIdentity.getSupplemental();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string3 = string3 + "\n" + string2;
            }
            this.mOwner.setText((CharSequence)string3);
        }
        string2 = siteIdentity.getVerifier();
        String string4 = siteIdentity.getEncrypted();
        this.mVerifier.setText((CharSequence)(string2 + "\n" + string4));
    }

    private void addMixedContentNotification(boolean bl) {
        String string2;
        int n;
        this.removeMixedContentNotification();
        this.mMixedContentNotification = new DoorHanger(this.mContext, DoorHanger.Theme.DARK);
        if (bl) {
            n = R.drawable.shield_enabled_doorhanger;
            string2 = this.mContext.getString(R.string.blocked_mixed_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_mixed_content_message_bottom);
        } else {
            n = R.drawable.shield_disabled_doorhanger;
            string2 = this.mContext.getString(R.string.loaded_mixed_content_message);
        }
        this.mMixedContentNotification.setIcon(n);
        this.mMixedContentNotification.setMessage(string2);
        this.mMixedContentNotification.addLink(this.mContext.getString(R.string.learn_more), "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android", "\n\n");
        this.addNotificationButtons(this.mMixedContentNotification, bl);
        this.mContent.addView((View)this.mMixedContentNotification);
    }

    private void removeMixedContentNotification() {
        if (this.mMixedContentNotification != null) {
            this.mContent.removeView((View)this.mMixedContentNotification);
            this.mMixedContentNotification = null;
        }
    }

    private void addTrackingContentNotification(boolean bl) {
        String string2;
        int n;
        this.removeTrackingContentNotification();
        this.mTrackingContentNotification = new DoorHanger(this.mContext, DoorHanger.Theme.DARK);
        if (bl) {
            n = R.drawable.shield_enabled_doorhanger;
            string2 = this.mContext.getString(R.string.blocked_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.blocked_tracking_content_message_bottom);
        } else {
            n = R.drawable.shield_disabled_doorhanger;
            string2 = this.mContext.getString(R.string.loaded_tracking_content_message_top) + "\n\n" + this.mContext.getString(R.string.loaded_tracking_content_message_bottom);
        }
        this.mTrackingContentNotification.setIcon(n);
        this.mTrackingContentNotification.setMessage(string2);
        this.mTrackingContentNotification.addLink(this.mContext.getString(R.string.learn_more), "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android", "\n\n");
        this.addNotificationButtons(this.mTrackingContentNotification, bl);
        this.mContent.addView((View)this.mTrackingContentNotification);
    }

    private void removeTrackingContentNotification() {
        if (this.mTrackingContentNotification != null) {
            this.mContent.removeView((View)this.mTrackingContentNotification);
            this.mTrackingContentNotification = null;
        }
    }

    private void addNotificationButtons(DoorHanger doorHanger, boolean bl) {
        if (bl) {
            doorHanger.addButton(this.mContext.getString(R.string.disable_protection), "disable", this.mButtonClickListener);
            doorHanger.addButton(this.mContext.getString(R.string.keep_blocking), "keepBlocking", this.mButtonClickListener);
        } else {
            doorHanger.addButton(this.mContext.getString(R.string.enable_protection), "enable", this.mButtonClickListener);
        }
    }

    void setSiteIdentity(SiteIdentity siteIdentity) {
        this.mSiteIdentity = siteIdentity;
    }

    @Override
    public void show() {
        SiteIdentity.TrackingMode trackingMode;
        if (this.mSiteIdentity == null) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup for undefined state");
            return;
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && AboutPages.isAboutPage(tab.getURL())) {
            Log.d((String)LOGTAG, (String)"We don't show site identity popups for about: pages");
            return;
        }
        this.updateIdentity(this.mSiteIdentity);
        SiteIdentity.MixedMode mixedMode = this.mSiteIdentity.getMixedMode();
        if (mixedMode != SiteIdentity.MixedMode.UNKNOWN) {
            this.addMixedContentNotification(mixedMode == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED);
        }
        if ((trackingMode = this.mSiteIdentity.getTrackingMode()) != SiteIdentity.TrackingMode.UNKNOWN) {
            this.addTrackingContentNotification(trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED);
        }
        this.showDividers();
        super.show();
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            View view = this.mContent.getChildAt(i);
            if (!(view instanceof DoorHanger)) continue;
            DoorHanger doorHanger2 = (DoorHanger)view;
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    public void dismiss() {
        super.dismiss();
        this.removeMixedContentNotification();
        this.removeTrackingContentNotification();
    }

    private class PopupButtonListener
    implements DoorHanger.OnButtonClickListener {
        private PopupButtonListener() {
        }

        @Override
        public void onButtonClick(DoorHanger doorHanger, String string2) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("allowContent", string2.equals("disable"));
                jSONObject.put("contentType", (Object)(doorHanger == SiteIdentityPopup.this.mMixedContentNotification ? "mixed" : "tracking"));
                GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", jSONObject.toString());
                GeckoAppShell.sendEventToGecko(geckoEvent);
            }
            catch (JSONException jSONException) {
                Log.e((String)SiteIdentityPopup.LOGTAG, (String)"Exception creating message to enable/disable content blocking", (Throwable)jSONException);
            }
            SiteIdentityPopup.this.dismiss();
        }
    }
}

