/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import org.mozilla.gecko.NewTabletUI;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.ThreadUtils;

class ToolbarPrefs {
    private static final String PREF_AUTOCOMPLETE_ENABLED = "browser.urlbar.autocomplete.enabled";
    private static final String PREF_TITLEBAR_MODE = "browser.chrome.titlebarMode";
    private static final String PREF_TRIM_URLS = "browser.urlbar.trimURLs";
    private static final String[] PREFS = new String[]{"browser.urlbar.autocomplete.enabled", "browser.chrome.titlebarMode", "browser.urlbar.trimURLs"};
    private final TitlePrefsHandler HANDLER = new TitlePrefsHandler();
    private volatile boolean enableAutocomplete = false;
    private volatile boolean showUrl;
    private volatile boolean trimUrls = true;
    private Integer prefObserverId;

    ToolbarPrefs() {
    }

    boolean shouldAutocomplete() {
        return this.enableAutocomplete;
    }

    boolean shouldShowUrl(Context context) {
        return this.showUrl || NewTabletUI.isEnabled(context);
    }

    boolean shouldTrimUrls() {
        return this.trimUrls;
    }

    void open() {
        if (this.prefObserverId == null) {
            this.prefObserverId = PrefsHelper.getPrefs(PREFS, (PrefsHelper.PrefHandler)this.HANDLER);
        }
    }

    void close() {
        if (this.prefObserverId != null) {
            PrefsHelper.removeObserver(this.prefObserverId);
            this.prefObserverId = null;
        }
    }

    private void triggerTitleChangeListener() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (tab != null) {
                    tabs.notifyListeners(tab, Tabs.TabEvents.TITLE);
                }
            }
        });
    }

    private class TitlePrefsHandler
    extends PrefsHelper.PrefHandlerBase {
        private TitlePrefsHandler() {
        }

        @Override
        public void prefValue(String string2, String string3) {
            if (ToolbarPrefs.PREF_TITLEBAR_MODE.equals(string2)) {
                boolean bl;
                int n = Integer.parseInt(string3);
                boolean bl2 = bl = n == 1;
                if (bl != ToolbarPrefs.this.showUrl) {
                    ToolbarPrefs.this.showUrl = bl;
                    ToolbarPrefs.this.triggerTitleChangeListener();
                }
            }
        }

        @Override
        public void prefValue(String string2, boolean bl) {
            if (ToolbarPrefs.PREF_AUTOCOMPLETE_ENABLED.equals(string2)) {
                ToolbarPrefs.this.enableAutocomplete = bl;
            } else if (ToolbarPrefs.PREF_TRIM_URLS.equals(string2) && bl != ToolbarPrefs.this.trimUrls) {
                ToolbarPrefs.this.trimUrls = bl;
                ToolbarPrefs.this.triggerTitleChangeListener();
            }
        }

        @Override
        public boolean isObserver() {
            return true;
        }
    }
}

