/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.squareup.picasso.Action;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoDrawable;
import com.squareup.picasso.Request;

class ImageViewAction
extends Action<ImageView> {
    Callback callback;

    ImageViewAction(Picasso picasso, ImageView imageView, Request request, boolean bl, boolean bl2, int n, Drawable drawable, String string, Callback callback) {
        super(picasso, imageView, request, bl, bl2, n, drawable, string);
        this.callback = callback;
    }

    @Override
    public void complete(Bitmap bitmap, Picasso.LoadedFrom loadedFrom) {
        if (bitmap == null) {
            throw new AssertionError((Object)String.format("Attempted to complete action with no result!\n%s", this));
        }
        ImageView imageView = (ImageView)this.target.get();
        if (imageView == null) {
            return;
        }
        Context context = this.picasso.context;
        boolean bl = this.picasso.debugging;
        PicassoDrawable.setBitmap(imageView, context, bitmap, loadedFrom, this.noFade, bl);
        if (this.callback != null) {
            this.callback.onSuccess();
        }
    }

    @Override
    public void error() {
        ImageView imageView = (ImageView)this.target.get();
        if (imageView == null) {
            return;
        }
        if (this.errorResId != 0) {
            imageView.setImageResource(this.errorResId);
        } else if (this.errorDrawable != null) {
            imageView.setImageDrawable(this.errorDrawable);
        }
        if (this.callback != null) {
            this.callback.onError();
        }
    }

    @Override
    void cancel() {
        super.cancel();
        if (this.callback != null) {
            this.callback = null;
        }
    }
}

