/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.sync.Utils;

public class QuickPasswordStretcher
implements PasswordStretcher {
    protected final String password;
    protected final Map<String, String> cache = new HashMap<String, String>();

    public QuickPasswordStretcher(String string2) {
        this.password = string2;
    }

    @Override
    public synchronized byte[] getQuickStretchedPW(byte[] byArray) throws UnsupportedEncodingException, GeneralSecurityException {
        if (byArray == null) {
            throw new IllegalArgumentException("emailUTF8 must not be null");
        }
        String string2 = Utils.byte2Hex(byArray);
        if (!this.cache.containsKey(string2)) {
            byte[] byArray2 = FxAccountUtils.generateQuickStretchedPW(byArray, this.password.getBytes("UTF-8"));
            this.cache.put(string2, Utils.byte2Hex(byArray2));
            return byArray2;
        }
        return Utils.hex2Byte(this.cache.get(string2));
    }
}

