/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import java.util.Collection;
import java.util.Iterator;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.HashSetStoreTracker;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.StoreTracker;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;

public abstract class StoreTrackingRepositorySession
extends RepositorySession {
    private static final String LOG_TAG = "StoreTrackSession";
    protected StoreTracker storeTracker;

    protected static StoreTracker createStoreTracker() {
        return new HashSetStoreTracker();
    }

    public StoreTrackingRepositorySession(Repository repository) {
        super(repository);
    }

    @Override
    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        RepositorySessionBeginDelegate repositorySessionBeginDelegate2 = repositorySessionBeginDelegate.deferredBeginDelegate(this.delegateQueue);
        try {
            super.sharedBegin();
        }
        catch (InvalidSessionTransitionException invalidSessionTransitionException) {
            repositorySessionBeginDelegate2.onBeginFailed(invalidSessionTransitionException);
            return;
        }
        this.storeTracker = StoreTrackingRepositorySession.createStoreTracker();
        repositorySessionBeginDelegate2.onBeginSucceeded(this);
    }

    @Override
    protected synchronized void trackGUID(String string2) {
        if (this.storeTracker == null) {
            throw new IllegalStateException("Store tracker not yet initialized!");
        }
        this.storeTracker.trackRecordForExclusion(string2);
    }

    @Override
    protected synchronized void untrackGUID(String string2) {
        if (this.storeTracker == null) {
            throw new IllegalStateException("Store tracker not yet initialized!");
        }
        this.storeTracker.untrackStoredForExclusion(string2);
    }

    @Override
    protected synchronized void untrackGUIDs(Collection<String> collection) {
        if (this.storeTracker == null) {
            throw new IllegalStateException("Store tracker not yet initialized!");
        }
        if (collection == null) {
            return;
        }
        for (String string2 : collection) {
            this.storeTracker.untrackStoredForExclusion(string2);
        }
    }

    protected void trackRecord(Record record) {
        Logger.debug(LOG_TAG, "Tracking record " + record.guid + " (" + record.lastModified + ") to avoid re-upload.");
        this.trackGUID(record.guid);
    }

    protected void untrackRecord(Record record) {
        Logger.debug(LOG_TAG, "Un-tracking record " + record.guid + ".");
        this.untrackGUID(record.guid);
    }

    @Override
    public Iterator<String> getTrackedRecordIDs() {
        if (this.storeTracker == null) {
            throw new IllegalStateException("Store tracker not yet initialized!");
        }
        return this.storeTracker.recordsTrackedForExclusion();
    }

    @Override
    public void abort(RepositorySessionFinishDelegate repositorySessionFinishDelegate) {
        this.storeTracker = null;
        super.abort(repositorySessionFinishDelegate);
    }

    @Override
    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        super.finish(repositorySessionFinishDelegate);
        this.storeTracker = null;
    }
}

