/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.RequestCreator;
import java.lang.ref.WeakReference;

class DeferredRequestCreator
implements ViewTreeObserver.OnPreDrawListener {
    final RequestCreator creator;
    final WeakReference<ImageView> target;
    Callback callback;

    DeferredRequestCreator(RequestCreator requestCreator, ImageView imageView, Callback callback) {
        this.creator = requestCreator;
        this.target = new WeakReference<ImageView>(imageView);
        this.callback = callback;
        imageView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public boolean onPreDraw() {
        ImageView imageView = (ImageView)this.target.get();
        if (imageView == null) {
            return true;
        }
        ViewTreeObserver viewTreeObserver = imageView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return true;
        }
        int n = imageView.getMeasuredWidth();
        int n2 = imageView.getMeasuredHeight();
        if (n <= 0 || n2 <= 0) {
            return true;
        }
        viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.creator.unfit().resize(n, n2).into(imageView, this.callback);
        return true;
    }

    void cancel() {
        this.callback = null;
        ImageView imageView = (ImageView)this.target.get();
        if (imageView == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = imageView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }
}

