/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.fxa.login.BaseRequestDelegate;
import org.mozilla.gecko.fxa.login.Cohabiting;
import org.mozilla.gecko.fxa.login.Doghouse;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Separated;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class Engaged
extends State {
    private static final String LOG_TAG = Engaged.class.getSimpleName();
    protected final byte[] sessionToken;
    protected final byte[] keyFetchToken;
    protected final byte[] unwrapkB;

    public Engaged(String string2, String string3, boolean bl, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(State.StateLabel.Engaged, string2, string3, bl);
        Utils.throwIfNull(byArray, byArray2, byArray3);
        this.unwrapkB = byArray;
        this.sessionToken = byArray2;
        this.keyFetchToken = byArray3;
    }

    @Override
    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = super.toJSONObject();
        extendedJSONObject.put("unwrapkB", Utils.byte2Hex(this.unwrapkB));
        extendedJSONObject.put("sessionToken", Utils.byte2Hex(this.sessionToken));
        extendedJSONObject.put("keyFetchToken", Utils.byte2Hex(this.keyFetchToken));
        return extendedJSONObject;
    }

    @Override
    public void execute(FxAccountLoginStateMachine.ExecuteDelegate executeDelegate) {
        BrowserIDKeyPair browserIDKeyPair;
        try {
            browserIDKeyPair = executeDelegate.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            executeDelegate.handleTransition(new FxAccountLoginTransition.LocalError(noSuchAlgorithmException), new Doghouse(this.email, this.uid, this.verified));
            return;
        }
        final BrowserIDKeyPair browserIDKeyPair2 = browserIDKeyPair;
        executeDelegate.getClient().keys(this.keyFetchToken, (FxAccountClient10.RequestDelegate<FxAccountClient10.TwoKeys>)new BaseRequestDelegate<FxAccountClient10.TwoKeys>((State)this, executeDelegate){

            @Override
            public void handleSuccess(FxAccountClient10.TwoKeys twoKeys) {
                byte[] byArray;
                try {
                    byArray = FxAccountUtils.unwrapkB(Engaged.this.unwrapkB, twoKeys.wrapkB);
                    if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
                        FxAccountUtils.pii(LOG_TAG, "Fetched kA: " + Utils.byte2Hex(twoKeys.kA));
                        FxAccountUtils.pii(LOG_TAG, "And wrapkB: " + Utils.byte2Hex(twoKeys.wrapkB));
                        FxAccountUtils.pii(LOG_TAG, "Giving kB : " + Utils.byte2Hex(byArray));
                    }
                }
                catch (Exception exception) {
                    this.delegate.handleTransition(new FxAccountLoginTransition.RemoteError(exception), new Separated(Engaged.this.email, Engaged.this.uid, Engaged.this.verified));
                    return;
                }
                FxAccountLoginTransition.LogMessage logMessage = Engaged.this.verified ? new FxAccountLoginTransition.LogMessage("keys succeeded") : new FxAccountLoginTransition.AccountVerified();
                this.delegate.handleTransition(logMessage, new Cohabiting(Engaged.this.email, Engaged.this.uid, Engaged.this.sessionToken, twoKeys.kA, byArray, browserIDKeyPair2));
            }
        });
    }

    @Override
    public State.Action getNeededAction() {
        if (!this.verified) {
            return State.Action.NeedsVerification;
        }
        return State.Action.None;
    }

    public byte[] getSessionToken() {
        return this.sessionToken;
    }
}

