/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.FloatMath;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.FloatSize;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.util.FloatUtils;

final class DisplayPortCalculator {
    private static final String LOGTAG = "GeckoDisplayPort";
    private static final PointF ZERO_VELOCITY = new PointF(0.0f, 0.0f);
    private static final int TILE_SIZE = 256;
    private static final String PREF_DISPLAYPORT_STRATEGY = "gfx.displayport.strategy";
    private static final String PREF_DISPLAYPORT_FM_MULTIPLIER = "gfx.displayport.strategy_fm.multiplier";
    private static final String PREF_DISPLAYPORT_FM_DANGER_X = "gfx.displayport.strategy_fm.danger_x";
    private static final String PREF_DISPLAYPORT_FM_DANGER_Y = "gfx.displayport.strategy_fm.danger_y";
    private static final String PREF_DISPLAYPORT_VB_MULTIPLIER = "gfx.displayport.strategy_vb.multiplier";
    private static final String PREF_DISPLAYPORT_VB_VELOCITY_THRESHOLD = "gfx.displayport.strategy_vb.threshold";
    private static final String PREF_DISPLAYPORT_VB_REVERSE_BUFFER = "gfx.displayport.strategy_vb.reverse_buffer";
    private static final String PREF_DISPLAYPORT_VB_DANGER_X_BASE = "gfx.displayport.strategy_vb.danger_x_base";
    private static final String PREF_DISPLAYPORT_VB_DANGER_Y_BASE = "gfx.displayport.strategy_vb.danger_y_base";
    private static final String PREF_DISPLAYPORT_VB_DANGER_X_INCR = "gfx.displayport.strategy_vb.danger_x_incr";
    private static final String PREF_DISPLAYPORT_VB_DANGER_Y_INCR = "gfx.displayport.strategy_vb.danger_y_incr";
    private static final String PREF_DISPLAYPORT_PB_VELOCITY_THRESHOLD = "gfx.displayport.strategy_pb.threshold";
    private static DisplayPortStrategy sStrategy = new VelocityBiasStrategy(null);

    DisplayPortCalculator() {
    }

    static DisplayPortMetrics calculate(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
        return sStrategy.calculate(immutableViewportMetrics, pointF == null ? ZERO_VELOCITY : pointF);
    }

    static boolean aboutToCheckerboard(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF, DisplayPortMetrics displayPortMetrics) {
        if (displayPortMetrics == null) {
            return true;
        }
        return sStrategy.aboutToCheckerboard(immutableViewportMetrics, pointF == null ? ZERO_VELOCITY : pointF, displayPortMetrics);
    }

    static boolean drawTimeUpdate(long l, int n) {
        return sStrategy.drawTimeUpdate(l, n);
    }

    static void resetPageState() {
        sStrategy.resetPageState();
    }

    static void initPrefs() {
        String[] stringArray = new String[]{PREF_DISPLAYPORT_STRATEGY, PREF_DISPLAYPORT_FM_MULTIPLIER, PREF_DISPLAYPORT_FM_DANGER_X, PREF_DISPLAYPORT_FM_DANGER_Y, PREF_DISPLAYPORT_VB_MULTIPLIER, PREF_DISPLAYPORT_VB_VELOCITY_THRESHOLD, PREF_DISPLAYPORT_VB_REVERSE_BUFFER, PREF_DISPLAYPORT_VB_DANGER_X_BASE, PREF_DISPLAYPORT_VB_DANGER_Y_BASE, PREF_DISPLAYPORT_VB_DANGER_X_INCR, PREF_DISPLAYPORT_VB_DANGER_Y_INCR, PREF_DISPLAYPORT_PB_VELOCITY_THRESHOLD};
        PrefsHelper.getPrefs(stringArray, (PrefsHelper.PrefHandler)new PrefsHelper.PrefHandlerBase(){
            private final Map<String, Integer> mValues = new HashMap<String, Integer>();

            @Override
            public void prefValue(String string2, int n) {
                this.mValues.put(string2, n);
            }

            @Override
            public void finish() {
                DisplayPortCalculator.setStrategy(this.mValues);
            }
        });
    }

    static boolean setStrategy(Map<String, Integer> map) {
        Integer n = map.get(PREF_DISPLAYPORT_STRATEGY);
        if (n == null) {
            return false;
        }
        switch (n) {
            case 0: {
                sStrategy = new FixedMarginStrategy(map);
                break;
            }
            case 1: {
                sStrategy = new VelocityBiasStrategy(map);
                break;
            }
            case 2: {
                sStrategy = new DynamicResolutionStrategy(map);
                break;
            }
            case 3: {
                sStrategy = new NoMarginStrategy(map);
                break;
            }
            case 4: {
                sStrategy = new PredictionBiasStrategy(map);
                break;
            }
            default: {
                Log.e((String)LOGTAG, (String)"Invalid strategy index specified");
                return false;
            }
        }
        Log.i((String)LOGTAG, (String)("Set strategy " + sStrategy.toString()));
        return true;
    }

    private static float getFloatPref(Map<String, Integer> map, String string2, int n) {
        Integer n2 = map == null ? null : map.get(string2);
        return (float)(n2 == null || n2 < 0 ? n : n2) / 1000.0f;
    }

    private static FloatSize reshapeForPage(float f, float f2, ImmutableViewportMetrics immutableViewportMetrics) {
        float f3 = Math.min(f, immutableViewportMetrics.getPageWidth());
        float f4 = (float)Math.floor((f - f3) * f2 / f3);
        float f5 = Math.min(f2 + f4, immutableViewportMetrics.getPageHeight());
        if (f5 < f2 && f3 == f) {
            float f6 = (float)Math.floor((f2 - f5) * f / f5);
            f3 = Math.min(f + f6, immutableViewportMetrics.getPageWidth());
        }
        return new FloatSize(f3, f5);
    }

    private static RectF expandByDangerZone(RectF rectF, float f, float f2, ImmutableViewportMetrics immutableViewportMetrics) {
        float f3 = immutableViewportMetrics.getWidth() * f;
        float f4 = immutableViewportMetrics.getHeight() * f2;
        rectF = RectUtils.expand(rectF, f3, f4);
        return DisplayPortCalculator.clampToPageBounds(rectF, immutableViewportMetrics);
    }

    private static DisplayPortMetrics getTileAlignedDisplayPortMetrics(RectF rectF, float f, ImmutableViewportMetrics immutableViewportMetrics) {
        float f2 = immutableViewportMetrics.viewportRectLeft - rectF.left;
        float f3 = immutableViewportMetrics.viewportRectTop - rectF.top;
        float f4 = immutableViewportMetrics.viewportRectRight + rectF.right;
        float f5 = immutableViewportMetrics.viewportRectBottom + rectF.bottom;
        f2 = Math.max(immutableViewportMetrics.pageRectLeft, 256.0f * FloatMath.floor((float)(f2 / 256.0f)));
        f3 = Math.max(immutableViewportMetrics.pageRectTop, 256.0f * FloatMath.floor((float)(f3 / 256.0f)));
        f4 = Math.min(immutableViewportMetrics.pageRectRight, 256.0f * FloatMath.ceil((float)(f4 / 256.0f)));
        f5 = Math.min(immutableViewportMetrics.pageRectBottom, 256.0f * FloatMath.ceil((float)(f5 / 256.0f)));
        return new DisplayPortMetrics(f2, f3, f4, f5, f);
    }

    private static RectF shiftMarginsForPageBounds(RectF rectF, ImmutableViewportMetrics immutableViewportMetrics) {
        float f = immutableViewportMetrics.pageRectLeft - (immutableViewportMetrics.viewportRectLeft - rectF.left);
        float f2 = immutableViewportMetrics.viewportRectRight + rectF.right - immutableViewportMetrics.pageRectRight;
        float f3 = immutableViewportMetrics.pageRectTop - (immutableViewportMetrics.viewportRectTop - rectF.top);
        float f4 = immutableViewportMetrics.viewportRectBottom + rectF.bottom - immutableViewportMetrics.pageRectBottom;
        if (f > 0.0f) {
            rectF.left -= f;
            rectF.right += f;
        } else if (f2 > 0.0f) {
            rectF.right -= f2;
            rectF.left += f2;
        }
        if (f3 > 0.0f) {
            rectF.top -= f3;
            rectF.bottom += f3;
        } else if (f4 > 0.0f) {
            rectF.bottom -= f4;
            rectF.top += f4;
        }
        return rectF;
    }

    private static RectF clampToPageBounds(RectF rectF, ImmutableViewportMetrics immutableViewportMetrics) {
        if (rectF.top < immutableViewportMetrics.pageRectTop) {
            rectF.top = immutableViewportMetrics.pageRectTop;
        }
        if (rectF.left < immutableViewportMetrics.pageRectLeft) {
            rectF.left = immutableViewportMetrics.pageRectLeft;
        }
        if (rectF.right > immutableViewportMetrics.pageRectRight) {
            rectF.right = immutableViewportMetrics.pageRectRight;
        }
        if (rectF.bottom > immutableViewportMetrics.pageRectBottom) {
            rectF.bottom = immutableViewportMetrics.pageRectBottom;
        }
        return rectF;
    }

    private static class PredictionBiasStrategy
    extends DisplayPortStrategy {
        private static float VELOCITY_THRESHOLD;
        private int mPixelArea;
        private int mMinFramesToDraw;
        private int mMaxFramesToDraw;

        PredictionBiasStrategy(Map<String, Integer> map) {
            VELOCITY_THRESHOLD = (float)GeckoAppShell.getDpi() * DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_PB_VELOCITY_THRESHOLD, 16);
            this.resetPageState();
        }

        @Override
        public DisplayPortMetrics calculate(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
            float f = immutableViewportMetrics.getWidth();
            float f2 = immutableViewportMetrics.getHeight();
            this.mPixelArea = (int)(f * f2);
            if (pointF.length() < VELOCITY_THRESHOLD) {
                RectF rectF = new RectF(f, f2, f, f2);
                return DisplayPortCalculator.getTileAlignedDisplayPortMetrics(rectF, immutableViewportMetrics.zoomFactor, immutableViewportMetrics);
            }
            float f3 = pointF.x * (float)this.mMinFramesToDraw;
            float f4 = pointF.y * (float)this.mMinFramesToDraw;
            float f5 = pointF.x * (float)this.mMaxFramesToDraw;
            float f6 = pointF.y * (float)this.mMaxFramesToDraw;
            float f7 = (f + Math.abs(f5 - f3)) * (f2 + Math.abs(f6 - f4));
            f5 = f5 * f7 / (float)this.mPixelArea;
            f6 = f6 * f7 / (float)this.mPixelArea;
            RectF rectF = new RectF(-Math.min(f3, f5), -Math.min(f4, f6), Math.max(f3, f5), Math.max(f4, f6));
            return DisplayPortCalculator.getTileAlignedDisplayPortMetrics(rectF, immutableViewportMetrics.zoomFactor, immutableViewportMetrics);
        }

        @Override
        public boolean aboutToCheckerboard(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF, DisplayPortMetrics displayPortMetrics) {
            float f = pointF.x * (float)this.mMinFramesToDraw;
            float f2 = pointF.y * (float)this.mMinFramesToDraw;
            float f3 = pointF.x * (float)this.mMaxFramesToDraw;
            float f4 = pointF.y * (float)this.mMaxFramesToDraw;
            float f5 = (immutableViewportMetrics.getWidth() + Math.abs(f3 - f)) * (immutableViewportMetrics.getHeight() + Math.abs(f4 - f2));
            f3 = f3 * f5 / (float)this.mPixelArea;
            f4 = f4 * f5 / (float)this.mPixelArea;
            RectF rectF = immutableViewportMetrics.getViewport();
            rectF.left += f3;
            rectF.top += f4;
            rectF.right += f3;
            rectF.bottom += f4;
            return !displayPortMetrics.contains(rectF = DisplayPortCalculator.clampToPageBounds(rectF, immutableViewportMetrics));
        }

        @Override
        public boolean drawTimeUpdate(long l, int n) {
            float f = (float)this.mPixelArea * (float)l / (float)n;
            int n2 = (int)FloatMath.ceil((float)(f * 60.0f / 1000.0f));
            if (n2 <= this.mMinFramesToDraw) {
                --this.mMinFramesToDraw;
            } else if (n2 > this.mMaxFramesToDraw) {
                ++this.mMaxFramesToDraw;
            } else {
                return true;
            }
            Log.d((String)DisplayPortCalculator.LOGTAG, (String)("Widened draw range to [" + this.mMinFramesToDraw + ", " + this.mMaxFramesToDraw + "]"));
            return true;
        }

        @Override
        public void resetPageState() {
            this.mMinFramesToDraw = 0;
            this.mMaxFramesToDraw = 2;
        }

        public String toString() {
            return "PredictionBiasStrategy threshold=" + VELOCITY_THRESHOLD;
        }
    }

    private static class DynamicResolutionStrategy
    extends DisplayPortStrategy {
        private static final float SIZE_MULTIPLIER = 1.5f;
        private static final float VELOCITY_EXPANSION_THRESHOLD = (float)GeckoAppShell.getDpi() / 16.0f;
        private static final float VELOCITY_MULTIPLIER = 60.0f;
        private static final float VELOCITY_FAST_THRESHOLD = VELOCITY_EXPANSION_THRESHOLD * 2.0f;
        private static final float FAST_SPLIT_FACTOR = 0.95f;
        private static final float SLOW_SPLIT_FACTOR = 0.8f;
        private static final float PREDICTION_VELOCITY_MULTIPLIER = 30.0f;
        private static final float DANGER_ZONE_MULTIPLIER = 0.2f;

        DynamicResolutionStrategy(Map<String, Integer> map) {
        }

        @Override
        public DisplayPortMetrics calculate(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
            float f = immutableViewportMetrics.getWidth() * 1.5f;
            float f2 = immutableViewportMetrics.getHeight() * 1.5f;
            FloatSize floatSize = DisplayPortCalculator.reshapeForPage(f, f2, immutableViewportMetrics);
            if (pointF.length() > VELOCITY_EXPANSION_THRESHOLD) {
                float f3 = Math.max(Math.abs(pointF.x) / f, Math.abs(pointF.y) / f2);
                f += f * (f3 *= 60.0f);
                f2 += f2 * f3;
            }
            FloatSize floatSize2 = DisplayPortCalculator.reshapeForPage(f, f2, immutableViewportMetrics);
            float f4 = floatSize2.width - immutableViewportMetrics.getWidth();
            float f5 = floatSize2.height - immutableViewportMetrics.getHeight();
            RectF rectF = new RectF();
            rectF.left = this.splitBufferByVelocity(f4, pointF.x);
            rectF.right = f4 - rectF.left;
            rectF.top = this.splitBufferByVelocity(f5, pointF.y);
            rectF.bottom = f5 - rectF.top;
            rectF = DisplayPortCalculator.shiftMarginsForPageBounds(rectF, immutableViewportMetrics);
            float f6 = Math.min(floatSize.width / floatSize2.width, floatSize.height / floatSize2.height);
            float f7 = immutableViewportMetrics.zoomFactor * Math.min(1.0f, f6);
            DisplayPortMetrics displayPortMetrics = new DisplayPortMetrics(immutableViewportMetrics.viewportRectLeft - rectF.left, immutableViewportMetrics.viewportRectTop - rectF.top, immutableViewportMetrics.viewportRectRight + rectF.right, immutableViewportMetrics.viewportRectBottom + rectF.bottom, f7);
            return displayPortMetrics;
        }

        private float splitBufferByVelocity(float f, float f2) {
            if (FloatUtils.fuzzyEquals((float)f2, (float)0.0f)) {
                return f / 2.0f;
            }
            if (f2 < -VELOCITY_FAST_THRESHOLD) {
                return f * 0.95f;
            }
            if (f2 > VELOCITY_FAST_THRESHOLD) {
                return f * 0.050000012f;
            }
            if (f2 < 0.0f) {
                return f * 0.8f;
            }
            return f * 0.19999999f;
        }

        @Override
        public boolean aboutToCheckerboard(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF, DisplayPortMetrics displayPortMetrics) {
            RectF rectF = immutableViewportMetrics.getViewport();
            if (pointF.length() > 0.0f) {
                if (pointF.x < 0.0f) {
                    rectF.left += pointF.x * 30.0f;
                } else if (pointF.x > 0.0f) {
                    rectF.right += pointF.x * 30.0f;
                }
                if (pointF.y < 0.0f) {
                    rectF.top += pointF.y * 30.0f;
                } else if (pointF.y > 0.0f) {
                    rectF.bottom += pointF.y * 30.0f;
                }
            }
            return !displayPortMetrics.contains(rectF = DisplayPortCalculator.expandByDangerZone(rectF, 0.2f, 0.2f, immutableViewportMetrics));
        }

        public String toString() {
            return "DynamicResolutionStrategy";
        }
    }

    private static class VelocityBiasStrategy
    extends DisplayPortStrategy {
        private final float SIZE_MULTIPLIER;
        private final float VELOCITY_THRESHOLD;
        private final float REVERSE_BUFFER;
        private final float DANGER_ZONE_BASE_X_MULTIPLIER;
        private final float DANGER_ZONE_BASE_Y_MULTIPLIER;
        private final float DANGER_ZONE_INCR_X_MULTIPLIER;
        private final float DANGER_ZONE_INCR_Y_MULTIPLIER;

        VelocityBiasStrategy(Map<String, Integer> map) {
            this.SIZE_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_MULTIPLIER, 2000);
            this.VELOCITY_THRESHOLD = (float)GeckoAppShell.getDpi() * DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_VELOCITY_THRESHOLD, 32);
            this.REVERSE_BUFFER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_REVERSE_BUFFER, 200);
            this.DANGER_ZONE_BASE_X_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_DANGER_X_BASE, 1000);
            this.DANGER_ZONE_BASE_Y_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_DANGER_Y_BASE, 1000);
            this.DANGER_ZONE_INCR_X_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_DANGER_X_INCR, 0);
            this.DANGER_ZONE_INCR_Y_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_VB_DANGER_Y_INCR, 0);
        }

        private RectF velocityBiasedMargins(float f, float f2, PointF pointF) {
            RectF rectF = new RectF();
            rectF.left = pointF.x > this.VELOCITY_THRESHOLD ? f * this.REVERSE_BUFFER : (pointF.x < -this.VELOCITY_THRESHOLD ? f * (1.0f - this.REVERSE_BUFFER) : f / 2.0f);
            rectF.right = f - rectF.left;
            rectF.top = pointF.y > this.VELOCITY_THRESHOLD ? f2 * this.REVERSE_BUFFER : (pointF.y < -this.VELOCITY_THRESHOLD ? f2 * (1.0f - this.REVERSE_BUFFER) : f2 / 2.0f);
            rectF.bottom = f2 - rectF.top;
            return rectF;
        }

        @Override
        public DisplayPortMetrics calculate(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
            float f = immutableViewportMetrics.getWidth() * this.SIZE_MULTIPLIER;
            float f2 = immutableViewportMetrics.getHeight() * this.SIZE_MULTIPLIER;
            if (Math.abs(pointF.x) > this.VELOCITY_THRESHOLD && FloatUtils.fuzzyEquals((float)pointF.y, (float)0.0f)) {
                f2 = immutableViewportMetrics.getHeight();
            } else if (Math.abs(pointF.y) > this.VELOCITY_THRESHOLD && FloatUtils.fuzzyEquals((float)pointF.x, (float)0.0f)) {
                f = immutableViewportMetrics.getWidth();
            }
            f = Math.min(f, immutableViewportMetrics.getPageWidth());
            f2 = Math.min(f2, immutableViewportMetrics.getPageHeight());
            float f3 = f - immutableViewportMetrics.getWidth();
            float f4 = f2 - immutableViewportMetrics.getHeight();
            RectF rectF = this.velocityBiasedMargins(f3, f4, pointF);
            rectF = DisplayPortCalculator.shiftMarginsForPageBounds(rectF, immutableViewportMetrics);
            return DisplayPortCalculator.getTileAlignedDisplayPortMetrics(rectF, immutableViewportMetrics.zoomFactor, immutableViewportMetrics);
        }

        @Override
        public boolean aboutToCheckerboard(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF, DisplayPortMetrics displayPortMetrics) {
            float f = immutableViewportMetrics.getWidth() * (this.DANGER_ZONE_BASE_X_MULTIPLIER + pointF.x * this.DANGER_ZONE_INCR_X_MULTIPLIER);
            float f2 = immutableViewportMetrics.getHeight() * (this.DANGER_ZONE_BASE_Y_MULTIPLIER + pointF.y * this.DANGER_ZONE_INCR_Y_MULTIPLIER);
            f = Math.min(f, immutableViewportMetrics.getPageWidth() - immutableViewportMetrics.getWidth());
            f2 = Math.min(f2, immutableViewportMetrics.getPageHeight() - immutableViewportMetrics.getHeight());
            RectF rectF = this.velocityBiasedMargins(f, f2, pointF);
            rectF = DisplayPortCalculator.shiftMarginsForPageBounds(rectF, immutableViewportMetrics);
            RectF rectF2 = new RectF(immutableViewportMetrics.viewportRectLeft - rectF.left, immutableViewportMetrics.viewportRectTop - rectF.top, immutableViewportMetrics.viewportRectRight + rectF.right, immutableViewportMetrics.viewportRectBottom + rectF.bottom);
            return !displayPortMetrics.contains(rectF2);
        }

        public String toString() {
            return "VelocityBiasStrategy mult=" + this.SIZE_MULTIPLIER + ", threshold=" + this.VELOCITY_THRESHOLD + ", reverse=" + this.REVERSE_BUFFER + ", dangerBaseX=" + this.DANGER_ZONE_BASE_X_MULTIPLIER + ", dangerBaseY=" + this.DANGER_ZONE_BASE_Y_MULTIPLIER + ", dangerIncrX=" + this.DANGER_ZONE_INCR_Y_MULTIPLIER + ", dangerIncrY=" + this.DANGER_ZONE_INCR_Y_MULTIPLIER;
        }
    }

    private static class FixedMarginStrategy
    extends DisplayPortStrategy {
        private final float SIZE_MULTIPLIER;
        private final float DANGER_ZONE_X_MULTIPLIER;
        private final float DANGER_ZONE_Y_MULTIPLIER;

        FixedMarginStrategy(Map<String, Integer> map) {
            this.SIZE_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_FM_MULTIPLIER, 2000);
            this.DANGER_ZONE_X_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_FM_DANGER_X, 100);
            this.DANGER_ZONE_Y_MULTIPLIER = DisplayPortCalculator.getFloatPref(map, DisplayPortCalculator.PREF_DISPLAYPORT_FM_DANGER_Y, 200);
        }

        @Override
        public DisplayPortMetrics calculate(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
            float f = immutableViewportMetrics.getWidth() * this.SIZE_MULTIPLIER;
            float f2 = immutableViewportMetrics.getHeight() * this.SIZE_MULTIPLIER;
            FloatSize floatSize = DisplayPortCalculator.reshapeForPage(f, f2, immutableViewportMetrics);
            float f3 = floatSize.width - immutableViewportMetrics.getWidth();
            float f4 = floatSize.height - immutableViewportMetrics.getHeight();
            RectF rectF = new RectF();
            rectF.left = f3 / 2.0f;
            rectF.right = f3 - rectF.left;
            rectF.top = f4 / 2.0f;
            rectF.bottom = f4 - rectF.top;
            rectF = DisplayPortCalculator.shiftMarginsForPageBounds(rectF, immutableViewportMetrics);
            return DisplayPortCalculator.getTileAlignedDisplayPortMetrics(rectF, immutableViewportMetrics.zoomFactor, immutableViewportMetrics);
        }

        @Override
        public boolean aboutToCheckerboard(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF, DisplayPortMetrics displayPortMetrics) {
            RectF rectF = DisplayPortCalculator.expandByDangerZone(immutableViewportMetrics.getViewport(), this.DANGER_ZONE_X_MULTIPLIER, this.DANGER_ZONE_Y_MULTIPLIER, immutableViewportMetrics);
            return !displayPortMetrics.contains(rectF);
        }

        public String toString() {
            return "FixedMarginStrategy mult=" + this.SIZE_MULTIPLIER + ", dangerX=" + this.DANGER_ZONE_X_MULTIPLIER + ", dangerY=" + this.DANGER_ZONE_Y_MULTIPLIER;
        }
    }

    private static class NoMarginStrategy
    extends DisplayPortStrategy {
        NoMarginStrategy(Map<String, Integer> map) {
        }

        @Override
        public DisplayPortMetrics calculate(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF) {
            return new DisplayPortMetrics(immutableViewportMetrics.viewportRectLeft, immutableViewportMetrics.viewportRectTop, immutableViewportMetrics.viewportRectRight, immutableViewportMetrics.viewportRectBottom, immutableViewportMetrics.zoomFactor);
        }

        @Override
        public boolean aboutToCheckerboard(ImmutableViewportMetrics immutableViewportMetrics, PointF pointF, DisplayPortMetrics displayPortMetrics) {
            return true;
        }

        public String toString() {
            return "NoMarginStrategy";
        }
    }

    private static abstract class DisplayPortStrategy {
        private DisplayPortStrategy() {
        }

        public abstract DisplayPortMetrics calculate(ImmutableViewportMetrics var1, PointF var2);

        public abstract boolean aboutToCheckerboard(ImmutableViewportMetrics var1, PointF var2, DisplayPortMetrics var3);

        public boolean drawTimeUpdate(long l, int n) {
            return false;
        }

        public void resetPageState() {
        }
    }
}

