/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.opengl.GLES20;
import android.util.Log;
import java.util.concurrent.ArrayBlockingQueue;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class TextureGenerator {
    private static final String LOGTAG = "TextureGenerator";
    private static final int POOL_SIZE = 5;
    private static TextureGenerator sSharedInstance;
    private final ArrayBlockingQueue<Integer> mTextureIds = new ArrayBlockingQueue(5);
    private EGLContext mContext;

    private TextureGenerator() {
    }

    public static TextureGenerator get() {
        if (sSharedInstance == null) {
            sSharedInstance = new TextureGenerator();
        }
        return sSharedInstance;
    }

    public synchronized int take() {
        try {
            return this.mTextureIds.take();
        }
        catch (InterruptedException interruptedException) {
            return 0;
        }
    }

    public synchronized void fill() {
        int n;
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        EGLContext eGLContext = eGL10.eglGetCurrentContext();
        if (this.mContext != null && this.mContext != eGLContext) {
            this.mTextureIds.clear();
        }
        this.mContext = eGLContext;
        int n2 = this.mTextureIds.remainingCapacity();
        if (n2 == 0) {
            return;
        }
        while ((n = GLES20.glGetError()) != 0) {
            Log.w((String)LOGTAG, (String)String.format("Clearing GL error: %#x", n));
        }
        int[] nArray = new int[n2];
        GLES20.glGenTextures((int)n2, (int[])nArray, (int)0);
        n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)LOGTAG, (String)String.format("Failed to generate textures: %#x", n), (Throwable)new Exception());
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.mTextureIds.offer(nArray[i]);
        }
    }
}

