/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.IOException;
import java.util.HashMap;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.SyncResponse;

public class SyncStorageResponse
extends SyncResponse {
    public static final String RESPONSE_CLIENT_UPGRADE_REQUIRED = "16";
    private static final String LOG_TAG = "SyncStorageResponse";
    public static HashMap<String, String> SERVER_ERROR_MESSAGES;

    public static String getServerErrorMessage(String string2) {
        Logger.debug(LOG_TAG, "Looking up message for body \"" + string2 + "\"");
        if (SERVER_ERROR_MESSAGES.containsKey(string2)) {
            return SERVER_ERROR_MESSAGES.get(string2);
        }
        return string2;
    }

    public SyncStorageResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    public String getErrorMessage() throws IllegalStateException, IOException {
        return SyncStorageResponse.getServerErrorMessage(this.body().trim());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("1", "Illegal method/protocol");
        hashMap.put("2", "Incorrect/missing CAPTCHA");
        hashMap.put("3", "Invalid/missing username");
        hashMap.put("4", "Attempt to overwrite data that can't be overwritten (such as creating a user ID that already exists)");
        hashMap.put("5", "User ID does not match account in path");
        hashMap.put("6", "JSON parse failure");
        hashMap.put("7", "Missing password field");
        hashMap.put("8", "Invalid Weave Basic Object");
        hashMap.put("9", "Requested password not strong enough");
        hashMap.put("10", "Invalid/missing password reset code");
        hashMap.put("11", "Unsupported function");
        hashMap.put("12", "No email address on file");
        hashMap.put("13", "Invalid collection");
        hashMap.put("14", "User over quota");
        hashMap.put("15", "The email does not match the username");
        hashMap.put(RESPONSE_CLIENT_UPGRADE_REQUIRED, "Client upgrade required");
        hashMap.put("255", "An unexpected server error occurred: pool is empty.");
        hashMap.put("\"server issue: getVS failed\"", "server issue: getVS failed");
        hashMap.put("\"server issue: prefix not set\"", "server issue: prefix not set");
        hashMap.put("\"server issue: host header not received from client\"", "server issue: host header not received from client");
        hashMap.put("\"server issue: database lookup failed\"", "server issue: database lookup failed");
        hashMap.put("\"server issue: database is not healthy\"", "server issue: database is not healthy");
        hashMap.put("\"server issue: database not in pool\"", "server issue: database not in pool");
        hashMap.put("\"server issue: database marked as down\"", "server issue: database marked as down");
        SERVER_ERROR_MESSAGES = hashMap;
    }
}

