/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class INISection {
    private static final String LOGTAG = "INIParser";
    private String mName;
    private boolean mDebug;
    protected Hashtable<String, Object> mProperties;

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public INISection(String string) {
        this.mName = string;
    }

    protected void debug(String string) {
        if (this.mDebug) {
            Log.i((String)LOGTAG, (String)string);
        }
    }

    public Object getProperty(String string) {
        this.getProperties();
        return this.mProperties.get(string);
    }

    public int getIntProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return -1;
        }
        return Integer.parseInt(object.toString());
    }

    public String getStringProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Hashtable<String, Object> getProperties() {
        if (this.mProperties == null) {
            try {
                this.parse();
            }
            catch (IOException iOException) {
                this.debug("Error parsing: " + iOException);
            }
        }
        return this.mProperties;
    }

    protected void parse() throws IOException {
        this.mProperties = new Hashtable();
    }

    public void setProperty(String string, Object object) {
        this.getProperties();
        if (object == null) {
            this.removeProperty(string);
        } else {
            this.mProperties.put(string.trim(), object);
        }
    }

    public void removeProperty(String string) {
        this.getProperties();
        this.mProperties.remove(string);
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)this.mName)) {
            bufferedWriter.write("[" + this.mName + "]");
            bufferedWriter.newLine();
        }
        if (this.mProperties != null) {
            Enumeration<String> enumeration = this.mProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.writeProperty(bufferedWriter, string, this.mProperties.get(string));
            }
        }
        bufferedWriter.newLine();
    }

    private void writeProperty(BufferedWriter bufferedWriter, String string, Object object) {
        try {
            bufferedWriter.write(string + "=" + object);
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

