/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.database.Cursor;
import android.util.SparseArray;
import org.json.JSONObject;
import org.mozilla.gecko.background.healthreport.Environment;

public interface HealthReportStorage {
    public void close();

    public int getDay(long var1);

    public int getDay();

    public Environment getEnvironment();

    public SparseArray<String> getEnvironmentHashesByID();

    public SparseArray<Environment> getEnvironmentRecordsByID();

    public Cursor getEnvironmentRecordForID(int var1);

    public Field getField(String var1, int var2, String var3);

    public SparseArray<Field> getFieldsByID();

    public void recordDailyLast(int var1, int var2, int var3, JSONObject var4);

    public void recordDailyLast(int var1, int var2, int var3, String var4);

    public void recordDailyLast(int var1, int var2, int var3, int var4);

    public void recordDailyDiscrete(int var1, int var2, int var3, JSONObject var4);

    public void recordDailyDiscrete(int var1, int var2, int var3, String var4);

    public void recordDailyDiscrete(int var1, int var2, int var3, int var4);

    public void incrementDailyCount(int var1, int var2, int var3, int var4);

    public void incrementDailyCount(int var1, int var2, int var3);

    public boolean hasEventSince(long var1);

    public Cursor getRawEventsSince(long var1);

    public Cursor getEventsSince(long var1);

    public void ensureMeasurementInitialized(String var1, int var2, MeasurementFields var3);

    public Cursor getMeasurementVersions();

    public Cursor getFieldVersions();

    public Cursor getFieldVersions(String var1, int var2);

    public void deleteEverything();

    public void deleteEnvironments();

    public void deleteMeasurements();

    public int deleteDataBefore(long var1, int var3);

    public int getEventCount();

    public int getEnvironmentCount();

    public void pruneEvents(int var1);

    public void pruneEnvironments(int var1);

    public void enqueueOperation(Runnable var1);

    public static abstract class Field {
        protected static final int UNKNOWN_TYPE_OR_FIELD_ID = -1;
        protected static final int FLAG_INTEGER = 1;
        protected static final int FLAG_STRING = 2;
        protected static final int FLAG_JSON = 4;
        protected static final int FLAG_DISCRETE = 256;
        protected static final int FLAG_LAST = 512;
        protected static final int FLAG_COUNTER = 1024;
        protected static final int FLAG_COUNTED = 16384;
        public static final int TYPE_INTEGER_DISCRETE = 257;
        public static final int TYPE_INTEGER_LAST = 513;
        public static final int TYPE_INTEGER_COUNTER = 1025;
        public static final int TYPE_STRING_DISCRETE = 258;
        public static final int TYPE_STRING_LAST = 514;
        public static final int TYPE_JSON_DISCRETE = 260;
        public static final int TYPE_JSON_LAST = 516;
        public static final int TYPE_COUNTED_STRING_DISCRETE = 16642;
        protected int fieldID = -1;
        protected int flags;
        protected final String measurementName;
        protected final String measurementVersion;
        protected final String fieldName;

        public Field(String string2, int n, String string3, int n2) {
            this.measurementName = string2;
            this.measurementVersion = Integer.toString(n, 10);
            this.fieldName = string3;
            this.flags = n2;
        }

        public abstract int getID() throws IllegalStateException;

        public boolean isIntegerField() {
            return (this.flags & 1) > 0;
        }

        public boolean isStringField() {
            return (this.flags & 2) > 0;
        }

        public boolean isJSONField() {
            return (this.flags & 4) > 0;
        }

        public boolean isStoredAsString() {
            return (this.flags & 6) > 0;
        }

        public boolean isDiscreteField() {
            return (this.flags & 0x100) > 0;
        }

        public boolean isCountedField() {
            return (this.flags & 0x4000) > 0;
        }
    }

    public static interface MeasurementFields {
        public Iterable<FieldSpec> getFields();

        public static class FieldSpec {
            public final String name;
            public final int type;

            public FieldSpec(String string2, int n) {
                this.name = string2;
                this.type = n;
            }
        }
    }
}

