/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.activities.FxAccountFinishMigratingActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountNotificationManager {
    private static final String LOG_TAG = FxAccountNotificationManager.class.getSimpleName();
    protected final int notificationId;
    private volatile boolean localeUpdated;

    public FxAccountNotificationManager(int n) {
        this.notificationId = n;
    }

    protected void update(Context context, AndroidFxAccount androidFxAccount) {
        Intent intent;
        String string2;
        String string3;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        State state = androidFxAccount.getState();
        State.Action action = state.getNeededAction();
        if (action == State.Action.None) {
            Logger.info(LOG_TAG, "State " + (Object)((Object)state.getStateLabel()) + " needs no action; cancelling any existing notification.");
            notificationManager.cancel(this.notificationId);
            return;
        }
        if (!this.localeUpdated) {
            this.localeUpdated = true;
            BrowserLocaleManager.getInstance().getAndApplyPersistedLocale(context);
        }
        if (action == State.Action.NeedsFinishMigrating) {
            string3 = context.getResources().getString(R.string.fxaccount_sync_finish_migrating_notification_title);
            string2 = context.getResources().getString(R.string.fxaccount_sync_finish_migrating_notification_text, new Object[]{state.email});
            intent = new Intent(context, FxAccountFinishMigratingActivity.class);
        } else {
            string3 = context.getResources().getString(R.string.fxaccount_sync_sign_in_error_notification_title);
            string2 = context.getResources().getString(R.string.fxaccount_sync_sign_in_error_notification_text, new Object[]{state.email});
            intent = new Intent(context, FxAccountStatusActivity.class);
        }
        Logger.info(LOG_TAG, "State " + (Object)((Object)state.getStateLabel()) + " needs action; offering notification with title: " + string3);
        FxAccountUtils.pii(LOG_TAG, "And text: " + string2);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setContentTitle((CharSequence)string3).setContentText((CharSequence)string2).setSmallIcon(R.drawable.ic_status_logo).setAutoCancel(true).setContentIntent(pendingIntent);
        notificationManager.notify(this.notificationId, builder.build());
    }
}

