/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.setup.auth.AccountAuthenticator;

public class DeleteChannel {
    private static final String LOG_TAG = "DeleteChannel";
    public static final String KEYEXCHANGE_ID_HEADER = "X-KeyExchange-Id";
    public static final String KEYEXCHANGE_CID_HEADER = "X-KeyExchange-Cid";

    public void execute(final JPakeClient jPakeClient, final String string2) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(jPakeClient.channelUrl);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.debug(LOG_TAG, "Encountered URISyntax exception, displaying abort anyway.");
            jPakeClient.displayAbort(string2);
            return;
        }
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            @Override
            public String getUserAgent() {
                return "Firefox AndroidSync 1.37.0a1.0 (Nightly)";
            }

            @Override
            public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
                httpRequestBase.setHeader((Header)new BasicHeader(DeleteChannel.KEYEXCHANGE_ID_HEADER, jPakeClient.clientId));
                httpRequestBase.setHeader((Header)new BasicHeader(DeleteChannel.KEYEXCHANGE_CID_HEADER, jPakeClient.channel));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void handleHttpResponse(HttpResponse httpResponse) {
                try {
                    int n = httpResponse.getStatusLine().getStatusCode();
                    switch (n) {
                        case 200: {
                            Logger.info(DeleteChannel.LOG_TAG, "Successfully reported error to server.");
                            return;
                        }
                        case 403: {
                            Logger.info(DeleteChannel.LOG_TAG, "IP is blacklisted.");
                            return;
                        }
                        case 400: {
                            Logger.info(DeleteChannel.LOG_TAG, "Bad request (missing logs, or bad ids");
                            return;
                        }
                        default: {
                            Logger.info(DeleteChannel.LOG_TAG, "Server returned " + n);
                            return;
                        }
                    }
                }
                finally {
                    BaseResource.consumeEntity(httpResponse);
                    jPakeClient.displayAbort(string2);
                }
            }

            @Override
            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                Logger.debug(DeleteChannel.LOG_TAG, "Encountered HttpProtocolException, displaying abort anyway.");
                jPakeClient.displayAbort(string2);
            }

            @Override
            public void handleHttpIOException(IOException iOException) {
                Logger.debug(DeleteChannel.LOG_TAG, "Encountered IOException, displaying abort anyway.");
                jPakeClient.displayAbort(string2);
            }

            @Override
            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                Logger.debug(DeleteChannel.LOG_TAG, "Encountered GeneralSecurityException, displaying abort anyway.");
                jPakeClient.displayAbort(string2);
            }
        };
        AccountAuthenticator.runOnThread(new Runnable(){

            @Override
            public void run() {
                baseResource.delete();
            }
        });
    }
}

