/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.auth;

import java.util.LinkedList;
import java.util.Queue;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.setup.activities.AccountActivity;
import org.mozilla.gecko.sync.setup.auth.AuthenticateAccountStage;
import org.mozilla.gecko.sync.setup.auth.AuthenticationResult;
import org.mozilla.gecko.sync.setup.auth.AuthenticatorStage;
import org.mozilla.gecko.sync.setup.auth.EnsureUserExistenceStage;
import org.mozilla.gecko.sync.setup.auth.FetchUserNodeStage;

public class AccountAuthenticator {
    private final String LOG_TAG = "AccountAuthenticator";
    private final AccountActivity activityCallback;
    private Queue<AuthenticatorStage> stages;
    public String password;
    public String username;
    public String authServer;
    public String nodeServer;
    public boolean isSuccess = false;
    public boolean isCanceled = false;

    public AccountAuthenticator(AccountActivity accountActivity) {
        this.activityCallback = accountActivity;
        this.prepareStages();
    }

    private void prepareStages() {
        this.stages = new LinkedList<AuthenticatorStage>();
        this.stages.add(new EnsureUserExistenceStage());
        this.stages.add(new FetchUserNodeStage());
        this.stages.add(new AuthenticateAccountStage());
    }

    public void authenticate(String string2, String string3, String string4) {
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        this.nodeServer = string2;
        this.password = string4;
        try {
            this.username = Utils.usernameFromAccount(string3);
        }
        catch (Exception exception) {
            this.abort(AuthenticationResult.FAILURE_OTHER, exception);
            return;
        }
        Logger.pii("AccountAuthenticator", "Username:" + this.username);
        Logger.debug("AccountAuthenticator", "Running first stage.");
        this.runNextStage();
    }

    public void runNextStage() {
        if (this.isCanceled) {
            return;
        }
        if (this.stages.size() == 0) {
            Logger.debug("AccountAuthenticator", "Authentication completed.");
            this.activityCallback.authCallback(this.isSuccess ? AuthenticationResult.SUCCESS : AuthenticationResult.FAILURE_PASSWORD);
            return;
        }
        AuthenticatorStage authenticatorStage = this.stages.remove();
        try {
            authenticatorStage.execute(this);
        }
        catch (Exception exception) {
            Logger.warn("AccountAuthenticator", "Unhandled exception in stage " + authenticatorStage);
            this.abort(AuthenticationResult.FAILURE_OTHER, exception);
        }
    }

    public void abort(AuthenticationResult authenticationResult, Exception exception) {
        if (this.isCanceled) {
            return;
        }
        Logger.warn("AccountAuthenticator", "Authentication failed.", exception);
        this.activityCallback.authCallback(authenticationResult);
    }

    public static void runOnThread(Runnable runnable) {
        ThreadPool.run(runnable);
    }
}

