/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.utils.DateUtils;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheEntity;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheValidityPolicy;
import ch.boye.httpclientandroidlib.impl.client.cache.Proxies;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import ch.boye.httpclientandroidlib.message.BasicHttpResponse;
import java.util.Date;

@Immutable
class CachedHttpResponseGenerator {
    private final CacheValidityPolicy validityStrategy;

    CachedHttpResponseGenerator(CacheValidityPolicy cacheValidityPolicy) {
        this.validityStrategy = cacheValidityPolicy;
    }

    CachedHttpResponseGenerator() {
        this(new CacheValidityPolicy());
    }

    CloseableHttpResponse generateResponse(HttpCacheEntry httpCacheEntry) {
        long l;
        Date date = new Date();
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(HttpVersion.HTTP_1_1, httpCacheEntry.getStatusCode(), httpCacheEntry.getReasonPhrase());
        basicHttpResponse.setHeaders(httpCacheEntry.getAllHeaders());
        if (httpCacheEntry.getResource() != null) {
            CacheEntity cacheEntity = new CacheEntity(httpCacheEntry);
            this.addMissingContentLengthHeader(basicHttpResponse, cacheEntity);
            basicHttpResponse.setEntity(cacheEntity);
        }
        if ((l = this.validityStrategy.getCurrentAgeSecs(httpCacheEntry, date)) > 0L) {
            if (l >= Integer.MAX_VALUE) {
                basicHttpResponse.setHeader("Age", "2147483648");
            } else {
                basicHttpResponse.setHeader("Age", "" + (int)l);
            }
        }
        return Proxies.enhanceResponse(basicHttpResponse);
    }

    CloseableHttpResponse generateNotModifiedResponse(HttpCacheEntry httpCacheEntry) {
        Header header;
        Header header2;
        Header header3;
        Header header4;
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(HttpVersion.HTTP_1_1, 304, "Not Modified");
        Header header5 = httpCacheEntry.getFirstHeader("Date");
        if (header5 == null) {
            header5 = new BasicHeader("Date", DateUtils.formatDate(new Date()));
        }
        basicHttpResponse.addHeader(header5);
        Header header6 = httpCacheEntry.getFirstHeader("ETag");
        if (header6 != null) {
            basicHttpResponse.addHeader(header6);
        }
        if ((header4 = httpCacheEntry.getFirstHeader("Content-Location")) != null) {
            basicHttpResponse.addHeader(header4);
        }
        if ((header3 = httpCacheEntry.getFirstHeader("Expires")) != null) {
            basicHttpResponse.addHeader(header3);
        }
        if ((header2 = httpCacheEntry.getFirstHeader("Cache-Control")) != null) {
            basicHttpResponse.addHeader(header2);
        }
        if ((header = httpCacheEntry.getFirstHeader("Vary")) != null) {
            basicHttpResponse.addHeader(header);
        }
        return Proxies.enhanceResponse(basicHttpResponse);
    }

    private void addMissingContentLengthHeader(HttpResponse httpResponse, HttpEntity httpEntity) {
        if (this.transferEncodingIsPresent(httpResponse)) {
            return;
        }
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header == null) {
            header = new BasicHeader("Content-Length", Long.toString(httpEntity.getContentLength()));
            httpResponse.setHeader(header);
        }
    }

    private boolean transferEncodingIsPresent(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Transfer-Encoding");
        return header != null;
    }
}

