/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.providers;

import android.net.Uri;
import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.mozilla.gecko.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SearchEngine {
    private static final String LOG_TAG = "SearchEngine";
    private static final String URLTYPE_SUGGEST_JSON = "application/x-suggestions+json";
    private static final String URLTYPE_SEARCH_HTML = "text/html";
    private static final String URL_REL_MOBILE = "mobile";
    private static final String MOZ_PARAM_LOCALE = "\\{moz:locale\\}";
    private static final String MOZ_PARAM_DIST_ID = "\\{moz:distributionID\\}";
    private static final String MOZ_PARAM_OFFICIAL = "\\{moz:official\\}";
    private static final String OS_PARAM_USER_DEFINED = "\\{searchTerms\\??\\}";
    private static final String OS_PARAM_INPUT_ENCODING = "\\{inputEncoding\\??\\}";
    private static final String OS_PARAM_LANGUAGE = "\\{language\\??\\}";
    private static final String OS_PARAM_OUTPUT_ENCODING = "\\{outputEncoding\\??\\}";
    private static final String OS_PARAM_OPTIONAL = "\\{(?:\\w+:)?\\w+\\?\\}";
    private static final String STYLE_INJECTION_SCRIPT = "javascript:(function(){var tag=document.createElement('style');tag.type='text/css';document.getElementsByTagName('head')[0].appendChild(tag);tag.innerText='%s'})();";
    private final String identifier;
    private String shortName;
    private String iconURL;
    private final List<Uri> resultsUris = new ArrayList<Uri>();
    private Uri suggestUri;

    public SearchEngine(String string2, InputStream inputStream) throws IOException, XmlPullParserException {
        this.identifier = string2;
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput(inputStream, null);
        xmlPullParser.nextTag();
        this.readSearchPlugin(xmlPullParser);
    }

    private void readSearchPlugin(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (2 != xmlPullParser.getEventType()) {
            throw new XmlPullParserException("Expected start tag: " + xmlPullParser.getPositionDescription());
        }
        String string2 = xmlPullParser.getName();
        if (!"SearchPlugin".equals(string2) && !"OpenSearchDescription".equals(string2)) {
            throw new XmlPullParserException("Expected <SearchPlugin> or <OpenSearchDescription> as root tag: " + xmlPullParser.getPositionDescription());
        }
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            String string3 = xmlPullParser.getName();
            if (string3.equals("ShortName")) {
                this.readShortName(xmlPullParser);
                continue;
            }
            if (string3.equals("Url")) {
                this.readUrl(xmlPullParser);
                continue;
            }
            if (string3.equals("Image")) {
                this.readImage(xmlPullParser);
                continue;
            }
            this.skip(xmlPullParser);
        }
    }

    private void readShortName(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, "ShortName");
        if (xmlPullParser.next() == 4) {
            this.shortName = xmlPullParser.getText();
            xmlPullParser.nextTag();
        }
    }

    private void readUrl(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, "Url");
        String string2 = xmlPullParser.getAttributeValue(null, "type");
        String string3 = xmlPullParser.getAttributeValue(null, "template");
        String string4 = xmlPullParser.getAttributeValue(null, "rel");
        Uri uri = Uri.parse((String)string3);
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            String string5 = xmlPullParser.getName();
            if (string5.equals("Param")) {
                String string6 = xmlPullParser.getAttributeValue(null, "name");
                String string7 = xmlPullParser.getAttributeValue(null, "value");
                uri = uri.buildUpon().appendQueryParameter(string6, string7).build();
                xmlPullParser.nextTag();
                continue;
            }
            this.skip(xmlPullParser);
        }
        if (string2.equals(URLTYPE_SEARCH_HTML)) {
            if (string4 != null && string4.equals(URL_REL_MOBILE)) {
                this.resultsUris.add(0, uri);
            } else {
                this.resultsUris.add(uri);
            }
        } else if (string2.equals(URLTYPE_SUGGEST_JSON)) {
            this.suggestUri = uri;
        }
    }

    private void readImage(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, "Image");
        if (xmlPullParser.next() == 4) {
            this.iconURL = xmlPullParser.getText();
            xmlPullParser.nextTag();
        }
    }

    private void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (xmlPullParser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int n = 1;
        while (n != 0) {
            switch (xmlPullParser.next()) {
                case 3: {
                    --n;
                    break;
                }
                case 2: {
                    ++n;
                }
            }
        }
    }

    public String getInjectableJs() {
        String string2 = this.identifier == null ? "" : (this.identifier.equals("bing") ? "#mHeader{display:none}#contentWrapper{margin-top:0}" : (this.identifier.equals("google") ? "#sfcnt,#top_nav{display:none}" : (this.identifier.equals("yahoo") ? "#nav,#header{display:none}" : "")));
        return String.format(STYLE_INJECTION_SCRIPT, string2);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.shortName;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public boolean isSearchResultsPage(String string2) {
        return this.getResultsUri().getAuthority().equalsIgnoreCase(Uri.parse((String)string2).getAuthority());
    }

    public String queryForResultsUrl(String string2) {
        Uri uri = this.getResultsUri();
        Set set = StringUtils.getQueryParameterNames((Uri)uri);
        for (String string3 : set) {
            if (!uri.getQueryParameter(string3).matches(OS_PARAM_USER_DEFINED)) continue;
            return Uri.parse((String)string2).getQueryParameter(string3);
        }
        return "";
    }

    public String resultsUriForQuery(String string2) {
        Uri uri = this.getResultsUri();
        if (uri == null) {
            Log.e((String)LOG_TAG, (String)("No results URL for search engine: " + this.shortName));
            return "";
        }
        String string3 = Uri.decode((String)uri.toString());
        return this.paramSubstitution(string3, Uri.encode((String)string2));
    }

    public String getSuggestionTemplate(String string2) {
        if (this.suggestUri == null) {
            Log.e((String)LOG_TAG, (String)("No suggestions template for search engine: " + this.shortName));
            return "";
        }
        String string3 = Uri.decode((String)this.suggestUri.toString());
        return this.paramSubstitution(string3, Uri.encode((String)string2));
    }

    private Uri getResultsUri() {
        if (this.resultsUris.isEmpty()) {
            return null;
        }
        return this.resultsUris.get(0);
    }

    private String paramSubstitution(String string2, String string3) {
        String string4 = Locale.getDefault().toString();
        string2 = string2.replaceAll(MOZ_PARAM_LOCALE, string4);
        string2 = string2.replaceAll(MOZ_PARAM_DIST_ID, "");
        string2 = string2.replaceAll(MOZ_PARAM_OFFICIAL, "unofficial");
        string2 = string2.replaceAll(OS_PARAM_USER_DEFINED, string3);
        string2 = string2.replaceAll(OS_PARAM_INPUT_ENCODING, "UTF-8");
        string2 = string2.replaceAll(OS_PARAM_LANGUAGE, string4);
        string2 = string2.replaceAll(OS_PARAM_OUTPUT_ENCODING, "UTF-8");
        string2 = string2.replaceAll(OS_PARAM_OPTIONAL, "");
        return string2;
    }
}

