/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.util.Log;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.db.AbstractPerProfileDatabaseProvider;
import org.mozilla.gecko.db.BrowserDatabaseHelper;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.PerProfileDatabases;

public abstract class SharedBrowserDatabaseProvider
extends AbstractPerProfileDatabaseProvider {
    private static final String LOGTAG = SharedBrowserDatabaseProvider.class.getSimpleName();
    private static PerProfileDatabases<BrowserDatabaseHelper> databases;

    protected PerProfileDatabases<BrowserDatabaseHelper> getDatabases() {
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCreate() {
        Class<SharedBrowserDatabaseProvider> clazz = SharedBrowserDatabaseProvider.class;
        synchronized (SharedBrowserDatabaseProvider.class) {
            if (databases != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            PerProfileDatabases.DatabaseHelperFactory<BrowserDatabaseHelper> databaseHelperFactory = new PerProfileDatabases.DatabaseHelperFactory<BrowserDatabaseHelper>(){

                @Override
                public BrowserDatabaseHelper makeDatabaseHelper(Context context, String string2) {
                    BrowserDatabaseHelper browserDatabaseHelper = new BrowserDatabaseHelper(context, string2);
                    if (AppConstants.Versions.feature16Plus) {
                        browserDatabaseHelper.setWriteAheadLoggingEnabled(true);
                    }
                    return browserDatabaseHelper;
                }
            };
            databases = new PerProfileDatabases<BrowserDatabaseHelper>(this.getContext(), "browser.db", databaseHelperFactory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpSomeDeletedRecords(Uri uri, String string2) {
        String string3;
        Log.d((String)LOGTAG, (String)("Cleaning up deleted records from " + string2));
        long l = System.currentTimeMillis();
        String string4 = "deleted = 1 AND modified <= " + (l - 1728000000L);
        String string5 = uri.getQueryParameter("profile");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabaseForProfile(string5, SharedBrowserDatabaseProvider.isTest(uri));
        String string6 = Long.toString(5L, 10);
        try (Cursor cursor = sQLiteDatabase.query(string2, new String[]{"_id"}, string4, null, null, null, null, string6);){
            string3 = DBUtils.computeSQLInClauseFromLongs(cursor, "_id");
        }
        sQLiteDatabase.delete(string2, string3, null);
    }
}

