/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.repositories.ConstrainedServer11Repository;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.FormHistoryRepositorySession;
import org.mozilla.gecko.sync.repositories.domain.FormHistoryRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.stage.ServerSyncStage;

public class FormHistoryServerSyncStage
extends ServerSyncStage {
    private static final String FORM_HISTORY_SORT = "index";
    private static final long FORM_HISTORY_REQUEST_LIMIT = 5000L;

    @Override
    protected String getCollection() {
        return "forms";
    }

    @Override
    protected String getEngineName() {
        return "forms";
    }

    @Override
    public Integer getStorageVersion() {
        return 1;
    }

    @Override
    protected Repository getRemoteRepository() throws URISyntaxException {
        String string2 = this.getCollection();
        return new ConstrainedServer11Repository(string2, this.session.config.storageURL(), this.session.getAuthHeaderProvider(), this.session.config.infoCollections, 5000L, FORM_HISTORY_SORT);
    }

    @Override
    protected Repository getLocalRepository() {
        return new FormHistoryRepositorySession.FormHistoryRepository();
    }

    @Override
    protected RecordFactory getRecordFactory() {
        return new FormHistoryRecordFactory();
    }

    public class FormHistoryRecordFactory
    extends RecordFactory {
        @Override
        public Record createRecord(Record record) {
            FormHistoryRecord formHistoryRecord = new FormHistoryRecord();
            formHistoryRecord.initFromEnvelope((CryptoRecord)record);
            return formHistoryRecord;
        }
    }
}

