/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.config.Lookup;
import ch.boye.httpclientandroidlib.config.SocketConfig;
import ch.boye.httpclientandroidlib.conn.ConnectTimeoutException;
import ch.boye.httpclientandroidlib.conn.DnsResolver;
import ch.boye.httpclientandroidlib.conn.HttpHostConnectException;
import ch.boye.httpclientandroidlib.conn.ManagedHttpClientConnection;
import ch.boye.httpclientandroidlib.conn.SchemePortResolver;
import ch.boye.httpclientandroidlib.conn.UnsupportedSchemeException;
import ch.boye.httpclientandroidlib.conn.socket.ConnectionSocketFactory;
import ch.boye.httpclientandroidlib.conn.socket.LayeredConnectionSocketFactory;
import ch.boye.httpclientandroidlib.impl.conn.DefaultSchemePortResolver;
import ch.boye.httpclientandroidlib.impl.conn.SystemDefaultDnsResolver;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

@Immutable
class HttpClientConnectionOperator {
    static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    private final Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    HttpClientConnectionOperator(Lookup<ConnectionSocketFactory> lookup, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        Args.notNull(lookup, "Socket factory registry");
        this.socketFactoryRegistry = lookup;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    private Lookup<ConnectionSocketFactory> getSocketFactoryRegistry(HttpContext httpContext) {
        Lookup<ConnectionSocketFactory> lookup = (Lookup<ConnectionSocketFactory>)httpContext.getAttribute(SOCKET_FACTORY_REGISTRY);
        if (lookup == null) {
            lookup = this.socketFactoryRegistry;
        }
        return lookup;
    }

    public void connect(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, InetSocketAddress inetSocketAddress, int n, SocketConfig socketConfig, HttpContext httpContext) throws IOException {
        Lookup<ConnectionSocketFactory> lookup = this.getSocketFactoryRegistry(httpContext);
        ConnectionSocketFactory connectionSocketFactory = lookup.lookup(httpHost.getSchemeName());
        if (connectionSocketFactory == null) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported");
        }
        InetAddress[] inetAddressArray = this.dnsResolver.resolve(httpHost.getHostName());
        int n2 = this.schemePortResolver.resolve(httpHost);
        for (int i = 0; i < inetAddressArray.length; ++i) {
            InetSocketAddress inetSocketAddress2;
            block10: {
                InetAddress inetAddress = inetAddressArray[i];
                boolean bl = i == inetAddressArray.length - 1;
                Socket socket = connectionSocketFactory.createSocket(httpContext);
                socket.setSoTimeout(socketConfig.getSoTimeout());
                socket.setReuseAddress(socketConfig.isSoReuseAddress());
                socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
                socket.setKeepAlive(socketConfig.isSoKeepAlive());
                int n3 = socketConfig.getSoLinger();
                if (n3 >= 0) {
                    socket.setSoLinger(n3 > 0, n3);
                }
                managedHttpClientConnection.bind(socket);
                inetSocketAddress2 = new InetSocketAddress(inetAddress, n2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connecting to " + inetSocketAddress2);
                }
                try {
                    socket = connectionSocketFactory.connectSocket(n, socket, httpHost, inetSocketAddress2, inetSocketAddress, httpContext);
                    managedHttpClientConnection.bind(socket);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connection established " + managedHttpClientConnection);
                    }
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (bl) {
                        throw new ConnectTimeoutException(socketTimeoutException, httpHost, inetAddressArray);
                    }
                }
                catch (ConnectException connectException) {
                    if (!bl) break block10;
                    String string = connectException.getMessage();
                    if ("Connection timed out".equals(string)) {
                        throw new ConnectTimeoutException(connectException, httpHost, inetAddressArray);
                    }
                    throw new HttpHostConnectException(connectException, httpHost, inetAddressArray);
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Connect to " + inetSocketAddress2 + " timed out. " + "Connection will be retried using another IP address");
        }
    }

    public void upgrade(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, HttpContext httpContext) throws IOException {
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Lookup<ConnectionSocketFactory> lookup = this.getSocketFactoryRegistry(httpClientContext);
        ConnectionSocketFactory connectionSocketFactory = lookup.lookup(httpHost.getSchemeName());
        if (connectionSocketFactory == null) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported");
        }
        if (!(connectionSocketFactory instanceof LayeredConnectionSocketFactory)) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol does not support connection upgrade");
        }
        LayeredConnectionSocketFactory layeredConnectionSocketFactory = (LayeredConnectionSocketFactory)connectionSocketFactory;
        Socket socket = managedHttpClientConnection.getSocket();
        int n = this.schemePortResolver.resolve(httpHost);
        socket = layeredConnectionSocketFactory.createLayeredSocket(socket, httpHost.getHostName(), n, httpContext);
        managedHttpClientConnection.bind(socket);
    }
}

