/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.util.Log;
import com.google.android.gms.cast.CastMediaControlIntent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ChromeCast;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoMediaPlayer;
import org.mozilla.gecko.mozglue.JNITarget;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

class MediaPlayerManager
implements NativeEventListener,
GeckoAppShell.AppStateListener {
    private static final String LOGTAG = "GeckoMediaPlayerManager";
    private static final boolean SHOW_DEBUG = false;
    private final Context context;
    private final MediaRouter mediaRouter;
    private final Map<String, GeckoMediaPlayer> displays = new HashMap<String, GeckoMediaPlayer>();
    private static MediaPlayerManager instance;
    private final MediaRouter.Callback callback = new MediaRouter.Callback(){

        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.debug("onRouteRemoved: route=" + routeInfo);
            MediaPlayerManager.this.displays.remove(routeInfo.getId());
        }

        public void onRouteSelected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
        }

        public void onRouteUnselected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
        }

        public void onRoutePresentationDisplayChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
        }

        public void onRouteVolumeChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
        }

        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.debug("onRouteAdded: route=" + routeInfo);
            GeckoMediaPlayer geckoMediaPlayer = MediaPlayerManager.this.getMediaPlayerForRoute(routeInfo);
            if (geckoMediaPlayer != null) {
                MediaPlayerManager.this.displays.put(routeInfo.getId(), geckoMediaPlayer);
            }
        }

        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaPlayerManager.debug("onRouteChanged: route=" + routeInfo);
            GeckoMediaPlayer geckoMediaPlayer = (GeckoMediaPlayer)MediaPlayerManager.this.displays.get(routeInfo.getId());
            if (geckoMediaPlayer != null) {
                MediaPlayerManager.this.displays.put(routeInfo.getId(), geckoMediaPlayer);
            }
        }
    };

    private static void debug(String string2, Exception exception) {
    }

    private static void debug(String string2) {
    }

    @JNITarget
    public static void init(Context context) {
        if (instance != null) {
            MediaPlayerManager.debug("MediaPlayerManager initialized twice");
            return;
        }
        instance = new MediaPlayerManager(context);
    }

    private MediaPlayerManager(Context context) {
        this.context = context;
        if (context instanceof GeckoApp) {
            GeckoApp geckoApp = (GeckoApp)context;
            geckoApp.addAppStateListener(this);
        }
        this.mediaRouter = MediaRouter.getInstance((Context)context);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "MediaPlayer:Load", "MediaPlayer:Start", "MediaPlayer:Stop", "MediaPlayer:Play", "MediaPlayer:Pause", "MediaPlayer:Get", "MediaPlayer:End", "MediaPlayer:Mirror", "MediaPlayer:Message");
    }

    @JNITarget
    public static void onDestroy() {
        if (instance == null) {
            return;
        }
        EventDispatcher.getInstance().unregisterGeckoThreadListener(instance, "MediaPlayer:Load", "MediaPlayer:Start", "MediaPlayer:Stop", "MediaPlayer:Play", "MediaPlayer:Pause", "MediaPlayer:Get", "MediaPlayer:End", "MediaPlayer:Mirror", "MediaPlayer:Message");
        if (MediaPlayerManager.instance.context instanceof GeckoApp) {
            GeckoApp geckoApp = (GeckoApp)MediaPlayerManager.instance.context;
            geckoApp.removeAppStateListener(instance);
        }
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        MediaPlayerManager.debug(string2);
        if ("MediaPlayer:Get".equals(string2)) {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            Iterator<GeckoMediaPlayer> iterator = this.displays.values().iterator();
            while (iterator.hasNext()) {
                GeckoMediaPlayer geckoMediaPlayer = iterator.next();
                try {
                    JSONObject jSONObject2 = geckoMediaPlayer.toJSON();
                    if (jSONObject2 == null) {
                        iterator.remove();
                        continue;
                    }
                    jSONArray.put((Object)jSONObject2);
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"Couldn't create JSON for display", (Throwable)exception);
                }
            }
            try {
                jSONObject.put("displays", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error sending displays", (Throwable)jSONException);
            }
            eventCallback.sendSuccess((Object)jSONObject);
            return;
        }
        GeckoMediaPlayer geckoMediaPlayer = this.displays.get(nativeJSObject.getString("id"));
        if (geckoMediaPlayer == null) {
            Log.e((String)LOGTAG, (String)("Couldn't find a display for this id: " + nativeJSObject.getString("id") + " for message: " + string2));
            if (eventCallback != null) {
                eventCallback.sendError(null);
            }
            return;
        }
        if ("MediaPlayer:Play".equals(string2)) {
            geckoMediaPlayer.play(eventCallback);
        } else if ("MediaPlayer:Start".equals(string2)) {
            geckoMediaPlayer.start(eventCallback);
        } else if ("MediaPlayer:Stop".equals(string2)) {
            geckoMediaPlayer.stop(eventCallback);
        } else if ("MediaPlayer:Pause".equals(string2)) {
            geckoMediaPlayer.pause(eventCallback);
        } else if ("MediaPlayer:End".equals(string2)) {
            geckoMediaPlayer.end(eventCallback);
        } else if ("MediaPlayer:Mirror".equals(string2)) {
            geckoMediaPlayer.mirror(eventCallback);
        } else if ("MediaPlayer:Message".equals(string2) && nativeJSObject.has("data")) {
            geckoMediaPlayer.message(nativeJSObject.getString("data"), eventCallback);
        } else if ("MediaPlayer:Load".equals(string2)) {
            String string3 = nativeJSObject.optString("source", "");
            String string4 = nativeJSObject.optString("type", "video/mp4");
            String string5 = nativeJSObject.optString("title", "");
            geckoMediaPlayer.load(string5, string3, string4, eventCallback);
        }
    }

    private GeckoMediaPlayer getMediaPlayerForRoute(MediaRouter.RouteInfo routeInfo) {
        try {
            if (routeInfo.supportsControlCategory("android.media.intent.category.REMOTE_PLAYBACK")) {
                return new ChromeCast(this.context, routeInfo);
            }
        }
        catch (Exception exception) {
            MediaPlayerManager.debug("Error handling presentation", exception);
        }
        return null;
    }

    @Override
    public void onPause() {
        this.mediaRouter.removeCallback(this.callback);
    }

    @Override
    public void onResume() {
        MediaRouteSelector mediaRouteSelector = new MediaRouteSelector.Builder().addControlCategory("android.media.intent.category.LIVE_VIDEO").addControlCategory("android.media.intent.category.REMOTE_PLAYBACK").addControlCategory(CastMediaControlIntent.categoryForCast((String)"08FF1091")).build();
        this.mediaRouter.addCallback(mediaRouteSelector, this.callback, 4);
    }

    @Override
    public void onOrientationChanged() {
    }
}

