/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.StateFactory;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class AndroidFxAccount {
    protected static final String LOG_TAG = AndroidFxAccount.class.getSimpleName();
    public static final int CURRENT_PREFS_VERSION = 1;
    public static final int CURRENT_ACCOUNT_VERSION = 3;
    public static final String ACCOUNT_KEY_ACCOUNT_VERSION = "version";
    public static final String ACCOUNT_KEY_PROFILE = "profile";
    public static final String ACCOUNT_KEY_IDP_SERVER = "idpServerURI";
    public static final String ACCOUNT_KEY_AUDIENCE = "audience";
    public static final String ACCOUNT_KEY_TOKEN_SERVER = "tokenServerURI";
    public static final String ACCOUNT_KEY_DESCRIPTOR = "descriptor";
    public static final int CURRENT_BUNDLE_VERSION = 2;
    public static final String BUNDLE_KEY_BUNDLE_VERSION = "version";
    public static final String BUNDLE_KEY_STATE_LABEL = "stateLabel";
    public static final String BUNDLE_KEY_STATE = "state";
    protected static final List<String> ANDROID_AUTHORITIES = Collections.unmodifiableList(Arrays.asList("org.mozilla.fennec.db.browser"));
    private static final String PREF_KEY_LAST_SYNCED_TIMESTAMP = "lastSyncedTimestamp";
    protected final Context context;
    protected final AccountManager accountManager;
    protected final Account account;

    public AndroidFxAccount(Context context, Account account) {
        this.context = context;
        this.account = account;
        this.accountManager = AccountManager.get((Context)this.context);
    }

    public void pickle(String string2) {
        AccountPickler.pickle(this, string2);
    }

    public Account getAndroidAccount() {
        return this.account;
    }

    protected int getAccountVersion() {
        String string2 = this.accountManager.getUserData(this.account, "version");
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected void persistBundle(ExtendedJSONObject extendedJSONObject) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_DESCRIPTOR, extendedJSONObject.toJSONString());
    }

    protected ExtendedJSONObject unbundle() {
        int n = this.getAccountVersion();
        if (n < 3) {
            return null;
        }
        if (n > 3) {
            return null;
        }
        String string2 = this.accountManager.getUserData(this.account, ACCOUNT_KEY_DESCRIPTOR);
        if (string2 == null) {
            return null;
        }
        return this.unbundleAccountV2(string2);
    }

    protected String getBundleData(String string2) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return null;
        }
        return extendedJSONObject.getString(string2);
    }

    protected boolean getBundleDataBoolean(String string2, boolean bl) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return bl;
        }
        Boolean bl2 = extendedJSONObject.getBoolean(string2);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    protected byte[] getBundleDataBytes(String string2) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return null;
        }
        return extendedJSONObject.getByteArrayHex(string2);
    }

    protected void updateBundleDataBytes(String string2, byte[] byArray) {
        this.updateBundleValue(string2, byArray == null ? null : Utils.byte2Hex(byArray));
    }

    protected void updateBundleValue(String string2, boolean bl) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return;
        }
        extendedJSONObject.put(string2, bl);
        this.persistBundle(extendedJSONObject);
    }

    protected void updateBundleValue(String string2, String string3) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return;
        }
        extendedJSONObject.put(string2, string3);
        this.persistBundle(extendedJSONObject);
    }

    private ExtendedJSONObject unbundleAccountV1(String string2) {
        ExtendedJSONObject extendedJSONObject;
        try {
            extendedJSONObject = new ExtendedJSONObject(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (2 == extendedJSONObject.getIntegerSafely("version")) {
            return extendedJSONObject;
        }
        return null;
    }

    private ExtendedJSONObject unbundleAccountV2(String string2) {
        return this.unbundleAccountV1(string2);
    }

    public String getProfile() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_PROFILE);
    }

    public String getAccountServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_IDP_SERVER);
    }

    public String getAudience() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_AUDIENCE);
    }

    public String getTokenServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_TOKEN_SERVER);
    }

    public String getSyncPrefsPath() throws GeneralSecurityException, UnsupportedEncodingException {
        String string2 = this.getProfile();
        String string3 = this.account.name;
        if (string2 == null) {
            throw new IllegalStateException("Missing profile. Cannot fetch prefs.");
        }
        if (string3 == null) {
            throw new IllegalStateException("Missing username. Cannot fetch prefs.");
        }
        String string4 = this.getTokenServerURI();
        if (string4 == null) {
            throw new IllegalStateException("No token server URI. Cannot fetch prefs.");
        }
        String string5 = this.getAccountServerURI();
        if (string5 == null) {
            throw new IllegalStateException("No account server URI. Cannot fetch prefs.");
        }
        String string6 = string5 + "!" + string4;
        return Utils.getPrefsPath("org.mozilla.fennec.fxa", string3, string6, string2, 1L);
    }

    public SharedPreferences getSyncPrefs() throws UnsupportedEncodingException, GeneralSecurityException {
        return this.context.getSharedPreferences(this.getSyncPrefsPath(), 0);
    }

    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        extendedJSONObject.put("email", this.account.name);
        try {
            extendedJSONObject.put("emailUTF8", Utils.byte2Hex(this.account.name.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return extendedJSONObject;
    }

    public static AndroidFxAccount addAndroidAccount(Context context, String string2, String string3, String string4, String string5, State state) throws UnsupportedEncodingException, GeneralSecurityException, URISyntaxException {
        return AndroidFxAccount.addAndroidAccount(context, string2, string3, string4, string5, state, 3, true, false, null);
    }

    public static AndroidFxAccount addAndroidAccount(Context context, String string2, String string3, String string4, String string5, State state, int n, boolean bl, boolean bl2, ExtendedJSONObject extendedJSONObject) throws UnsupportedEncodingException, GeneralSecurityException, URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("email must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("profile must not be null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("idpServerURI must not be null");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("tokenServerURI must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        if (n != 3) {
            throw new IllegalStateException("Could not create account of version " + n + ". Current version is " + 3 + ".");
        }
        Bundle bundle = new Bundle();
        bundle.putString("version", "3");
        bundle.putString(ACCOUNT_KEY_IDP_SERVER, string4);
        bundle.putString(ACCOUNT_KEY_TOKEN_SERVER, string5);
        bundle.putString(ACCOUNT_KEY_AUDIENCE, FxAccountUtils.getAudienceForURL(string5));
        bundle.putString(ACCOUNT_KEY_PROFILE, string3);
        if (extendedJSONObject == null) {
            extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("version", 2);
        }
        extendedJSONObject.put(BUNDLE_KEY_STATE_LABEL, state.getStateLabel().name());
        extendedJSONObject.put(BUNDLE_KEY_STATE, state.toJSONObject().toJSONString());
        bundle.putString(ACCOUNT_KEY_DESCRIPTOR, extendedJSONObject.toJSONString());
        Account account = new Account(string2, "org.mozilla.fennec_fxaccount");
        AccountManager accountManager = AccountManager.get((Context)context);
        boolean bl3 = accountManager.addAccountExplicitly(account, null, bundle);
        if (!bl3) {
            return null;
        }
        for (String string6 : bundle.keySet()) {
            accountManager.setUserData(account, string6, bundle.getString(string6));
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        if (!bl2) {
            androidFxAccount.clearSyncPrefs();
        }
        if (bl) {
            androidFxAccount.enableSyncing();
        } else {
            androidFxAccount.disableSyncing();
        }
        return androidFxAccount;
    }

    public void clearSyncPrefs() throws UnsupportedEncodingException, GeneralSecurityException {
        this.getSyncPrefs().edit().clear().commit();
    }

    public static Iterable<String> getAndroidAuthorities() {
        return ANDROID_AUTHORITIES;
    }

    public boolean isSyncing() {
        boolean bl = true;
        for (String string2 : AndroidFxAccount.getAndroidAuthorities()) {
            bl &= ContentResolver.getSyncAutomatically((Account)this.account, (String)string2);
        }
        return bl;
    }

    public void enableSyncing() {
        Logger.info(LOG_TAG, "Enabling sync for account named like " + this.getObfuscatedEmail());
        for (String string2 : AndroidFxAccount.getAndroidAuthorities()) {
            ContentResolver.setSyncAutomatically((Account)this.account, (String)string2, (boolean)true);
            ContentResolver.setIsSyncable((Account)this.account, (String)string2, (int)1);
        }
    }

    public void disableSyncing() {
        Logger.info(LOG_TAG, "Disabling sync for account named like " + this.getObfuscatedEmail());
        for (String string2 : AndroidFxAccount.getAndroidAuthorities()) {
            ContentResolver.setSyncAutomatically((Account)this.account, (String)string2, (boolean)false);
        }
    }

    public boolean isCurrentlySyncing() {
        boolean bl = false;
        for (String string2 : AndroidFxAccount.getAndroidAuthorities()) {
            bl |= ContentResolver.isSyncActive((Account)this.account, (String)string2);
        }
        return bl;
    }

    public void requestSync() {
        this.requestSync(FirefoxAccounts.SOON, null, null);
    }

    public void requestSync(EnumSet<FirefoxAccounts.SyncHint> enumSet) {
        this.requestSync(enumSet, null, null);
    }

    public void requestSync(EnumSet<FirefoxAccounts.SyncHint> enumSet, String[] stringArray, String[] stringArray2) {
        FirefoxAccounts.requestSync(this.getAndroidAccount(), enumSet, stringArray, stringArray2);
    }

    public synchronized void setState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        Logger.info(LOG_TAG, "Moving account named like " + this.getObfuscatedEmail() + " to state " + state.getStateLabel().toString());
        this.updateBundleValue(BUNDLE_KEY_STATE_LABEL, state.getStateLabel().name());
        this.updateBundleValue(BUNDLE_KEY_STATE, state.toJSONObject().toJSONString());
        this.broadcastAccountStateChangedIntent();
    }

    protected void broadcastAccountStateChangedIntent() {
        Intent intent = new Intent("org.mozilla.fennec_fxaccount.accounts.ACCOUNT_STATE_CHANGED_ACTION");
        intent.putExtra("account", this.account.name);
        this.context.sendBroadcast(intent, "org.mozilla.fennec_fxaccount.permission.PER_ACCOUNT_TYPE");
    }

    public synchronized State getState() {
        String string2 = this.getBundleData(BUNDLE_KEY_STATE_LABEL);
        String string3 = this.getBundleData(BUNDLE_KEY_STATE);
        if (string2 == null) {
            throw new IllegalStateException("stateLabelString must not be null");
        }
        if (string3 == null) {
            throw new IllegalStateException("stateString must not be null");
        }
        try {
            State.StateLabel stateLabel = State.StateLabel.valueOf(string2);
            return StateFactory.fromJSONObject(stateLabel, new ExtendedJSONObject(string3));
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not get state", exception);
        }
    }

    public void dump() {
        if (!FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            return;
        }
        ExtendedJSONObject extendedJSONObject = this.toJSONObject();
        ArrayList<String> arrayList = new ArrayList<String>(extendedJSONObject.keySet());
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            FxAccountUtils.pii(LOG_TAG, string2 + ": " + extendedJSONObject.get(string2));
        }
    }

    public String getEmail() {
        return this.account.name;
    }

    public String getObfuscatedEmail() {
        return Utils.obfuscateEmail(this.account.name);
    }

    public static Intent makeDeletedAccountIntent(Context context, Account account) {
        Intent intent = new Intent("org.mozilla.fennec_fxaccount.accounts.ACCOUNT_DELETED_ACTION");
        intent.putExtra("account_deleted_intent_version", (Serializable)Long.valueOf(1L));
        intent.putExtra("account_deleted_intent_account", account.name);
        return intent;
    }

    public void setLastSyncedTimestamp(long l) {
        try {
            this.getSyncPrefs().edit().putLong(PREF_KEY_LAST_SYNCED_TIMESTAMP, l).commit();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception setting last synced time; ignoring.", exception);
        }
    }

    public long getLastSyncedTimestamp() {
        try {
            return this.getSyncPrefs().getLong(PREF_KEY_LAST_SYNCED_TIMESTAMP, -1L);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception getting last synced time; ignoring.", exception);
            return -1L;
        }
    }
}

