/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import java.util.Collection;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.Assert;
import org.mozilla.gecko.R;
import org.mozilla.gecko.overlays.service.sharemethods.ParcelableClientRecord;
import org.mozilla.gecko.overlays.ui.SendTabList;
import org.mozilla.gecko.overlays.ui.SendTabTargetSelectedListener;

public class SendTabDeviceListArrayAdapter
extends ArrayAdapter<ParcelableClientRecord> {
    private static final String LOGTAG = "GeckoSendTabAdapter";
    private SendTabList.State currentState;
    private String dummyRecordName;
    private final SendTabTargetSelectedListener listener;
    private Collection<ParcelableClientRecord> records;
    private AlertDialog dialog;

    public SendTabDeviceListArrayAdapter(Context context, SendTabTargetSelectedListener sendTabTargetSelectedListener) {
        super(context, R.layout.overlay_share_send_tab_item);
        this.listener = sendTabTargetSelectedListener;
        this.setNotifyOnChange(false);
    }

    public ParcelableClientRecord[] toArray() {
        return this.records.toArray(new ParcelableClientRecord[this.records.size()]);
    }

    public void setClientRecordList(Collection<ParcelableClientRecord> collection) {
        this.records = collection;
        this.updateRecordList();
    }

    public void updateRecordList() {
        if (this.currentState != SendTabList.State.LIST) {
            return;
        }
        this.clear();
        this.setNotifyOnChange(false);
        if (AppConstants.Versions.feature11Plus) {
            this.addAll(this.records);
        } else {
            for (ParcelableClientRecord parcelableClientRecord : this.records) {
                this.add(parcelableClientRecord);
            }
        }
        this.notifyDataSetChanged();
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        Context context = this.getContext();
        TextView textView = (TextView)view;
        if (textView == null) {
            textView = (TextView)View.inflate((Context)context, (int)R.layout.overlay_share_send_tab_item, null);
        }
        if (this.currentState != SendTabList.State.LIST) {
            textView.setText((CharSequence)this.dummyRecordName);
            textView.setCompoundDrawablesWithIntrinsicBounds(R.drawable.overlay_send_tab_icon, 0, 0, 0);
        }
        if (this.currentState == SendTabList.State.SHOW_DEVICES) {
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SendTabDeviceListArrayAdapter.this.dialog.show();
                }
            });
            return textView;
        }
        ParcelableClientRecord parcelableClientRecord = (ParcelableClientRecord)this.getItem(n);
        if (this.currentState == SendTabList.State.LIST) {
            textView.setText((CharSequence)parcelableClientRecord.name);
            textView.setCompoundDrawablesWithIntrinsicBounds(SendTabDeviceListArrayAdapter.getImage(parcelableClientRecord), 0, 0, 0);
            final String string2 = parcelableClientRecord.guid;
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SendTabDeviceListArrayAdapter.this.listener.onSendTabTargetSelected(string2);
                }
            });
        } else {
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SendTabDeviceListArrayAdapter.this.listener.onSendTabActionSelected();
                }
            });
        }
        return textView;
    }

    private static int getImage(ParcelableClientRecord parcelableClientRecord) {
        if ("mobile".equals(parcelableClientRecord.type)) {
            return R.drawable.sync_mobile_inactive;
        }
        return R.drawable.sync_desktop_inactive;
    }

    public void switchState(SendTabList.State state) {
        if (this.currentState == state) {
            return;
        }
        this.currentState = state;
        switch (state) {
            case LIST: {
                this.updateRecordList();
                break;
            }
            case NONE: {
                this.showDummyRecord(this.getContext().getResources().getString(R.string.overlay_share_send_tab_btn_label));
                break;
            }
            case SHOW_DEVICES: {
                this.showDummyRecord(this.getContext().getResources().getString(R.string.overlay_share_send_other));
                break;
            }
            default: {
                Assert.fail("Unexpected state transition: " + (Object)((Object)state));
            }
        }
    }

    private void showDummyRecord(String string2) {
        this.dummyRecordName = string2;
        this.clear();
        this.add(null);
        this.notifyDataSetChanged();
    }

    public void setDialog(AlertDialog alertDialog) {
        this.dialog = alertDialog;
    }
}

