/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.NewTabletUI;
import org.mozilla.gecko.R;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ShapedButton;

abstract class NavButton
extends ShapedButton {
    protected final Path mBorderPath;
    protected final Paint mBorderPaint;
    protected final float mBorderWidth;
    protected final int mBorderColor;
    protected final int mBorderColorPrivate;

    public NavButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Resources resources = this.getResources();
        this.mBorderColor = resources.getColor(R.color.nav_button_border_color);
        this.mBorderColorPrivate = resources.getColor(R.color.nav_button_border_color_private);
        this.mBorderWidth = resources.getDimension(R.dimen.nav_button_border_width);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPath = new Path();
        this.setPrivateMode(false);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mBorderPaint.setColor(bl ? this.mBorderColorPrivate : this.mBorderColor);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawPath(this.mBorderPath, this.mBorderPaint);
    }

    @Override
    public void onLightweightThemeChanged() {
        Object object = !NewTabletUI.isEnabled(this.getContext()) ? this.getTheme().getDrawable((View)this) : BrowserToolbar.getLightweightThemeDrawable((View)this, this.getResources(), this.getTheme(), R.color.background_normal);
        if (object == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_PRESSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_pb));
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav));
        stateListDrawable.addState(PRIVATE_FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_focused_pb));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_private));
        stateListDrawable.addState(EMPTY_STATE_SET, object);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_nav_button);
    }
}

