/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Telemetry;

public class DBUtils {
    private static final String LOGTAG = "GeckoDBUtils";
    private static String HISTOGRAM_DATABASE_LOCKED = "DATABASE_LOCKED_EXCEPTION";
    private static String HISTOGRAM_DATABASE_UNLOCKED = "DATABASE_SUCCESSFUL_UNLOCK";

    public static final String qualifyColumn(String string2, String string3) {
        return string2 + "." + string3;
    }

    public static String concatenateWhere(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string3;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return string2;
        }
        return "(" + string2 + ") AND (" + string3 + ")";
    }

    public static String[] appendSelectionArgs(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static void replaceKey(ContentValues contentValues, String string2, String string3, String string4) {
        String string5 = string4;
        if (string2 != null && contentValues.containsKey(string2)) {
            string5 = contentValues.get(string2).toString();
            contentValues.remove(string2);
        }
        if (!contentValues.containsKey(string3)) {
            contentValues.put(string3, string5);
        }
    }

    public static void ensureDatabaseIsNotLocked(SQLiteOpenHelper sQLiteOpenHelper, String string2) {
        int n;
        SQLiteDatabase sQLiteDatabase = null;
        for (n = 0; n < 5; ++n) {
            try {
                sQLiteDatabase = sQLiteOpenHelper.getWritableDatabase();
                break;
            }
            catch (Exception exception) {
                Telemetry.addToHistogram(HISTOGRAM_DATABASE_LOCKED, n);
                Log.d((String)LOGTAG, (String)("Database is locked, trying to kill any zombie processes: " + string2));
                GeckoAppShell.killAnyZombies();
                try {
                    Thread.sleep(n * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (sQLiteDatabase == null) {
            Log.w((String)LOGTAG, (String)"Failed to unlock database.");
            GeckoAppShell.listOfOpenFiles();
            return;
        }
        if (n > 1) {
            Telemetry.addToHistogram(HISTOGRAM_DATABASE_UNLOCKED, n - 1);
        }
    }

    public static void stripEmptyByteArray(ContentValues contentValues, String string2) {
        byte[] byArray;
        if (contentValues.containsKey(string2) && ((byArray = contentValues.getAsByteArray(string2)) == null || byArray.length == 0)) {
            Log.w((String)LOGTAG, (String)"Tried to insert an empty or non-byte-array image. Ignoring.");
            contentValues.putNull(string2);
        }
    }

    public static String computeSQLInClause(int n, String string2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" IN (");
        for (n2 = 0; n2 < n - 1; ++n2) {
            stringBuilder.append("?, ");
        }
        if (n2 < n) {
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String computeSQLInClauseFromLongs(Cursor cursor, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(" IN (");
        int n = cursor.getCount() - 1;
        int n2 = 0;
        while (cursor.moveToNext()) {
            stringBuilder.append(cursor.getLong(0));
            if (n2++ >= n) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

