/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.cache;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import org.mozilla.gecko.favicons.cache.FaviconCacheElement;
import org.mozilla.gecko.gfx.BitmapUtils;

public class FaviconsForURL {
    private static final String LOGTAG = "FaviconForURL";
    private volatile int dominantColor = -1;
    final long downloadTimestamp;
    final ArrayList<FaviconCacheElement> favicons;
    public final boolean hasFailed;

    public FaviconsForURL(int n) {
        this(n, false);
    }

    public FaviconsForURL(int n, boolean bl) {
        this.hasFailed = bl;
        this.downloadTimestamp = System.currentTimeMillis();
        this.favicons = new ArrayList(n);
    }

    public FaviconCacheElement addSecondary(Bitmap bitmap, int n) {
        return this.addInternal(bitmap, false, n);
    }

    public FaviconCacheElement addPrimary(Bitmap bitmap) {
        return this.addInternal(bitmap, true, bitmap.getWidth());
    }

    private FaviconCacheElement addInternal(Bitmap bitmap, boolean bl, int n) {
        FaviconCacheElement faviconCacheElement = new FaviconCacheElement(bitmap, bl, n, this);
        int n2 = Collections.binarySearch(this.favicons, faviconCacheElement);
        if (n2 >= 0) {
            return this.favicons.get(n2);
        }
        ++n2;
        n2 = -n2;
        this.favicons.add(n2, faviconCacheElement);
        return faviconCacheElement;
    }

    public int getNextHighestIndex(int n) {
        FaviconCacheElement faviconCacheElement = new FaviconCacheElement(null, false, n, null);
        int n2 = Collections.binarySearch(this.favicons, faviconCacheElement);
        if (n2 < 0) {
            ++n2;
            n2 = -n2;
        }
        if (n2 == this.favicons.size()) {
            n2 = -1;
        }
        return n2;
    }

    public FaviconCacheElement getNextPrimary(int n) {
        FaviconCacheElement faviconCacheElement;
        int n2;
        int n3 = this.favicons.size();
        for (n2 = n; n2 < n3; ++n2) {
            faviconCacheElement = this.favicons.get(n2);
            if (!faviconCacheElement.isPrimary) continue;
            if (faviconCacheElement.invalidated) {
                return null;
            }
            return faviconCacheElement;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            faviconCacheElement = this.favicons.get(n2);
            if (!faviconCacheElement.isPrimary) continue;
            if (faviconCacheElement.invalidated) {
                return null;
            }
            return faviconCacheElement;
        }
        Log.e((String)LOGTAG, (String)"No primaries found in Favicon cache structure. This is madness!");
        return null;
    }

    public int ensureDominantColor() {
        if (this.dominantColor == -1) {
            for (FaviconCacheElement faviconCacheElement : this.favicons) {
                if (faviconCacheElement.invalidated) continue;
                this.dominantColor = BitmapUtils.getDominantColor(faviconCacheElement.faviconPayload);
                return this.dominantColor;
            }
            this.dominantColor = 0xFFFFFF;
        }
        return this.dominantColor;
    }
}

