/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.middleware;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.middleware.Crypto5MiddlewareRepository;
import org.mozilla.gecko.sync.middleware.MiddlewareRepositorySession;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class Crypto5MiddlewareRepositorySession
extends MiddlewareRepositorySession {
    private final KeyBundle keyBundle;
    private final RecordFactory recordFactory;

    public Crypto5MiddlewareRepositorySession(RepositorySession repositorySession, Crypto5MiddlewareRepository crypto5MiddlewareRepository, RecordFactory recordFactory) {
        super(repositorySession, crypto5MiddlewareRepository);
        this.keyBundle = crypto5MiddlewareRepository.keyBundle;
        this.recordFactory = recordFactory;
    }

    private DecryptingTransformingFetchDelegate makeUnwrappingDelegate(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        if (repositorySessionFetchRecordsDelegate == null) {
            throw new IllegalArgumentException("Inner delegate cannot be null!");
        }
        return new DecryptingTransformingFetchDelegate(repositorySessionFetchRecordsDelegate, this.keyBundle, this.recordFactory);
    }

    @Override
    public void fetchSince(long l, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        this.inner.fetchSince(l, this.makeUnwrappingDelegate(repositorySessionFetchRecordsDelegate));
    }

    @Override
    public void fetch(String[] stringArray, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) throws InactiveSessionException {
        this.inner.fetch(stringArray, this.makeUnwrappingDelegate(repositorySessionFetchRecordsDelegate));
    }

    @Override
    public void fetchAll(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        this.inner.fetchAll(this.makeUnwrappingDelegate(repositorySessionFetchRecordsDelegate));
    }

    @Override
    public void setStoreDelegate(RepositorySessionStoreDelegate repositorySessionStoreDelegate) {
        this.inner.setStoreDelegate(repositorySessionStoreDelegate);
        this.delegate = repositorySessionStoreDelegate;
    }

    @Override
    public void store(Record record) throws NoStoreDelegateException {
        if (this.delegate == null) {
            throw new NoStoreDelegateException();
        }
        CryptoRecord cryptoRecord = record.getEnvelope();
        cryptoRecord.keyBundle = this.keyBundle;
        try {
            cryptoRecord.encrypt();
        }
        catch (UnsupportedEncodingException | CryptoException exception) {
            this.delegate.onRecordStoreFailed(exception, record.guid);
            return;
        }
        this.inner.store(cryptoRecord);
    }

    public class DecryptingTransformingFetchDelegate
    implements RepositorySessionFetchRecordsDelegate {
        private final RepositorySessionFetchRecordsDelegate next;
        private final KeyBundle keyBundle;
        private final RecordFactory recordFactory;

        DecryptingTransformingFetchDelegate(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate, KeyBundle keyBundle, RecordFactory recordFactory) {
            this.next = repositorySessionFetchRecordsDelegate;
            this.keyBundle = keyBundle;
            this.recordFactory = recordFactory;
        }

        @Override
        public void onFetchFailed(Exception exception, Record record) {
            this.next.onFetchFailed(exception, record);
        }

        @Override
        public void onFetchedRecord(Record record) {
            Record record2;
            CryptoRecord cryptoRecord;
            try {
                cryptoRecord = (CryptoRecord)record;
            }
            catch (ClassCastException classCastException) {
                this.next.onFetchFailed(classCastException, record);
                return;
            }
            cryptoRecord.keyBundle = this.keyBundle;
            try {
                cryptoRecord.decrypt();
            }
            catch (Exception exception) {
                this.next.onFetchFailed(exception, cryptoRecord);
                return;
            }
            try {
                record2 = this.recordFactory.createRecord(cryptoRecord);
            }
            catch (Exception exception) {
                this.next.onFetchFailed(exception, cryptoRecord);
                return;
            }
            this.next.onFetchedRecord(record2);
        }

        @Override
        public void onFetchCompleted(long l) {
            this.next.onFetchCompleted(l);
        }

        @Override
        public RepositorySessionFetchRecordsDelegate deferredFetchDelegate(ExecutorService executorService) {
            RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate = this.next.deferredFetchDelegate(executorService);
            return new DecryptingTransformingFetchDelegate(repositorySessionFetchRecordsDelegate, this.keyBundle, this.recordFactory);
        }
    }
}

