/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.util.Locale;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.NewTabletUI;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabsPanel;

class PrivateTabsPanel
extends FrameLayout
implements TabsPanel.CloseAllPanelView {
    private TabsPanel tabsPanel;
    private final TabsPanel.TabsLayout tabsLayout;
    private final View emptyTabsHeader;
    private final LinearLayout emptyTabsFrame;
    private final int emptyTabsFrameWidth;
    private final int emptyTabsFrameVerticalOffset;

    public PrivateTabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Resources resources = this.getResources();
        this.emptyTabsFrameVerticalOffset = resources.getDimensionPixelOffset(R.dimen.browser_toolbar_height);
        this.emptyTabsFrameWidth = resources.getDimensionPixelSize(R.dimen.new_tablet_private_tabs_panel_empty_width);
        LayoutInflater.from((Context)context).inflate(R.layout.private_tabs_panel, (ViewGroup)this);
        this.tabsLayout = (TabsPanel.TabsLayout)this.findViewById(R.id.private_tabs_layout);
        this.emptyTabsHeader = this.findViewById(R.id.private_tabs_empty_header);
        this.emptyTabsFrame = (LinearLayout)this.findViewById(R.id.private_tabs_empty);
        this.tabsLayout.setEmptyView((View)this.emptyTabsFrame);
        View view = this.findViewById(R.id.private_tabs_learn_more);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = Locales.getLanguageTag(Locale.getDefault());
                String string3 = PrivateTabsPanel.this.getResources().getString(R.string.private_tabs_panel_learn_more_link, new Object[]{string2});
                Tabs.getInstance().loadUrlInTab(string3);
                if (PrivateTabsPanel.this.tabsPanel != null) {
                    PrivateTabsPanel.this.tabsPanel.autoHidePanel();
                }
            }
        });
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
        this.tabsLayout.setTabsPanel(tabsPanel);
    }

    @Override
    public void show() {
        this.updateStyleForNewTablet();
        this.tabsLayout.show();
        this.setVisibility(0);
    }

    @Override
    public void hide() {
        this.setVisibility(8);
        this.tabsLayout.hide();
    }

    @Override
    public boolean shouldExpand() {
        return this.tabsLayout.shouldExpand();
    }

    @Override
    public void closeAll() {
        this.tabsLayout.closeAll();
    }

    private void updateStyleForNewTablet() {
        if (!NewTabletUI.isEnabled(this.getContext())) {
            return;
        }
        this.emptyTabsFrame.setOrientation(1);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.emptyTabsFrame.getLayoutParams();
        layoutParams.width = this.getResources().getDimensionPixelSize(R.dimen.new_tablet_private_tabs_panel_empty_width);
        layoutParams.height = -2;
        layoutParams.gravity = 17;
        this.emptyTabsFrame.setPadding(0, 0, 0, this.emptyTabsFrameVerticalOffset);
        this.emptyTabsHeader.setVisibility(0);
    }
}

