/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabCurve;
import org.mozilla.gecko.widget.ResizablePathDrawable;
import org.mozilla.gecko.widget.ThemedImageButton;
import org.mozilla.gecko.widget.ThemedLinearLayout;
import org.mozilla.gecko.widget.ThemedTextView;

public class TabStripItemView
extends ThemedLinearLayout
implements Checkable {
    private static final String LOGTAG = "GeckoTabStripItem";
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private int id = -1;
    private boolean checked;
    private final ImageView faviconView;
    private final ThemedTextView titleView;
    private final ThemedImageButton closeView;
    private final ResizablePathDrawable backgroundDrawable;
    private final Region tabRegion;
    private final Region tabClipRegion;
    private boolean tabRegionNeedsUpdate;
    private final int faviconSize;
    private Bitmap lastFavicon;

    public TabStripItemView(Context context) {
        this(context, null);
    }

    public TabStripItemView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        this.tabRegion = new Region();
        this.tabClipRegion = new Region();
        Resources resources = context.getResources();
        ColorStateList colorStateList = resources.getColorStateList(R.color.new_tablet_tab_strip_item_bg);
        this.backgroundDrawable = new ResizablePathDrawable((ResizablePathDrawable.NonScaledPathShape)new TabCurveShape(), colorStateList);
        this.setBackgroundDrawable((Drawable)this.backgroundDrawable);
        this.faviconSize = resources.getDimensionPixelSize(R.dimen.new_tablet_tab_strip_favicon_size);
        LayoutInflater.from((Context)context).inflate(R.layout.tab_strip_item_view, (ViewGroup)this);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TabStripItemView.this.id < 0) {
                    throw new IllegalStateException("Invalid tab id:" + TabStripItemView.this.id);
                }
                Tabs.getInstance().selectTab(TabStripItemView.this.id);
            }
        });
        this.faviconView = (ImageView)this.findViewById(R.id.favicon);
        this.titleView = (ThemedTextView)this.findViewById(R.id.title);
        this.closeView = (ThemedImageButton)this.findViewById(R.id.close);
        this.closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TabStripItemView.this.id < 0) {
                    throw new IllegalStateException("Invalid tab id:" + TabStripItemView.this.id);
                }
                Tabs tabs = Tabs.getInstance();
                tabs.closeTab(tabs.getTab(TabStripItemView.this.id), true);
            }
        });
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.tabRegionNeedsUpdate = true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        int n2 = (int)motionEvent.getX();
        int n3 = (int)motionEvent.getY();
        if (n == 0 && !this.tabRegion.contains(n2, n3)) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.tabRegionNeedsUpdate) {
            Path path = this.backgroundDrawable.getPath();
            this.tabClipRegion.set(0, 0, this.getWidth(), this.getHeight());
            this.tabRegion.setPath(path, this.tabClipRegion);
            this.tabRegionNeedsUpdate = false;
        }
    }

    @Override
    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.checked) {
            TabStripItemView.mergeDrawableStates((int[])nArray, (int[])STATE_CHECKED);
        }
        return nArray;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean bl) {
        if (this.checked == bl) {
            return;
        }
        this.checked = bl;
        this.refreshDrawableState();
    }

    public void toggle() {
        this.setChecked(!this.checked);
    }

    public void setPressed(boolean bl) {
        super.setPressed(bl);
        View view = (View)this.getParent();
        if (view != null) {
            view.invalidate();
        }
    }

    void updateFromTab(Tab tab) {
        if (tab == null) {
            return;
        }
        this.id = tab.getId();
        this.updateTitle(tab);
        this.updateFavicon(tab.getFavicon());
        this.setPrivateMode(tab.isPrivate());
    }

    private void updateTitle(Tab tab) {
        if (AboutPages.isAboutHome(tab.getURL())) {
            this.titleView.setText(R.string.home_title);
        } else {
            this.titleView.setText(tab.getDisplayTitle());
        }
    }

    private void updateFavicon(Bitmap bitmap) {
        if (bitmap == null) {
            this.lastFavicon = null;
            this.faviconView.setImageResource(R.drawable.new_tablet_default_favicon);
            return;
        }
        if (bitmap == this.lastFavicon) {
            return;
        }
        this.lastFavicon = bitmap;
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.faviconSize, (int)this.faviconSize, (boolean)false);
        this.faviconView.setImageBitmap(bitmap2);
    }

    private static class TabCurveShape
    extends ResizablePathDrawable.NonScaledPathShape {
        private TabCurveShape() {
        }

        protected void onResize(float f, float f2) {
            Path path = this.getPath();
            path.reset();
            float f3 = TabCurve.getWidthForHeight(f2);
            path.moveTo(0.0f, f2);
            TabCurve.drawFromBottom(path, 0.0f, f2, TabCurve.Direction.RIGHT);
            path.lineTo(f - f3, 0.0f);
            TabCurve.drawFromTop(path, f - f3, f2, TabCurve.Direction.RIGHT);
            path.lineTo(0.0f, f2);
        }
    }
}

