/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import org.mozilla.gecko.AppConstants;

public class GeckoSwipeRefreshLayout
extends ViewGroup {
    private static final long RETURN_TO_ORIGINAL_POSITION_TIMEOUT = 300L;
    private static final float ACCELERATE_INTERPOLATION_FACTOR = 1.5f;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final float PROGRESS_BAR_HEIGHT = 3.0f;
    private static final float MAX_SWIPE_DISTANCE_FACTOR = 0.6f;
    private static final int REFRESH_TRIGGER_DISTANCE = 120;
    SwipeProgressBar mProgressBar;
    View mTarget;
    int mOriginalOffsetTop;
    int mFrom;
    int mMediumAnimationDuration;
    float mFromPercentage;
    float mCurrPercentage;
    int mCurrentTargetOffsetTop;
    private OnRefreshListener mListener;
    private MotionEvent mDownEvent;
    private boolean mRefreshing;
    private final int mTouchSlop;
    private float mDistanceToTriggerSync = -1.0f;
    private float mPrevY;
    private final int mProgressBarHeight;
    boolean mReturningToStart;
    final DecelerateInterpolator mDecelerateInterpolator;
    private final AccelerateInterpolator mAccelerateInterpolator;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    private final Animation mAnimateToStartPosition = new Animation(){

        public void applyTransformation(float f, Transformation transformation) {
            int n;
            int n2;
            int n3 = 0;
            if (GeckoSwipeRefreshLayout.this.mFrom != GeckoSwipeRefreshLayout.this.mOriginalOffsetTop) {
                n3 = GeckoSwipeRefreshLayout.this.mFrom + (int)((float)(GeckoSwipeRefreshLayout.this.mOriginalOffsetTop - GeckoSwipeRefreshLayout.this.mFrom) * f);
            }
            if ((n2 = n3 - GeckoSwipeRefreshLayout.this.mTarget.getTop()) + (n = GeckoSwipeRefreshLayout.this.mTarget.getTop()) < 0) {
                n2 = 0 - n;
            }
            GeckoSwipeRefreshLayout.this.setTargetOffsetTopAndBottom(n2);
        }
    };
    Animation mShrinkTrigger = new Animation(){

        public void applyTransformation(float f, Transformation transformation) {
            float f2 = GeckoSwipeRefreshLayout.this.mFromPercentage + (0.0f - GeckoSwipeRefreshLayout.this.mFromPercentage) * f;
            GeckoSwipeRefreshLayout.this.mProgressBar.setTriggerPercentage(f2);
        }
    };
    final Animation.AnimationListener mReturnToStartPositionListener = new BaseAnimationListener(){

        @Override
        public void onAnimationEnd(Animation animation) {
            GeckoSwipeRefreshLayout.this.mCurrentTargetOffsetTop = 0;
        }
    };
    final Animation.AnimationListener mShrinkAnimationListener = new BaseAnimationListener(){

        @Override
        public void onAnimationEnd(Animation animation) {
            GeckoSwipeRefreshLayout.this.mCurrPercentage = 0.0f;
        }
    };
    private final Runnable mReturnToStartPosition = new Runnable(){

        @Override
        public void run() {
            GeckoSwipeRefreshLayout.this.mReturningToStart = true;
            GeckoSwipeRefreshLayout.this.animateOffsetToStartPosition(GeckoSwipeRefreshLayout.this.mCurrentTargetOffsetTop + GeckoSwipeRefreshLayout.this.getPaddingTop(), GeckoSwipeRefreshLayout.this.mReturnToStartPositionListener);
        }
    };
    private final Runnable mCancel = new Runnable(){

        @Override
        public void run() {
            GeckoSwipeRefreshLayout.this.mReturningToStart = true;
            if (GeckoSwipeRefreshLayout.this.mProgressBar != null) {
                GeckoSwipeRefreshLayout.this.mFromPercentage = GeckoSwipeRefreshLayout.this.mCurrPercentage;
                GeckoSwipeRefreshLayout.this.mShrinkTrigger.setDuration((long)GeckoSwipeRefreshLayout.this.mMediumAnimationDuration);
                GeckoSwipeRefreshLayout.this.mShrinkTrigger.setAnimationListener(GeckoSwipeRefreshLayout.this.mShrinkAnimationListener);
                GeckoSwipeRefreshLayout.this.mShrinkTrigger.reset();
                GeckoSwipeRefreshLayout.this.mShrinkTrigger.setInterpolator((Interpolator)GeckoSwipeRefreshLayout.this.mDecelerateInterpolator);
                GeckoSwipeRefreshLayout.this.startAnimation(GeckoSwipeRefreshLayout.this.mShrinkTrigger);
            }
            GeckoSwipeRefreshLayout.this.animateOffsetToStartPosition(GeckoSwipeRefreshLayout.this.mCurrentTargetOffsetTop + GeckoSwipeRefreshLayout.this.getPaddingTop(), GeckoSwipeRefreshLayout.this.mReturnToStartPositionListener);
        }
    };

    public GeckoSwipeRefreshLayout(Context context) {
        this(context, null);
    }

    public GeckoSwipeRefreshLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMediumAnimationDuration = this.getResources().getInteger(0x10E0001);
        this.setWillNotDraw(false);
        this.mProgressBar = new SwipeProgressBar((View)this);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mProgressBarHeight = (int)(displayMetrics.density * 3.0f);
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.mAccelerateInterpolator = new AccelerateInterpolator(1.5f);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
        this.setEnabled(typedArray.getBoolean(0, true));
        typedArray.recycle();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.removeCallbacks(this.mCancel);
        this.removeCallbacks(this.mReturnToStartPosition);
        if (this.getChildCount() > 0) {
            this.getChildAt(0).forceLayout();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mReturnToStartPosition);
        this.removeCallbacks(this.mCancel);
    }

    void animateOffsetToStartPosition(int n, Animation.AnimationListener animationListener) {
        this.mFrom = n;
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration((long)this.mMediumAnimationDuration);
        this.mAnimateToStartPosition.setAnimationListener(animationListener);
        this.mAnimateToStartPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        this.mTarget.startAnimation(this.mAnimateToStartPosition);
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mListener = onRefreshListener;
    }

    private void setTriggerPercentage(float f) {
        if (f == 0.0f) {
            this.mCurrPercentage = 0.0f;
            return;
        }
        this.mCurrPercentage = f;
        this.mProgressBar.setTriggerPercentage(f);
    }

    public void setRefreshing(boolean bl) {
        if (this.mRefreshing != bl) {
            this.ensureTarget();
            this.mCurrPercentage = 0.0f;
            this.mRefreshing = bl;
            if (this.mRefreshing) {
                this.mProgressBar.start();
            } else {
                this.mProgressBar.stop();
            }
        }
    }

    public void setColorScheme(int n, int n2, int n3, int n4) {
        this.ensureTarget();
        Resources resources = this.getResources();
        int n5 = resources.getColor(n);
        int n6 = resources.getColor(n2);
        int n7 = resources.getColor(n3);
        int n8 = resources.getColor(n4);
        this.mProgressBar.setColorScheme(n5, n6, n7, n8);
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            if (this.getChildCount() > 1 && !this.isInEditMode()) {
                throw new IllegalStateException("GeckoSwipeRefreshLayout can host only one direct child");
            }
            this.mTarget = this.getChildAt(0);
            this.mOriginalOffsetTop = this.mTarget.getTop() + this.getPaddingTop();
        }
        if (this.mDistanceToTriggerSync == -1.0f && this.getParent() != null && ((View)this.getParent()).getHeight() > 0) {
            DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
            this.mDistanceToTriggerSync = (int)Math.min((float)((View)this.getParent()).getHeight() * 0.6f, 120.0f * displayMetrics.density);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mProgressBar.draw(canvas);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getMeasuredWidth();
        int n6 = this.getMeasuredHeight();
        this.mProgressBar.setBounds(0, 0, n5, this.mProgressBarHeight);
        if (this.getChildCount() == 0) {
            return;
        }
        View view = this.getChildAt(0);
        int n7 = this.getPaddingLeft();
        int n8 = this.mCurrentTargetOffsetTop + this.getPaddingTop();
        int n9 = n5 - this.getPaddingLeft() - this.getPaddingRight();
        int n10 = n6 - this.getPaddingTop() - this.getPaddingBottom();
        view.layout(n7, n8, n7 + n9, n8 + n10);
    }

    public void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.getChildCount() > 1 && !this.isInEditMode()) {
            throw new IllegalStateException("GeckoSwipeRefreshLayout can host only one direct child");
        }
        if (this.getChildCount() > 0) {
            this.getChildAt(0).measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
        }
    }

    public boolean canChildScrollUp() {
        if (AppConstants.Versions.preICS) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        this.ensureTarget();
        boolean bl = false;
        if (this.mReturningToStart && motionEvent.getAction() == 0) {
            this.mReturningToStart = false;
        }
        if (this.isEnabled() && !this.mReturningToStart && !this.canChildScrollUp()) {
            bl = this.onTouchEvent(motionEvent);
        }
        return !bl ? super.onInterceptTouchEvent(motionEvent) : bl;
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        boolean bl = false;
        switch (n) {
            case 0: {
                this.mCurrPercentage = 0.0f;
                this.mDownEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                this.mPrevY = this.mDownEvent.getY();
                break;
            }
            case 2: {
                float f;
                float f2;
                if (this.mDownEvent == null || this.mReturningToStart || !((f2 = (f = motionEvent.getY()) - this.mDownEvent.getY()) > (float)this.mTouchSlop)) break;
                if (f2 > this.mDistanceToTriggerSync) {
                    this.startRefresh();
                    bl = true;
                    break;
                }
                this.setTriggerPercentage(this.mAccelerateInterpolator.getInterpolation(f2 / this.mDistanceToTriggerSync));
                float f3 = f2;
                if (this.mPrevY > f) {
                    f3 = f2 - (float)this.mTouchSlop;
                }
                if (this.mPrevY > f && this.mTarget.getTop() < this.mTouchSlop) {
                    this.removeCallbacks(this.mCancel);
                } else {
                    this.updatePositionTimeout();
                }
                this.mPrevY = motionEvent.getY();
                bl = true;
                break;
            }
            case 1: 
            case 3: {
                if (this.mDownEvent == null) break;
                this.mDownEvent.recycle();
                this.mDownEvent = null;
            }
        }
        return bl;
    }

    private void startRefresh() {
        this.removeCallbacks(this.mCancel);
        this.mReturnToStartPosition.run();
        this.setRefreshing(true);
        this.mListener.onRefresh();
    }

    private void updateContentOffsetTop(int n) {
        int n2 = this.mTarget.getTop();
        if ((float)n > this.mDistanceToTriggerSync) {
            n = (int)this.mDistanceToTriggerSync;
        } else if (n < 0) {
            n = 0;
        }
        this.setTargetOffsetTopAndBottom(n - n2);
    }

    void setTargetOffsetTopAndBottom(int n) {
        this.mTarget.offsetTopAndBottom(n);
        this.mCurrentTargetOffsetTop = this.mTarget.getTop();
    }

    private void updatePositionTimeout() {
        this.removeCallbacks(this.mCancel);
        this.postDelayed(this.mCancel, 300L);
    }

    private static final class BakedBezierInterpolator
    implements Interpolator {
        private static final BakedBezierInterpolator INSTANCE = new BakedBezierInterpolator();
        private static final float[] VALUES = new float[]{0.0f, 2.0E-4f, 9.0E-4f, 0.0019f, 0.0036f, 0.0059f, 0.0086f, 0.0119f, 0.0157f, 0.0209f, 0.0257f, 0.0321f, 0.0392f, 0.0469f, 0.0566f, 0.0656f, 0.0768f, 0.0887f, 0.1033f, 0.1186f, 0.1349f, 0.1519f, 0.1696f, 0.1928f, 0.2121f, 0.237f, 0.2627f, 0.2892f, 0.3109f, 0.3386f, 0.3667f, 0.3952f, 0.4241f, 0.4474f, 0.4766f, 0.5f, 0.5234f, 0.5468f, 0.5701f, 0.5933f, 0.6134f, 0.6333f, 0.6531f, 0.6698f, 0.6891f, 0.7054f, 0.7214f, 0.7346f, 0.7502f, 0.763f, 0.7756f, 0.7879f, 0.8f, 0.8107f, 0.8212f, 0.8326f, 0.8415f, 0.8503f, 0.8588f, 0.8672f, 0.8754f, 0.8833f, 0.8911f, 0.8977f, 0.9041f, 0.9113f, 0.9165f, 0.9232f, 0.9281f, 0.9328f, 0.9382f, 0.9434f, 0.9476f, 0.9518f, 0.9557f, 0.9596f, 0.9632f, 0.9662f, 0.9695f, 0.9722f, 0.9753f, 0.9777f, 0.9805f, 0.9826f, 0.9847f, 0.9866f, 0.9884f, 0.9901f, 0.9917f, 0.9931f, 0.9944f, 0.9955f, 0.9964f, 0.9973f, 0.9981f, 0.9986f, 0.9992f, 0.9995f, 0.9998f, 1.0f, 1.0f};
        private static final float STEP_SIZE = 1.0f / (float)(VALUES.length - 1);

        public static final BakedBezierInterpolator getInstance() {
            return INSTANCE;
        }

        private BakedBezierInterpolator() {
        }

        public float getInterpolation(float f) {
            if (f >= 1.0f) {
                return 1.0f;
            }
            if (f <= 0.0f) {
                return 0.0f;
            }
            int n = Math.min((int)(f * (float)(VALUES.length - 1)), VALUES.length - 2);
            float f2 = (float)n * STEP_SIZE;
            float f3 = f - f2;
            float f4 = f3 / STEP_SIZE;
            return VALUES[n] + f4 * (VALUES[n + 1] - VALUES[n]);
        }
    }

    private static final class SwipeProgressBar {
        private static final int COLOR1 = -1291845632;
        private static final int COLOR2 = Integer.MIN_VALUE;
        private static final int COLOR3 = 0x4D000000;
        private static final int COLOR4 = 0x1A000000;
        private static final int ANIMATION_DURATION_MS = 2000;
        private static final int FINISH_ANIMATION_DURATION_MS = 1000;
        private static final Interpolator INTERPOLATOR = BakedBezierInterpolator.getInstance();
        private final Paint mPaint = new Paint();
        private final RectF mClipRect = new RectF();
        private float mTriggerPercentage;
        private long mStartTime;
        private long mFinishTime;
        private boolean mRunning;
        private int mColor1;
        private int mColor2;
        private int mColor3;
        private int mColor4;
        private final View mParent;
        private final Rect mBounds = new Rect();

        public SwipeProgressBar(View view) {
            this.mParent = view;
            this.mColor1 = -1291845632;
            this.mColor2 = Integer.MIN_VALUE;
            this.mColor3 = 0x4D000000;
            this.mColor4 = 0x1A000000;
        }

        void setColorScheme(int n, int n2, int n3, int n4) {
            this.mColor1 = n;
            this.mColor2 = n2;
            this.mColor3 = n3;
            this.mColor4 = n4;
        }

        void setTriggerPercentage(float f) {
            this.mTriggerPercentage = f;
            this.mStartTime = 0L;
            ViewCompat.postInvalidateOnAnimation((View)this.mParent);
        }

        void start() {
            if (!this.mRunning) {
                this.mTriggerPercentage = 0.0f;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mRunning = true;
                this.mParent.postInvalidate();
            }
        }

        void stop() {
            if (this.mRunning) {
                this.mTriggerPercentage = 0.0f;
                this.mFinishTime = AnimationUtils.currentAnimationTimeMillis();
                this.mRunning = false;
                this.mParent.postInvalidate();
            }
        }

        boolean isRunning() {
            return this.mRunning || this.mFinishTime > 0L;
        }

        void draw(Canvas canvas) {
            int n = this.mBounds.width();
            int n2 = this.mBounds.height();
            int n3 = n / 2;
            int n4 = n2 / 2;
            boolean bl = false;
            int n5 = canvas.save();
            canvas.clipRect(this.mBounds);
            if (this.mRunning || this.mFinishTime > 0L) {
                long l = AnimationUtils.currentAnimationTimeMillis();
                long l2 = (l - this.mStartTime) % 2000L;
                long l3 = (l - this.mStartTime) / 2000L;
                float f = (float)l2 / 20.0f;
                if (!this.mRunning) {
                    if (l - this.mFinishTime >= 1000L) {
                        this.mFinishTime = 0L;
                        return;
                    }
                    long l4 = (l - this.mFinishTime) % 1000L;
                    float f2 = (float)l4 / 10.0f;
                    float f3 = f2 / 100.0f;
                    float f4 = (float)(n / 2) * INTERPOLATOR.getInterpolation(f3);
                    this.mClipRect.set((float)n3 - f4, 0.0f, (float)n3 + f4, (float)n2);
                    canvas.saveLayerAlpha(this.mClipRect, 0, 0);
                    bl = true;
                }
                if (l3 == 0L) {
                    canvas.drawColor(this.mColor1);
                } else if (f >= 0.0f && f < 25.0f) {
                    canvas.drawColor(this.mColor4);
                } else if (f >= 25.0f && f < 50.0f) {
                    canvas.drawColor(this.mColor1);
                } else if (f >= 50.0f && f < 75.0f) {
                    canvas.drawColor(this.mColor2);
                } else {
                    canvas.drawColor(this.mColor3);
                }
                if (f >= 0.0f && f <= 25.0f) {
                    float f5 = (f + 25.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, n3, n4, this.mColor1, f5);
                }
                if (f >= 0.0f && f <= 50.0f) {
                    float f6 = f * 2.0f / 100.0f;
                    this.drawCircle(canvas, n3, n4, this.mColor2, f6);
                }
                if (f >= 25.0f && f <= 75.0f) {
                    float f7 = (f - 25.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, n3, n4, this.mColor3, f7);
                }
                if (f >= 50.0f && f <= 100.0f) {
                    float f8 = (f - 50.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, n3, n4, this.mColor4, f8);
                }
                if (f >= 75.0f && f <= 100.0f) {
                    float f9 = (f - 75.0f) * 2.0f / 100.0f;
                    this.drawCircle(canvas, n3, n4, this.mColor1, f9);
                }
                if (this.mTriggerPercentage > 0.0f && bl) {
                    canvas.restoreToCount(n5);
                    n5 = canvas.save();
                    canvas.clipRect(this.mBounds);
                    this.drawTrigger(canvas, n3, n4);
                }
                ViewCompat.postInvalidateOnAnimation((View)this.mParent);
            } else if (this.mTriggerPercentage > 0.0f && (double)this.mTriggerPercentage <= 1.0) {
                this.drawTrigger(canvas, n3, n4);
            }
            canvas.restoreToCount(n5);
        }

        private void drawTrigger(Canvas canvas, int n, int n2) {
            this.mPaint.setColor(this.mColor1);
            canvas.drawRect((float)n - (float)n * this.mTriggerPercentage, 0.0f, (float)n + (float)n * this.mTriggerPercentage, (float)this.mBounds.bottom, this.mPaint);
        }

        private void drawCircle(Canvas canvas, float f, float f2, int n, float f3) {
            this.mPaint.setColor(n);
            canvas.save();
            canvas.translate(f, f2);
            float f4 = INTERPOLATOR.getInterpolation(f3);
            canvas.scale(f4, f4);
            canvas.drawCircle(0.0f, 0.0f, f, this.mPaint);
            canvas.restore();
        }

        void setBounds(int n, int n2, int n3, int n4) {
            this.mBounds.left = n;
            this.mBounds.top = n2;
            this.mBounds.right = n3;
            this.mBounds.bottom = n4;
        }
    }

    private class BaseAnimationListener
    implements Animation.AnimationListener {
        private BaseAnimationListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

