/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.database.Cursor;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.util.ThreadUtils;

class GlobalHistory {
    private static final String LOGTAG = "GeckoGlobalHistory";
    private static final String TELEMETRY_HISTOGRAM_ADD = "FENNEC_GLOBALHISTORY_ADD_MS";
    private static final String TELEMETRY_HISTOGRAM_UPDATE = "FENNEC_GLOBALHISTORY_UPDATE_MS";
    private static final String TELEMETRY_HISTOGRAM_BUILD_VISITED_LINK = "FENNEC_GLOBALHISTORY_VISITED_BUILD_MS";
    private static final GlobalHistory sInstance = new GlobalHistory();
    private static final long BATCHING_DELAY_MS = 100L;
    private final Handler mHandler = ThreadUtils.getBackgroundHandler();
    private final Queue<String> mPendingUris = new LinkedList<String>();
    private SoftReference<Set<String>> mVisitedCache = new SoftReference<Object>(null);
    private final Runnable mNotifierRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string2;
            HashSet<String> hashSet = (HashSet<String>)GlobalHistory.this.mVisitedCache.get();
            if (hashSet == null) {
                Log.w((String)GlobalHistory.LOGTAG, (String)"Rebuilding visited link set...");
                long l = SystemClock.uptimeMillis();
                Cursor cursor = BrowserDB.getAllVisitedHistory(GeckoAppShell.getContext().getContentResolver());
                if (cursor == null) {
                    return;
                }
                try {
                    hashSet = new HashSet<String>();
                    if (cursor.moveToFirst()) {
                        do {
                            hashSet.add(cursor.getString(0));
                        } while (cursor.moveToNext());
                    }
                    GlobalHistory.this.mVisitedCache = new SoftReference(hashSet);
                    long l2 = SystemClock.uptimeMillis();
                    long l3 = l2 - l;
                    Telemetry.addToHistogram(GlobalHistory.TELEMETRY_HISTOGRAM_BUILD_VISITED_LINK, (int)Math.min(l3, Integer.MAX_VALUE));
                }
                finally {
                    cursor.close();
                }
            }
            while ((string2 = (String)GlobalHistory.this.mPendingUris.poll()) != null) {
                if (!hashSet.contains(string2)) continue;
                GeckoAppShell.notifyUriVisited(string2);
            }
            GlobalHistory.this.mProcessing = false;
        }
    };
    private boolean mProcessing;

    static GlobalHistory getInstance() {
        return sInstance;
    }

    private GlobalHistory() {
    }

    public void addToGeckoOnly(String string2) {
        Set<String> set = this.mVisitedCache.get();
        if (set != null) {
            set.add(string2);
        }
        GeckoAppShell.notifyUriVisited(string2);
    }

    public void add(String string2) {
        long l = SystemClock.uptimeMillis();
        BrowserDB.updateVisitedHistory(GeckoAppShell.getContext().getContentResolver(), string2);
        long l2 = SystemClock.uptimeMillis();
        long l3 = l2 - l;
        Telemetry.addToHistogram(TELEMETRY_HISTOGRAM_ADD, (int)Math.min(l3, Integer.MAX_VALUE));
        this.addToGeckoOnly(string2);
    }

    public void update(String string2, String string3) {
        long l = SystemClock.uptimeMillis();
        BrowserDB.updateHistoryTitle(GeckoAppShell.getContext().getContentResolver(), string2, string3);
        long l2 = SystemClock.uptimeMillis();
        long l3 = l2 - l;
        Telemetry.addToHistogram(TELEMETRY_HISTOGRAM_UPDATE, (int)Math.min(l3, Integer.MAX_VALUE));
    }

    public void checkUriVisited(final String string2) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GlobalHistory.this.mPendingUris.add(string2);
                if (GlobalHistory.this.mProcessing) {
                    return;
                }
                GlobalHistory.this.mProcessing = true;
                GlobalHistory.this.mHandler.postDelayed(GlobalHistory.this.mNotifierRunnable, 100L);
            }
        });
    }
}

