/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.text.TextUtils;
import org.json.JSONObject;

public class SiteIdentity {
    private SecurityMode mSecurityMode;
    private MixedMode mMixedMode;
    private TrackingMode mTrackingMode;
    private String mHost;
    private String mOwner;
    private String mSupplemental;
    private String mVerifier;
    private String mEncrypted;

    public SiteIdentity() {
        this.resetIdentityData();
        this.mMixedMode = MixedMode.UNKNOWN;
        this.mTrackingMode = TrackingMode.UNKNOWN;
    }

    private void resetIdentityData() {
        this.mSecurityMode = SecurityMode.UNKNOWN;
        this.mHost = null;
        this.mOwner = null;
        this.mSupplemental = null;
        this.mVerifier = null;
        this.mEncrypted = null;
    }

    void update(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("mode");
            try {
                this.mMixedMode = MixedMode.fromString(jSONObject2.getString("mixed"));
            }
            catch (Exception exception) {
                this.mMixedMode = MixedMode.UNKNOWN;
            }
            try {
                this.mTrackingMode = TrackingMode.fromString(jSONObject2.getString("tracking"));
            }
            catch (Exception exception) {
                this.mTrackingMode = TrackingMode.UNKNOWN;
            }
            try {
                this.mSecurityMode = SecurityMode.fromString(jSONObject2.getString("identity"));
            }
            catch (Exception exception) {
                this.resetIdentityData();
                return;
            }
            try {
                this.mHost = jSONObject.getString("host");
                this.mOwner = jSONObject.optString("owner", null);
                this.mSupplemental = jSONObject.optString("supplemental", null);
                this.mVerifier = jSONObject.getString("verifier");
                this.mEncrypted = jSONObject.getString("encrypted");
            }
            catch (Exception exception) {
                this.resetIdentityData();
            }
        }
        catch (Exception exception) {
            this.resetIdentityData();
            this.mMixedMode = MixedMode.UNKNOWN;
            this.mTrackingMode = TrackingMode.UNKNOWN;
        }
    }

    public SecurityMode getSecurityMode() {
        return this.mSecurityMode;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getSupplemental() {
        return this.mSupplemental;
    }

    public String getVerifier() {
        return this.mVerifier;
    }

    public String getEncrypted() {
        return this.mEncrypted;
    }

    public MixedMode getMixedMode() {
        return this.mMixedMode;
    }

    public TrackingMode getTrackingMode() {
        return this.mTrackingMode;
    }

    public static enum TrackingMode {
        UNKNOWN("unknown"),
        TRACKING_CONTENT_BLOCKED("tracking_content_blocked"),
        TRACKING_CONTENT_LOADED("tracking_content_loaded");

        private final String mId;

        private TrackingMode(String string3) {
            this.mId = string3;
        }

        public static TrackingMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to TrackingMode");
            }
            for (TrackingMode trackingMode : TrackingMode.values()) {
                if (!TextUtils.equals((CharSequence)trackingMode.mId, (CharSequence)string2.toLowerCase())) continue;
                return trackingMode;
            }
            throw new IllegalArgumentException("Could not convert String id to TrackingMode");
        }

        public String toString() {
            return this.mId;
        }
    }

    public static enum MixedMode {
        UNKNOWN("unknown"),
        MIXED_CONTENT_BLOCKED("mixed_content_blocked"),
        MIXED_CONTENT_LOADED("mixed_content_loaded");

        private final String mId;

        private MixedMode(String string3) {
            this.mId = string3;
        }

        public static MixedMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to MixedMode");
            }
            for (MixedMode mixedMode : MixedMode.values()) {
                if (!TextUtils.equals((CharSequence)mixedMode.mId, (CharSequence)string2.toLowerCase())) continue;
                return mixedMode;
            }
            throw new IllegalArgumentException("Could not convert String id to MixedMode");
        }

        public String toString() {
            return this.mId;
        }
    }

    public static enum SecurityMode {
        UNKNOWN("unknown"),
        IDENTIFIED("identified"),
        VERIFIED("verified");

        private final String mId;

        private SecurityMode(String string3) {
            this.mId = string3;
        }

        public static SecurityMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to SiteIdentity");
            }
            for (SecurityMode securityMode : SecurityMode.values()) {
                if (!TextUtils.equals((CharSequence)securityMode.mId, (CharSequence)string2.toLowerCase())) continue;
                return securityMode;
            }
            throw new IllegalArgumentException("Could not convert String id to SiteIdentity");
        }

        public String toString() {
            return this.mId;
        }
    }
}

