/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.util.Arrays;
import java.util.Calendar;
import org.mozilla.gecko.background.fxa.FxAccountUtils;

public class FxAccountAgeLockoutHelper {
    private static final String LOG_TAG = FxAccountAgeLockoutHelper.class.getSimpleName();
    protected static long ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK = 0L;

    public static synchronized boolean isLockedOut(long l) {
        if (ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK == 0L) {
            return false;
        }
        long l2 = l - ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK;
        boolean bl = l2 < 900000L;
        FxAccountUtils.pii(LOG_TAG, "Checking if locked out: it's been " + l2 + "ms " + "since last lockout, so " + (bl ? "yes." : "no."));
        return bl;
    }

    public static synchronized void lockOut(long l) {
        FxAccountUtils.pii(LOG_TAG, "Locking out at time: " + l);
        ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK = Math.max(l, ELAPSED_REALTIME_OF_LAST_FAILED_AGE_CHECK);
    }

    public static boolean passesAgeCheck(int n) {
        boolean bl;
        int n2 = Calendar.getInstance().get(1);
        int n3 = n2 - n;
        boolean bl2 = bl = n3 >= 14;
        if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            FxAccountUtils.pii(LOG_TAG, "Age check " + (bl ? "passes" : "fails") + ": age is " + n3 + " = " + n2 + " - " + n);
        }
        return bl;
    }

    public static boolean passesAgeCheck(String string2, String[] stringArray) {
        Integer n;
        if (string2 == null) {
            throw new IllegalArgumentException("yearText must not be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("yearItems must not be null");
        }
        if (!Arrays.asList(stringArray).contains(string2)) {
            FxAccountUtils.pii(LOG_TAG, "Failed age check: year text was not found in item list.");
            return false;
        }
        try {
            n = Integer.valueOf(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            FxAccountUtils.pii(LOG_TAG, "Passed age check: year text was found in item list but was not a number.");
            return true;
        }
        return FxAccountAgeLockoutHelper.passesAgeCheck(n);
    }
}

