/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.accounts.Account;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteClientsDialogFragment;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeExpandableListView;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.RemoteTabsExpandableListState;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TransitionAwareCursorLoaderCallbacks;
import org.mozilla.gecko.widget.GeckoSwipeRefreshLayout;

public class RemoteTabsExpandableListFragment
extends HomeFragment
implements RemoteClientsDialogFragment.RemoteClientsListener {
    private static final String LOGTAG = "GeckoRemoteTabsExpList";
    private static final int LOADER_ID_REMOTE_TABS = 0;
    private static final String DIALOG_TAG_REMOTE_TABS = "dialog_tag_remote_tabs";
    private static final String[] STAGES_TO_SYNC_ON_REFRESH = new String[]{"clients", "tabs"};
    private static RemoteTabsExpandableListState sState;
    private RemoteTabsExpandableListAdapter mAdapter;
    private final ArrayList<TabsAccessor.RemoteClient> mHiddenClients = new ArrayList();
    private HomeExpandableListView mList;
    private View mEmptyView;
    private View mFooterView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private GeckoSwipeRefreshLayout mRefreshLayout;
    private RemoteTabsSyncListener mSyncStatusListener;

    public static RemoteTabsExpandableListFragment newInstance() {
        return new RemoteTabsExpandableListFragment();
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_remote_tabs_list_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mRefreshLayout = (GeckoSwipeRefreshLayout)view.findViewById(R.id.remote_tabs_refresh_layout);
        this.mRefreshLayout.setColorScheme(R.color.swipe_refresh_orange, R.color.swipe_refresh_white, R.color.swipe_refresh_orange, R.color.swipe_refresh_white);
        this.mRefreshLayout.setOnRefreshListener(new RemoteTabsRefreshListener());
        this.mSyncStatusListener = new RemoteTabsSyncListener();
        FirefoxAccounts.addSyncStatusListener(this.mSyncStatusListener);
        this.mList = (HomeExpandableListView)view.findViewById(R.id.list);
        this.mList.setTag("remote_tabs");
        this.mList.setOnChildClickListener(new ExpandableListView.OnChildClickListener(){

            public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
                ExpandableListAdapter expandableListAdapter = expandableListView.getExpandableListAdapter();
                TabsAccessor.RemoteTab remoteTab = (TabsAccessor.RemoteTab)expandableListAdapter.getChild(n, n2);
                if (remoteTab == null) {
                    return false;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM);
                RemoteTabsExpandableListFragment.this.mUrlOpenListener.onUrlOpen(remoteTab.url, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
                return true;
            }
        });
        this.mList.setOnGroupClickListener(new ExpandableListView.OnGroupClickListener(){

            public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
                ExpandableListAdapter expandableListAdapter = expandableListView.getExpandableListAdapter();
                TabsAccessor.RemoteClient remoteClient = (TabsAccessor.RemoteClient)expandableListAdapter.getGroup(n);
                if (remoteClient != null) {
                    sState.setClientCollapsed(remoteClient.guid, RemoteTabsExpandableListFragment.this.mList.isGroupExpanded(n));
                }
                return false;
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.ExpandableFactory(){

            @Override
            public HomeContextMenuInfo makeInfoForAdapter(View view, int n, long l, ExpandableListAdapter expandableListAdapter) {
                long l2 = RemoteTabsExpandableListFragment.this.mList.getExpandableListPosition(n);
                int n2 = ExpandableListView.getPackedPositionGroup((long)l2);
                int n3 = ExpandableListView.getPackedPositionType((long)l2);
                if (n3 == 1) {
                    int n4 = ExpandableListView.getPackedPositionChild((long)l2);
                    TabsAccessor.RemoteTab remoteTab = (TabsAccessor.RemoteTab)expandableListAdapter.getChild(n2, n4);
                    HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                    homeContextMenuInfo.url = remoteTab.url;
                    homeContextMenuInfo.title = remoteTab.title;
                    return homeContextMenuInfo;
                }
                if (n3 == 0) {
                    TabsAccessor.RemoteClient remoteClient = (TabsAccessor.RemoteClient)expandableListAdapter.getGroup(n2);
                    RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = new RemoteTabsClientContextMenuInfo(view, n, l, remoteClient);
                    return remoteTabsClientContextMenuInfo;
                }
                return null;
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mEmptyView = null;
        if (this.mSyncStatusListener != null) {
            FirefoxAccounts.removeSyncStatusListener(this.mSyncStatusListener);
            this.mSyncStatusListener = null;
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        if (sState == null) {
            sState = new RemoteTabsExpandableListState(GeckoSharedPrefs.forProfile((Context)this.getActivity()));
        }
        this.mFooterView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.home_remote_tabs_hidden_devices_footer, (ViewGroup)this.mList, false);
        View view = this.mFooterView.findViewById(R.id.hidden_devices);
        view.setClickable(true);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RemoteClientsDialogFragment remoteClientsDialogFragment = RemoteClientsDialogFragment.newInstance(RemoteTabsExpandableListFragment.this.getResources().getString(R.string.home_remote_tabs_hidden_devices_title), RemoteTabsExpandableListFragment.this.getResources().getString(R.string.home_remote_tabs_unhide_selected_devices), RemoteClientsDialogFragment.ChoiceMode.MULTIPLE, new ArrayList<TabsAccessor.RemoteClient>(RemoteTabsExpandableListFragment.this.mHiddenClients));
                remoteClientsDialogFragment.setTargetFragment(RemoteTabsExpandableListFragment.this, 0);
                remoteClientsDialogFragment.show(RemoteTabsExpandableListFragment.this.getActivity().getSupportFragmentManager(), RemoteTabsExpandableListFragment.DIALOG_TAG_REMOTE_TABS);
            }
        });
        this.mList.addFooterView(this.mFooterView, null, true);
        this.mAdapter = new RemoteTabsExpandableListAdapter(R.layout.home_remote_tabs_group, R.layout.home_remote_tabs_child, null);
        this.mList.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mList.removeFooterView(this.mFooterView);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_remote_tabs_client_contextmenu, (Menu)contextMenu);
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        contextMenu.setHeaderTitle((CharSequence)remoteTabsClientContextMenuInfo.client.name);
        boolean bl = sState.isClientHidden(remoteTabsClientContextMenuInfo.client.guid);
        MenuItem menuItem = contextMenu.findItem(bl ? R.id.home_remote_tabs_hide_client : R.id.home_remote_tabs_show_client);
        menuItem.setVisible(false);
    }

    @Override
    public boolean onContextItemSelected(MenuItem menuItem) {
        if (super.onContextItemSelected(menuItem)) {
            return true;
        }
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            return false;
        }
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        int n = menuItem.getItemId();
        if (n == R.id.home_remote_tabs_hide_client) {
            sState.setClientHidden(remoteTabsClientContextMenuInfo.client.guid, true);
            this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
            return true;
        }
        if (n == R.id.home_remote_tabs_show_client) {
            sState.setClientHidden(remoteTabsClientContextMenuInfo.client.guid, false);
            this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
            return true;
        }
        return false;
    }

    private void updateUiFromClients(List<TabsAccessor.RemoteClient> list, List<TabsAccessor.RemoteClient> list2) {
        TabsAccessor.RemoteClient remoteClient;
        TextView textView;
        boolean bl = false;
        if (list2 == null || list2.isEmpty()) {
            this.mList.removeFooterView(this.mFooterView);
        } else {
            bl = true;
            textView = (TextView)this.mFooterView.findViewById(R.id.hidden_devices);
            if (list2.size() == 1) {
                textView.setText((CharSequence)this.getResources().getString(R.string.home_remote_tabs_one_hidden_device));
            } else {
                textView.setText((CharSequence)this.getResources().getString(R.string.home_remote_tabs_many_hidden_devices, new Object[]{list2.size()}));
            }
            if (this.mList.getFooterViewsCount() < 1) {
                this.mList.addFooterView(this.mFooterView);
            }
        }
        if (list != null && !list.isEmpty()) {
            bl = true;
            int n = Math.min(this.mList.getExpandableListAdapter().getGroupCount(), list.size());
            for (int i = 0; i < n; ++i) {
                remoteClient = list.get(i);
                if (sState.isClientCollapsed(remoteClient.guid)) {
                    this.mList.collapseGroup(i);
                    continue;
                }
                this.mList.expandGroup(i);
            }
        }
        if (bl) {
            return;
        }
        if (this.mEmptyView == null) {
            textView = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = textView.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_remote_tabs_empty);
            remoteClient = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            remoteClient.setText(R.string.home_remote_tabs_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    @Override
    public void onClients(List<TabsAccessor.RemoteClient> list) {
        for (TabsAccessor.RemoteClient remoteClient : list) {
            sState.setClientHidden(remoteClient.guid, false);
            sState.setClientCollapsed(remoteClient.guid, false);
        }
        this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    protected static class RemoteTabsClientContextMenuInfo
    extends HomeContextMenuInfo {
        protected final TabsAccessor.RemoteClient client;

        public RemoteTabsClientContextMenuInfo(View view, int n, long l, TabsAccessor.RemoteClient remoteClient) {
            super(view, n, l);
            this.client = remoteClient;
        }
    }

    private class RemoteTabsSyncListener
    implements FirefoxAccounts.SyncStatusListener {
        private RemoteTabsSyncListener() {
        }

        @Override
        public Context getContext() {
            return RemoteTabsExpandableListFragment.this.getActivity();
        }

        @Override
        public Account getAccount() {
            return FirefoxAccounts.getFirefoxAccount(this.getContext());
        }

        @Override
        public void onSyncStarted() {
        }

        @Override
        public void onSyncFinished() {
            RemoteTabsExpandableListFragment.this.mRefreshLayout.setRefreshing(false);
        }
    }

    private class RemoteTabsRefreshListener
    implements GeckoSwipeRefreshLayout.OnRefreshListener {
        private RemoteTabsRefreshListener() {
        }

        @Override
        public void onRefresh() {
            if (FirefoxAccounts.firefoxAccountsExist((Context)RemoteTabsExpandableListFragment.this.getActivity())) {
                Account account = FirefoxAccounts.getFirefoxAccount((Context)RemoteTabsExpandableListFragment.this.getActivity());
                FirefoxAccounts.requestSync(account, FirefoxAccounts.FORCE, STAGES_TO_SYNC_ON_REFRESH, null);
            } else {
                Log.wtf((String)RemoteTabsExpandableListFragment.LOGTAG, (String)"No Firefox Account found; this should never happen. Ignoring.");
                RemoteTabsExpandableListFragment.this.mRefreshLayout.setRefreshing(false);
            }
        }
    }

    private class CursorLoaderCallbacks
    extends TransitionAwareCursorLoaderCallbacks {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new RemoteTabsCursorLoader((Context)RemoteTabsExpandableListFragment.this.getActivity());
        }

        @Override
        public void onLoadFinishedAfterTransitions(Loader<Cursor> loader, Cursor cursor) {
            List<TabsAccessor.RemoteClient> list = TabsAccessor.getClientsFromCursor(cursor);
            RemoteTabsExpandableListFragment.this.mHiddenClients.clear();
            Iterator<TabsAccessor.RemoteClient> iterator = list.iterator();
            while (iterator.hasNext()) {
                TabsAccessor.RemoteClient remoteClient = iterator.next();
                if (!sState.isClientHidden(remoteClient.guid)) continue;
                iterator.remove();
                RemoteTabsExpandableListFragment.this.mHiddenClients.add(remoteClient);
            }
            RemoteTabsExpandableListFragment.this.mAdapter.replaceClients(list);
            RemoteTabsExpandableListFragment.this.updateUiFromClients(list, RemoteTabsExpandableListFragment.this.mHiddenClients);
        }

        @Override
        public void onLoaderReset(Loader<Cursor> loader) {
            super.onLoaderReset(loader);
            RemoteTabsExpandableListFragment.this.mAdapter.replaceClients(null);
        }
    }

    private static class RemoteTabsCursorLoader
    extends SimpleCursorLoader {
        public RemoteTabsCursorLoader(Context context) {
            super(context);
        }

        @Override
        public Cursor loadCursor() {
            return TabsAccessor.getRemoteTabsCursor(this.getContext());
        }
    }
}

