/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.ActionBar;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.preference.TwoStatePreference;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoActivityStatus;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RestrictedProfiles;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.preferences.AndroidImportPreference;
import org.mozilla.gecko.preferences.ClearOnShutdownPref;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.FontSizePreference;
import org.mozilla.gecko.preferences.GeckoPreferenceFragment;
import org.mozilla.gecko.preferences.LinkPreference;
import org.mozilla.gecko.preferences.PanelsPreferenceCategory;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.FloatingHintEditText;

public class GeckoPreferences
extends PreferenceActivity
implements GeckoActivityStatus,
GeckoEventListener,
Preference.OnPreferenceChangeListener,
SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String LOGTAG = "GeckoPreferences";
    private static final boolean NO_TRANSITIONS = HardwareUtils.IS_KINDLE_DEVICE;
    public static final String NON_PREF_PREFIX = "android.not_a_preference.";
    public static final String INTENT_EXTRA_RESOURCES = "resource";
    public static String PREFS_HEALTHREPORT_UPLOAD_ENABLED = "android.not_a_preference.healthreport.uploadEnabled";
    private static boolean sIsCharEncodingEnabled;
    private boolean mInitialized;
    private int mPrefsRequestId;
    private PanelsPreferenceCategory mPanelsPreferenceCategory;
    private static final String PREFS_SEARCH_RESTORE_DEFAULTS = "android.not_a_preference.search.restore_defaults";
    private static final String PREFS_DATA_REPORTING_PREFERENCES = "android.not_a_preference.datareporting.preferences";
    private static final String PREFS_TELEMETRY_ENABLED = "toolkit.telemetry.enabled";
    private static final String PREFS_CRASHREPORTER_ENABLED = "datareporting.crashreporter.submitEnabled";
    private static final String PREFS_MENU_CHAR_ENCODING = "browser.menu.showCharacterEncoding";
    private static final String PREFS_MP_ENABLED = "privacy.masterpassword.enabled";
    private static final String PREFS_UPDATER_AUTODOWNLOAD = "app.update.autodownload";
    private static final String PREFS_GEO_REPORTING = "android.not_a_preference.app.geo.reportdata";
    private static final String PREFS_GEO_LEARN_MORE = "android.not_a_preference.geo.learn_more";
    private static final String PREFS_HEALTHREPORT_LINK = "android.not_a_preference.healthreport.link";
    private static final String PREFS_DEVTOOLS_REMOTE_ENABLED = "devtools.debugger.remote-enabled";
    private static final String PREFS_DISPLAY_REFLOW_ON_ZOOM = "browser.zoom.reflowOnZoom";
    private static final String PREFS_SYNC = "android.not_a_preference.sync";
    private static final String PREFS_TRACKING_PROTECTION = "privacy.trackingprotection.enabled";
    private static final String PREFS_TRACKING_PROTECTION_LEARN_MORE = "android.not_a_preference.trackingprotection.learn_more";
    private static final String ACTION_STUMBLER_UPLOAD_PREF = "org.mozilla.fennec.STUMBLER_PREF";
    private static final String PREFS_BROWSER_LOCALE = "locale";
    public static final String PREFS_RESTORE_SESSION = "android.not_a_preference.restoreSession3";
    public static final String PREFS_SUGGESTED_SITES = "android.not_a_preference.home_suggested_sites";
    private static final int REQUEST_CODE_PREF_SCREEN = 5;
    private static final int RESULT_CODE_EXIT_SETTINGS = 6;
    public static final int RESULT_CODE_LOCALE_DID_CHANGE = 7;
    private Locale lastLocale = Locale.getDefault();
    private boolean localeSwitchingIsEnabled;
    private final int DIALOG_CREATE_MASTER_PASSWORD = 0;
    private final int DIALOG_REMOVE_MASTER_PASSWORD = 1;
    private final Map<String, PrefHandler> handlers = new HashMap<String, PrefHandler>(){
        {
            this.put("android.not_a_preference.history.clear_on_exit", new ClearOnShutdownPref());
            this.put("android.not_a_preference.import_android", new AndroidImportPreference.Handler());
        }
    };

    private void startActivityForResultChoosingTransition(Intent intent, int n) {
        this.startActivityForResult(intent, n);
        if (NO_TRANSITIONS) {
            this.overridePendingTransition(0, 0);
        }
    }

    private void finishChoosingTransition() {
        this.finish();
        if (NO_TRANSITIONS) {
            this.overridePendingTransition(0, 0);
        }
    }

    private void updateActionBarTitle(int n) {
        String string2;
        if (AppConstants.Versions.feature14Plus && (string2 = this.getString(n)) != null) {
            Log.v((String)LOGTAG, (String)("Setting action bar title to " + string2));
            ActionBar actionBar = this.getActionBar();
            if (actionBar != null) {
                actionBar.setTitle((CharSequence)string2);
            }
        }
    }

    private void updateTitle(String string2) {
        if (string2 != null) {
            Log.v((String)LOGTAG, (String)("Setting activity title to " + string2));
            this.setTitle(string2);
        }
    }

    private void updateTitle(int n) {
        this.updateTitle(this.getString(n));
    }

    private void updateBreadcrumbTitle(int n) {
        String string2 = this.getString(n);
        this.showBreadCrumbs(string2, string2);
    }

    private void updateTitleForPrefsResource(int n) {
        if (AppConstants.Versions.feature11Plus && this.isMultiPane()) {
            int n2 = this.getIntent().getIntExtra(":android:show_fragment_title", -1);
            if (n == R.xml.preferences) {
                this.updateActionBarTitle(R.string.settings_title);
            }
            this.updateTitle(n2);
            this.updateBreadcrumbTitle(n2);
            return;
        }
        int n3 = -1;
        if (n == R.xml.preferences) {
            n3 = R.string.settings_title;
        } else if (n == R.xml.preferences_locale) {
            n3 = R.string.pref_category_language;
        } else if (n == R.xml.preferences_vendor) {
            n3 = R.string.pref_category_vendor;
        } else if (n == R.xml.preferences_customize) {
            n3 = R.string.pref_category_customize;
        }
        if (n3 != -1) {
            this.updateTitle(n3);
        }
    }

    private void onLocaleChanged(Locale locale) {
        Log.d((String)LOGTAG, (String)("onLocaleChanged: " + locale));
        BrowserLocaleManager.getInstance().updateConfiguration(this.getApplicationContext(), locale);
        this.lastLocale = locale;
        if (AppConstants.Versions.feature11Plus && this.isMultiPane()) {
            this.invalidateHeaders();
            FragmentManager fragmentManager = this.getFragmentManager();
            int n = this.getResources().getIdentifier("android:id/prefs", null, null);
            Fragment fragment = fragmentManager.findFragmentById(n);
            if (fragment != null) {
                fragmentManager.beginTransaction().disallowAddToBackStack().detach(fragment).attach(fragment).commitAllowingStateLoss();
            } else {
                Log.e((String)LOGTAG, (String)"No prefs fragment to reattach!");
            }
            if (this.onIsMultiPane()) {
                this.updateActionBarTitle(R.string.settings_title);
            }
            this.updateTitle(R.string.pref_header_language);
            this.updateBreadcrumbTitle(R.string.pref_header_language);
            this.setResult(7);
            return;
        }
        this.refreshSuggestedSites();
        Intent intent = (Intent)this.getIntent().clone();
        intent.addFlags(65536);
        this.startActivityForResultChoosingTransition(intent, 5);
        this.setResult(7);
        this.finishChoosingTransition();
    }

    private void checkLocale() {
        Locale locale = Locale.getDefault();
        Log.v((String)LOGTAG, (String)("Checking locale: " + locale + " vs " + this.lastLocale));
        if (locale.equals(this.lastLocale)) {
            return;
        }
        this.onLocaleChanged(locale);
    }

    protected void onCreate(Bundle bundle) {
        String string2;
        RestrictedProfiles.initWithProfile(GeckoProfile.get((Context)this));
        this.checkLocale();
        this.localeSwitchingIsEnabled = BrowserLocaleManager.getInstance().isEnabled();
        if (AppConstants.Versions.feature11Plus) {
            if (!this.getIntent().hasExtra(":android:show_fragment")) {
                this.setupTopLevelFragmentIntent();
                this.updateTitle(this.getString(R.string.pref_header_customize));
            }
            if (this.onIsMultiPane()) {
                this.updateActionBarTitle(R.string.settings_title);
                if (Build.VERSION.SDK_INT < 13) {
                    this.localeSwitchingIsEnabled = false;
                }
            }
        }
        super.onCreate(bundle);
        Bundle bundle2 = this.getIntent().getExtras();
        if (AppConstants.Versions.preHC) {
            this.getPreferenceManager().setSharedPreferencesName("GeckoApp");
            int n = 0;
            if (bundle2 != null && bundle2.containsKey(INTENT_EXTRA_RESOURCES)) {
                string2 = bundle2.getString(INTENT_EXTRA_RESOURCES);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.SETTINGS, string2);
                if (string2 != null && (n = this.getResources().getIdentifier(string2, "xml", this.getPackageName())) == 0) {
                    Log.e((String)LOGTAG, (String)("No resource found named " + string2));
                }
            }
            if (n == 0) {
                Log.e((String)LOGTAG, (String)"Displaying default settings.");
                n = R.xml.preferences;
                Telemetry.startUISession(TelemetryContract.Session.SETTINGS);
            }
            this.updateTitleForPrefsResource(n);
            this.addPreferencesFromResource(n);
        }
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Sanitize:Finished");
        ListView listView = this.getListView();
        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                ListAdapter listAdapter = ((ListView)adapterView).getAdapter();
                Object object = listAdapter.getItem(n);
                if (object instanceof CustomListPreference && object instanceof View.OnLongClickListener) {
                    View.OnLongClickListener onLongClickListener = (View.OnLongClickListener)object;
                    return onLongClickListener.onLongClick(view);
                }
                return false;
            }
        });
        if (AppConstants.Versions.feature14Plus && (string2 = this.getActionBar()) != null) {
            string2.setHomeButtonEnabled(true);
        }
        if (bundle2 != null && bundle2.containsKey("datareporting-notification")) {
            string2 = (NotificationManager)this.getSystemService("notification");
            string2.cancel("datareporting-notification".hashCode());
        }
    }

    private void setupTopLevelFragmentIntent() {
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        Bundle bundle2 = new Bundle();
        if (bundle != null && bundle.containsKey(INTENT_EXTRA_RESOURCES)) {
            String string2 = bundle.getString(INTENT_EXTRA_RESOURCES);
            bundle2.putString(INTENT_EXTRA_RESOURCES, string2);
        } else if (!this.onIsMultiPane()) {
            bundle2.putString(INTENT_EXTRA_RESOURCES, "preferences");
        } else {
            bundle2.putString(INTENT_EXTRA_RESOURCES, "preferences_customize_tablet");
        }
        intent.putExtra(":android:show_fragment", GeckoPreferenceFragment.class.getName());
        intent.putExtra(":android:show_fragment_args", bundle2);
    }

    public boolean isValidFragment(String string2) {
        return GeckoPreferenceFragment.class.getName().equals(string2);
    }

    public void onBuildHeaders(List<PreferenceActivity.Header> list) {
        if (this.onIsMultiPane()) {
            this.loadHeadersFromResource(R.xml.preference_headers, list);
            if (!this.localeSwitchingIsEnabled) {
                for (PreferenceActivity.Header header : list) {
                    if (header.id != (long)R.id.pref_header_language) continue;
                    list.remove(header);
                    break;
                }
            }
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        if (!bl || this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        if (AppConstants.Versions.preHC) {
            PreferenceScreen preferenceScreen = this.getPreferenceScreen();
            this.mPrefsRequestId = this.setupPreferences((PreferenceGroup)preferenceScreen);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (NO_TRANSITIONS) {
            this.overridePendingTransition(0, 0);
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, "settings");
    }

    protected void onDestroy() {
        super.onDestroy();
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Sanitize:Finished");
        if (this.mPrefsRequestId > 0) {
            PrefsHelper.removeObserver(this.mPrefsRequestId);
        }
        if (AppConstants.Versions.preHC && this.getIntent().getExtras() == null) {
            Telemetry.stopUISession(TelemetryContract.Session.SETTINGS);
        }
    }

    public void onPause() {
        if (AppConstants.Versions.feature11Plus && this.isMultiPane()) {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
        super.onPause();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityPause(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityResume(this);
        }
        if (AppConstants.Versions.feature11Plus && this.isMultiPane()) {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
    }

    public void startActivity(Intent intent) {
        this.startActivityForResultChoosingTransition(intent, 5);
    }

    public void startWithFragment(String string2, Bundle bundle, Fragment fragment, int n, int n2, int n3) {
        Log.v((String)LOGTAG, (String)("Starting with fragment: " + string2 + ", title " + n2));
        Intent intent = this.onBuildStartFragmentIntent(string2, bundle, n2, n3);
        if (fragment == null) {
            this.startActivityForResultChoosingTransition(intent, 5);
        } else {
            fragment.startActivityForResult(intent, n);
            if (NO_TRANSITIONS) {
                this.overridePendingTransition(0, 0);
            }
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.checkLocale();
        switch (n) {
            case 5: {
                switch (n2) {
                    case 6: {
                        this.updateActionBarTitle(R.string.settings_title);
                        this.setResult(6);
                        this.finishChoosingTransition();
                    }
                }
            }
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Sanitize:Finished")) {
                boolean bl = jSONObject.getBoolean("success");
                int n = bl ? R.string.private_data_success : R.string.private_data_fail;
                GeckoPreferences geckoPreferences = this;
                ThreadUtils.postToUiThread((Runnable)new Runnable((Context)geckoPreferences, n){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ int val$stringRes;
                    {
                        this.val$context = context;
                        this.val$stringRes = n;
                    }

                    @Override
                    public void run() {
                        Toast.makeText((Context)this.val$context, (int)this.val$stringRes, (int)0).show();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public int setupPreferences(PreferenceGroup preferenceGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.setupPreferences(preferenceGroup, arrayList);
        return this.getGeckoPreferences(preferenceGroup, arrayList);
    }

    private void setupPreferences(PreferenceGroup preferenceGroup, ArrayList<String> arrayList) {
        for (int i = 0; i < preferenceGroup.getPreferenceCount(); ++i) {
            Preference preference = preferenceGroup.getPreference(i);
            if (!this.localeSwitchingIsEnabled && "preferences_locale".equals(preference.getExtras().getString(INTENT_EXTRA_RESOURCES))) {
                preferenceGroup.removePreference(preference);
                --i;
                continue;
            }
            String string2 = preference.getKey();
            if (preference instanceof PreferenceGroup) {
                if (!PREFS_DATA_REPORTING_PREFERENCES.equals(string2) && preference instanceof PanelsPreferenceCategory) {
                    this.mPanelsPreferenceCategory = (PanelsPreferenceCategory)preference;
                }
                this.setupPreferences((PreferenceGroup)preference, arrayList);
                continue;
            }
            preference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
            if (!AppConstants.MOZ_STUMBLER_BUILD_TIME_ENABLED && (PREFS_GEO_REPORTING.equals(string2) || PREFS_GEO_LEARN_MORE.equals(string2))) {
                preferenceGroup.removePreference(preference);
                --i;
                continue;
            }
            if (PREFS_DEVTOOLS_REMOTE_ENABLED.equals(string2)) {
                if (!RestrictedProfiles.isAllowed((Context)this, RestrictedProfiles.Restriction.DISALLOW_REMOTE_DEBUGGING)) {
                    preferenceGroup.removePreference(preference);
                    --i;
                    continue;
                }
            } else {
                Object object;
                if (PREFS_RESTORE_SESSION.equals(string2) || PREFS_BROWSER_LOCALE.equals(string2)) {
                    object = (ListPreference)preference;
                    CharSequence charSequence = object.getEntry();
                    object.setSummary(charSequence);
                    continue;
                }
                if (PREFS_SYNC.equals(string2) && !RestrictedProfiles.isAllowed((Context)this, RestrictedProfiles.Restriction.DISALLOW_MODIFY_ACCOUNTS)) {
                    preferenceGroup.removePreference(preference);
                    --i;
                    continue;
                }
                if (PREFS_SEARCH_RESTORE_DEFAULTS.equals(string2)) {
                    preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                        public boolean onPreferenceClick(Preference preference) {
                            GeckoPreferences.this.restoreDefaultSearchEngines();
                            Telemetry.sendUIEvent(TelemetryContract.Event.SEARCH_RESTORE_DEFAULTS, TelemetryContract.Method.LIST_ITEM);
                            return true;
                        }
                    });
                } else if (this.handlers.containsKey(string2) && !(object = this.handlers.get(string2)).setupPref((Context)this, preference)) {
                    preferenceGroup.removePreference(preference);
                    --i;
                    continue;
                }
            }
            if (!this.isGeckoPref(string2)) continue;
            arrayList.add(string2);
        }
    }

    private boolean isGeckoPref(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (string2.startsWith(NON_PREF_PREFIX)) {
            return false;
        }
        return !string2.equals(PREFS_BROWSER_LOCALE);
    }

    protected void restoreDefaultSearchEngines() {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:RestoreDefaults", null));
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:GetVisible", null));
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        switch (n) {
            case 16908332: {
                this.finishChoosingTransition();
                return true;
            }
        }
        if (n == R.id.restore_defaults) {
            this.restoreDefaultSearchEngines();
            Telemetry.sendUIEvent(TelemetryContract.Event.SEARCH_RESTORE_DEFAULTS, TelemetryContract.Method.MENU);
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public static void setCharEncodingState(boolean bl) {
        sIsCharEncodingEnabled = bl;
    }

    public static boolean getCharEncodingState() {
        return sIsCharEncodingEnabled;
    }

    public static void broadcastAction(Context context, Intent intent) {
        GeckoPreferences.fillIntentWithProfileInfo(context, intent);
        context.sendBroadcast(intent, "org.mozilla.fennec.permission.PER_ANDROID_PACKAGE");
    }

    public static void broadcastPrefAction(Context context, String string2, String string3, boolean bl) {
        Intent intent = new Intent(string2).putExtra("pref", string3).putExtra("branch", "GeckoApp").putExtra("enabled", bl);
        GeckoPreferences.broadcastAction(context, intent);
    }

    private static void fillIntentWithProfileInfo(Context context, Intent intent) {
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        if (geckoProfile != null) {
            intent.putExtra("profileName", geckoProfile.getName()).putExtra("profilePath", geckoProfile.getDir().getAbsolutePath());
        }
    }

    public static void broadcastHealthReportUploadPref(Context context, boolean bl) {
        GeckoPreferences.broadcastPrefAction(context, "org.mozilla.fennec.HEALTHREPORT_UPLOAD_PREF", PREFS_HEALTHREPORT_UPLOAD_ENABLED, bl);
    }

    public static void broadcastHealthReportUploadPref(Context context) {
        boolean bl = GeckoPreferences.getBooleanPref(context, PREFS_HEALTHREPORT_UPLOAD_ENABLED, true);
        GeckoPreferences.broadcastHealthReportUploadPref(context, bl);
    }

    public static void broadcastHealthReportPrune(Context context) {
        Intent intent = new Intent("org.mozilla.fennec.HEALTHREPORT_PRUNE");
        GeckoPreferences.broadcastAction(context, intent);
    }

    public static void broadcastStumblerPref(Context context, boolean bl) {
        Intent intent = new Intent(ACTION_STUMBLER_UPLOAD_PREF).putExtra("pref", PREFS_GEO_REPORTING).putExtra("branch", "GeckoApp").putExtra("enabled", bl).putExtra("moz_mozilla_api_key", "3b4d27dd-703d-4094-8398-4de2c763505a");
        if (GeckoAppShell.getGeckoInterface() != null) {
            intent.putExtra("user_agent", GeckoAppShell.getGeckoInterface().getDefaultUAString());
        }
        GeckoPreferences.broadcastAction(context, intent);
    }

    public static void broadcastStumblerPref(Context context) {
        boolean bl = GeckoPreferences.getBooleanPref(context, PREFS_GEO_REPORTING, false);
        GeckoPreferences.broadcastStumblerPref(context, bl);
    }

    public static boolean getBooleanPref(Context context, String string2, boolean bl) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        return sharedPreferences.getBoolean(string2, bl);
    }

    private boolean onLocaleSelected(final String string2, final String string3) {
        final Context context = this.getApplicationContext();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LocaleManager localeManager = BrowserLocaleManager.getInstance();
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    BrowserLocaleManager.getInstance().resetToSystemLocale(context);
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOCALE_BROWSER_RESET);
                } else {
                    if (null == localeManager.setSelectedLocale(context, string3)) {
                        localeManager.updateConfiguration(context, Locale.getDefault());
                    }
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOCALE_BROWSER_UNSELECTED, TelemetryContract.Method.NONE, string2 == null ? "unknown" : string2);
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOCALE_BROWSER_SELECTED, TelemetryContract.Method.NONE, string3);
                }
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GeckoPreferences.this.onLocaleChanged(Locale.getDefault());
                    }
                });
            }
        });
        return true;
    }

    private void refreshSuggestedSites() {
        ContentResolver contentResolver = this.getApplicationContext().getContentResolver();
        contentResolver.notifyChange(BrowserContract.SuggestedSites.CONTENT_URI, null);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        Log.d((String)LOGTAG, (String)("onConfigurationChanged: " + configuration.locale));
        if (this.lastLocale.equals(configuration.locale)) {
            Log.d((String)LOGTAG, (String)"Old locale same as new locale. Short-circuiting.");
            return;
        }
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        Locale locale = localeManager.onSystemConfigurationChanged((Context)this, this.getResources(), configuration, this.lastLocale);
        if (locale != null) {
            this.onLocaleChanged(locale);
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        if (PREFS_BROWSER_LOCALE.equals(string2)) {
            this.onLocaleSelected(Locales.getLanguageTag(this.lastLocale), sharedPreferences.getString(string2, null));
        } else if (PREFS_SUGGESTED_SITES.equals(string2)) {
            this.refreshSuggestedSites();
        }
    }

    public boolean onPreferenceChange(Preference preference, Object object) {
        Object object2;
        String string2 = preference.getKey();
        Log.i((String)LOGTAG, (String)("Changed " + string2 + " = " + object));
        Telemetry.sendUIEvent(TelemetryContract.Event.EDIT, TelemetryContract.Method.SETTINGS, string2);
        if (PREFS_MP_ENABLED.equals(string2)) {
            this.showDialog((Boolean)object != false ? 0 : 1);
            return false;
        }
        if (PREFS_BROWSER_LOCALE.equals(string2)) {
            return this.onLocaleSelected(Locales.getLanguageTag(this.lastLocale), (String)object);
        }
        if (PREFS_MENU_CHAR_ENCODING.equals(string2)) {
            GeckoPreferences.setCharEncodingState(((String)object).equals("true"));
        } else if (PREFS_UPDATER_AUTODOWNLOAD.equals(string2)) {
            UpdateServiceHelper.registerForUpdates((Context)this, (String)object);
        } else if (PREFS_HEALTHREPORT_UPLOAD_ENABLED.equals(string2)) {
            GeckoPreferences.broadcastHealthReportUploadPref((Context)this, (Boolean)object);
        } else if (PREFS_GEO_REPORTING.equals(string2)) {
            GeckoPreferences.broadcastStumblerPref((Context)this, (Boolean)object);
            object = (Boolean)object != false ? 1 : 0;
        } else if (this.handlers.containsKey(string2)) {
            object2 = this.handlers.get(string2);
            object2.onChange((Context)this, preference, object);
        }
        if (this.isGeckoPref(string2)) {
            PrefsHelper.setPref(string2, object);
        }
        if (preference instanceof ListPreference) {
            int n = ((ListPreference)preference).findIndexOfValue((String)object);
            CharSequence charSequence = ((ListPreference)preference).getEntries()[n];
            ((ListPreference)preference).setSummary(charSequence);
        } else if (preference instanceof LinkPreference) {
            this.setResult(6);
            this.finishChoosingTransition();
        } else if (preference instanceof FontSizePreference) {
            object2 = (FontSizePreference)preference;
            object2.setSummary((CharSequence)((FontSizePreference)((Object)object2)).getSavedFontSizeName());
        }
        return true;
    }

    private EditText getTextBox(int n) {
        FloatingHintEditText floatingHintEditText = new FloatingHintEditText((Context)this);
        int n2 = 1;
        floatingHintEditText.setInputType(n2 |= 0x80080);
        floatingHintEditText.setHint(n);
        return floatingHintEditText;
    }

    protected Dialog onCreateDialog(int n) {
        AlertDialog alertDialog;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        switch (n) {
            case 0: {
                final EditText editText = this.getTextBox(R.string.masterpassword_password);
                final EditText editText2 = this.getTextBox(R.string.masterpassword_confirm);
                linearLayout.addView((View)editText);
                linearLayout.addView((View)editText2);
                builder.setTitle(R.string.masterpassword_create_title).setView((View)linearLayout).setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("name", (Object)GeckoPreferences.PREFS_MP_ENABLED);
                            jSONObject.put("type", (Object)"string");
                            jSONObject.put("value", (Object)editText.getText().toString());
                            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Preferences:Set", jSONObject.toString());
                            GeckoAppShell.sendEventToGecko(geckoEvent);
                        }
                        catch (Exception exception) {
                            Log.e((String)GeckoPreferences.LOGTAG, (String)"Error setting master password", (Throwable)exception);
                        }
                    }
                }).setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                    }
                });
                alertDialog = builder.create();
                alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                        editText2.setText((CharSequence)"");
                        editText.requestFocus();
                    }
                });
                PasswordTextWatcher passwordTextWatcher = new PasswordTextWatcher(editText, editText2, alertDialog);
                editText.addTextChangedListener((TextWatcher)passwordTextWatcher);
                editText2.addTextChangedListener((TextWatcher)passwordTextWatcher);
                break;
            }
            case 1: {
                final EditText editText = this.getTextBox(R.string.masterpassword_password);
                linearLayout.addView((View)editText);
                builder.setTitle(R.string.masterpassword_remove_title).setView((View)linearLayout).setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        PrefsHelper.setPref(GeckoPreferences.PREFS_MP_ENABLED, editText.getText().toString());
                    }
                }).setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                    }
                });
                alertDialog = builder.create();
                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                    }
                });
                alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                    }
                });
                editText.addTextChangedListener((TextWatcher)new EmptyTextWatcher(editText, alertDialog));
                break;
            }
            default: {
                return null;
            }
        }
        return alertDialog;
    }

    private int getGeckoPreferences(final PreferenceGroup preferenceGroup, ArrayList<String> arrayList) {
        return PrefsHelper.getPrefs(arrayList, (PrefsHelper.PrefHandler)new PrefsHelper.PrefHandlerBase(){

            private Preference getField(String string2) {
                return preferenceGroup.findPreference((CharSequence)string2);
            }

            @Override
            public void prefValue(String string2, final boolean bl) {
                final Preference preference = this.getField(string2);
                final CheckBoxPrefSetter checkBoxPrefSetter = AppConstants.Versions.preICS ? new CheckBoxPrefSetter() : new TwoStatePrefSetter();
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        checkBoxPrefSetter.setBooleanPref(preference, bl);
                    }
                });
            }

            @Override
            public void prefValue(String string2, final String string3) {
                final Preference preference = this.getField(string2);
                if (preference instanceof EditTextPreference) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((EditTextPreference)preference).setText(string3);
                        }
                    });
                } else if (preference instanceof ListPreference) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((ListPreference)preference).setValue(string3);
                            CharSequence charSequence = ((ListPreference)preference).getEntry();
                            ((ListPreference)preference).setSummary(charSequence);
                        }
                    });
                } else if (preference instanceof FontSizePreference) {
                    final FontSizePreference fontSizePreference = (FontSizePreference)preference;
                    fontSizePreference.setSavedFontSize(string3);
                    final String string4 = fontSizePreference.getSavedFontSizeName();
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            fontSizePreference.setSummary(string4);
                        }
                    });
                }
            }

            @Override
            public void prefValue(String string2, int n) {
                Preference preference = this.getField(string2);
                Log.w((String)GeckoPreferences.LOGTAG, (String)("Unhandled int value for pref [" + preference + "]"));
            }

            @Override
            public boolean isObserver() {
                return true;
            }

            @Override
            public void finish() {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        preferenceGroup.setEnabled(true);
                    }
                });
            }

            class TwoStatePrefSetter
            extends CheckBoxPrefSetter {
                TwoStatePrefSetter() {
                }

                @Override
                public void setBooleanPref(Preference preference, boolean bl) {
                    if (preference instanceof TwoStatePreference && ((TwoStatePreference)preference).isChecked() != bl) {
                        ((TwoStatePreference)preference).setChecked(bl);
                    }
                }
            }

            class CheckBoxPrefSetter {
                CheckBoxPrefSetter() {
                }

                public void setBooleanPref(Preference preference, boolean bl) {
                    if (preference instanceof CheckBoxPreference && ((CheckBoxPreference)preference).isChecked() != bl) {
                        ((CheckBoxPreference)preference).setChecked(bl);
                    }
                }
            }
        });
    }

    @Override
    public boolean isGeckoActivityOpened() {
        return false;
    }

    public static void setResourceToOpen(Intent intent, String string2) {
        if (intent == null) {
            throw new IllegalArgumentException("intent must not be null");
        }
        if (string2 == null) {
            return;
        }
        if (AppConstants.Versions.preHC) {
            intent.putExtra(INTENT_EXTRA_RESOURCES, string2);
        } else {
            intent.putExtra(":android:show_fragment", GeckoPreferenceFragment.class.getName());
            Bundle bundle = new Bundle();
            bundle.putString(INTENT_EXTRA_RESOURCES, string2);
            intent.putExtra(":android:show_fragment_args", bundle);
        }
    }

    private class EmptyTextWatcher
    implements TextWatcher {
        EditText input;
        AlertDialog dialog;

        EmptyTextWatcher(EditText editText, AlertDialog alertDialog) {
            this.input = editText;
            this.dialog = alertDialog;
        }

        public void afterTextChanged(Editable editable) {
            if (this.dialog == null) {
                return;
            }
            String string2 = this.input.getText().toString();
            boolean bl = TextUtils.isEmpty((CharSequence)string2);
            this.dialog.getButton(-1).setEnabled(!bl);
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    private class PasswordTextWatcher
    implements TextWatcher {
        EditText input1;
        EditText input2;
        AlertDialog dialog;

        PasswordTextWatcher(EditText editText, EditText editText2, AlertDialog alertDialog) {
            this.input1 = editText;
            this.input2 = editText2;
            this.dialog = alertDialog;
        }

        public void afterTextChanged(Editable editable) {
            if (this.dialog == null) {
                return;
            }
            String string2 = this.input1.getText().toString();
            String string3 = this.input2.getText().toString();
            boolean bl = TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || !string2.equals(string3);
            this.dialog.getButton(-1).setEnabled(!bl);
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    public static interface PrefHandler {
        public boolean setupPref(Context var1, Preference var2);

        public void onChange(Context var1, Preference var2, Object var3);
    }
}

