/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.delegates.JSONRecordFetchDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.stage.AbstractNonRepositorySyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

public class FetchInfoCollectionsStage
extends AbstractNonRepositorySyncStage {
    @Override
    public void execute() throws NoSuchStageException {
        try {
            this.session.fetchInfoCollections(new StageInfoCollectionsDelegate());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.session.abort(uRISyntaxException, "Invalid URI.");
        }
    }

    public class StageInfoCollectionsDelegate
    implements JSONRecordFetchDelegate {
        @Override
        public void handleSuccess(ExtendedJSONObject extendedJSONObject) {
            FetchInfoCollectionsStage.this.session.config.infoCollections = new InfoCollections(extendedJSONObject);
            FetchInfoCollectionsStage.this.session.advance();
        }

        @Override
        public void handleFailure(SyncStorageResponse syncStorageResponse) {
            FetchInfoCollectionsStage.this.session.handleHTTPError(syncStorageResponse, "Failure fetching info/collections.");
        }

        @Override
        public void handleError(Exception exception) {
            FetchInfoCollectionsStage.this.session.abort(exception, "Failure fetching info/collections.");
        }
    }
}

