/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import org.mozilla.gecko.animation.HeightChangeAnimation;

public class AnimatedHeightLayout
extends RelativeLayout {
    private static final String LOGTAG = "GeckoAnimatedHeightLayout";
    private static final int ANIMATION_DURATION = 100;
    private boolean mAnimating;

    public AnimatedHeightLayout(Context context) {
        super(context, null);
    }

    public AnimatedHeightLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 0);
    }

    public AnimatedHeightLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = this.getMeasuredHeight();
        super.onMeasure(n, n2);
        int n4 = this.getMeasuredHeight();
        if (!this.mAnimating && n3 != 0 && n3 != n4) {
            this.mAnimating = true;
            this.setMeasuredDimension(this.getMeasuredWidth(), n3);
            HeightChangeAnimation heightChangeAnimation = new HeightChangeAnimation((View)this, n3, n4);
            heightChangeAnimation.setDuration(100L);
            heightChangeAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
            heightChangeAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    AnimatedHeightLayout.this.post(new Runnable(){

                        @Override
                        public void run() {
                            AnimatedHeightLayout.this.finishAnimation();
                        }
                    });
                }
            });
            this.startAnimation(heightChangeAnimation);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.finishAnimation();
    }

    void finishAnimation() {
        if (this.mAnimating) {
            this.getLayoutParams().height = -2;
            this.mAnimating = false;
        }
    }
}

